% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nexprs.R
\name{nexprs}
\alias{nexprs}
\alias{nexprs,ANY-method}
\alias{nexprs,SummarizedExperiment-method}
\title{Count the number of non-zero counts per cell or feature}
\usage{
nexprs(x, ...)

\S4method{nexprs}{ANY}(
  x,
  byrow = FALSE,
  detection_limit = 0,
  subset_row = NULL,
  subset_col = NULL,
  BPPARAM = SerialParam()
)

\S4method{nexprs}{SummarizedExperiment}(x, ..., exprs_values = "counts", assay.type = exprs_values)
}
\arguments{
\item{x}{A numeric matrix of counts where features are rows and cells are columns.

Alternatively, a \linkS4class{SummarizedExperiment} containing such counts.}

\item{...}{For the generic, further arguments to pass to specific methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.}

\item{byrow}{Logical scalar indicating whether to count the number of detected cells per feature.
If \code{FALSE}, the function will count the number of detected features per cell.}

\item{detection_limit}{Numeric scalar providing the value above which  observations are deemed to be expressed.}

\item{subset_row}{Logical, integer or character vector indicating which rows (i.e. features) to use.}

\item{subset_col}{Logical, integer or character vector indicating which columns (i.e., cells) to use.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether the calculations should be parallelized.
Only relevant when \code{x} is a \linkS4class{DelayedMatrix}.}

\item{exprs_values}{Alias for \code{assay.type}.}

\item{assay.type}{String or integer specifying the assay of \code{x} to obtain the count matrix from (also the alias \code{exprs_values} is accepted for this argument).}
}
\value{
An integer vector containing counts per gene or cell, depending on the provided arguments.
}
\description{
Counting the number of non-zero counts in each row (per feature) or column (per cell).
}
\examples{
example_sce <- mockSCE()

nexprs(example_sce)[1:10]
nexprs(example_sce, byrow = TRUE)[1:10]

}
\seealso{
\code{\link{numDetectedAcrossFeatures}} and \code{\link{numDetectedAcrossCells}}, 
to do this calculation for each group of features or cells, respectively.
}
\author{
Aaron Lun
}
