% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5P.R
\name{H5Pall_filters_avail}
\alias{H5Pall_filters_avail}
\alias{H5Pget_nfilters}
\alias{H5Pget_filter}
\title{Query dataset filter properties.}
\usage{
H5Pall_filters_avail(h5plist)

H5Pget_nfilters(h5plist)

H5Pget_filter(h5plist, idx)
}
\arguments{
\item{h5plist}{Object of class \linkS4class{H5IdComponent} representing a dataset
creation property list.}

\item{idx}{Integer of length 1.  This argument selects which filter to return
information about.  Indexing is R-style 1-based.}
}
\description{
Return information about the filter pipeline applied to a dataset creation
property list.
}
\details{
\itemize{
\item \code{H5Pall_filters_avail()} checks whether all filters required to process a
dataset are available to \strong{rhdf5}.  This can be required if reading files
created with other HDF5 software.
\item \code{H5Pget_nfilters()} returns the number of
filters in the dataset chunk processing pipeline.
\item \code{H5Pget_filter()}
provides details of a specific filter in the pipeline. This includes the
filter name and the parameters provided to it e.g. compression level.
}
}
