% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-methods.R
\docType{methods}
\name{merge_taxa}
\alias{merge_taxa}
\alias{merge_taxa,phyloseq-method}
\alias{merge_taxa,sample_data-method}
\alias{merge_taxa,otu_table-method}
\alias{merge_taxa,phylo-method}
\alias{merge_taxa,XStringSet-method}
\alias{merge_taxa,taxonomyTable-method}
\title{Merge a subset of the species in \code{x} into one species/taxa/OTU.}
\usage{
merge_taxa(x, eqtaxa, archetype=1)

\S4method{merge_taxa}{phyloseq}(x, eqtaxa,
  archetype = eqtaxa[which.max(taxa_sums(x)[eqtaxa])])

\S4method{merge_taxa}{sample_data}(x, eqtaxa, archetype = 1L)

\S4method{merge_taxa}{otu_table}(x, eqtaxa,
  archetype = eqtaxa[which.max(taxa_sums(x)[eqtaxa])])

\S4method{merge_taxa}{phylo}(x, eqtaxa, archetype = 1L)

\S4method{merge_taxa}{XStringSet}(x, eqtaxa, archetype = 1L)

\S4method{merge_taxa}{taxonomyTable}(x, eqtaxa, archetype = 1L)
}
\arguments{
\item{x}{(Required). An object that describes species (taxa). This includes
\code{\link{phyloseq-class}}, \code{\link{otu_table-class}}, \code{\link{taxonomyTable-class}}, 
\code{\link[ape]{phylo}}.}

\item{eqtaxa}{(Required). The species names, or indices, that should be merged together.
If \code{length(eqtaxa) < 2}, then the object \code{x} will be returned
safely unchanged.}

\item{archetype}{(Optional). A single-length numeric or character.
The index of \code{eqtaxa}, or OTU ID,
indicating the species that should be kept to represent
the summed/merged group of species/taxa/OTUs. 
The default is to use the OTU with the largest count total 
if counts are available, or to use \code{1}
(the first OTU in \code{eqtaxa}) otherwise.
If \code{archetype} is not a valid index or index-name in \code{eqtaxa},
the first will be used, and the value in archetype will be used 
as the index-name for the new species.}
}
\value{
The object, \code{x}, in its original class, but with the specified
  species merged into one entry in all relevant components.
}
\description{
Takes as input an object that describes species/taxa
(e.g. \code{\link{phyloseq-class}}, \code{\link{otu_table-class}}, 
 \code{\link{phylo-class}}, \code{\link{taxonomyTable-class}}),
as well as 
a vector of species that should be merged.
It is intended to be able to operate at a low-level such that 
related methods, such as \code{\link{tip_glom}} and \code{\link{tax_glom}}
can both reliably call \code{merge_taxa} for their respective purposes.
}
\examples{
#
data(esophagus)
tree <- phy_tree(esophagus)
otu  <- otu_table(esophagus)
otutree0 <- phyloseq(otu, tree)
# plot_tree(otutree0)
otutree1 <- merge_taxa(otutree0, 1:8, 2)
# plot_tree(esophagus, ladderize="left")
}
\seealso{
\code{\link{tip_glom}}, \code{\link{tax_glom}}, \code{\link{merge_phyloseq}},
 \code{\link{merge_samples}}
}
