\name{degenes}
\alias{degenes}

\title{
Recovering differencially expressed features.
}
\description{
Recovering differencially expressed features for a given threshold from \code{noiseq} or \code{noiseqbio} output objects.
}
\usage{
degenes(object, q = 0.95, M = NULL)
}

\arguments{
  \item{object}{
Object of class \code{\link{Output}}.
}
  \item{q}{
Value for the probability threshold (by default, 0.95).
}
  \item{M}{
String indicating if all differentially expressed features are to be returned or only up or down-regulated features. The possible values are:
"up" (up-regulated in condition 1), "down" (down-regulated in condition 1), or NULL (all differentially expressed features).
}
}
\value{
A matrix containing the differencially expressed features, the statistics and the probability of differential expression.
}
\author{
Sonia Tarazona
}


\seealso{
       \code{\link{readData}}, \code{\link{noiseq}}, \code{\link{noiseqbio}}.
     }

\examples{
## Load the object mynoiseq generated by computing differential expression probability with noiseq() on Marioni's data:
data(noiseq)

## Third, use degenes() function to extract differentially expressed features:
mynoiseq.deg = degenes(mynoiseq, q = 0.8, M = NULL)

}

\references{
Marioni, J.C. and Mason, C.E. and Mane, S.M. and Stephens, M. and Gilad, Y. (2008) RNA-seq: an assessment of
technical reproducibility and comparison with gene expression arrays. \emph{Genome Research}, \bold{18}:
1509--1517.
}
