# MutationalPatterns

The MutationalPatterns R package provides a comprehensive set of flexible
functions for easy finding and plotting of mutational patterns in mutation
catalogues. Single nucleotide variants (SNVs), insertions and deletions
(Indels), double base substitutions (DBSs) and larger multi base substitutions
(MBSs) are supported.

## Citation

Please give credit and cite MutationalPatterns R Package when you use it for
your data analysis. A paper for the newest version of the package is in the
works. The original MutationalPatterns paper is published in Genome Medicine
[Blokzijl et al. 2018](https://doi.org/10.1186/s13073-018-0539-0).


## Dev version

To use the current development version of the package, you should first clone it
from GitHub. Next, you can load it using:
```r
devtools::load_all(DIR)
```

A raw version of the new vignette can be found
[here](../master/vignettes/Introduction_to_MutationalPatterns.Rmd)

## Bioconductor version

Please use [Bioconductor](http://bioconductor.org/packages/MutationalPatterns/)
to install the released version of this package.  In [Introduction to MutationalPatterns](https://bioconductor.org/packages/release/bioc/vignettes/MutationalPatterns/inst/doc/Introduction_to_MutationalPatterns.html) you can find
comprehensive examples and explanations for the functions this package
provides.
