% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_signatures.R
\name{merge_signatures}
\alias{merge_signatures}
\title{Merge signatures based on cosine similarity}
\usage{
merge_signatures(
  signatures,
  cos_sim_cutoff = 0.8,
  merge_char = ";",
  verbose = TRUE
)
}
\arguments{
\item{signatures}{Signature matrix (dimensions: x mutation types
X n signatures)}

\item{cos_sim_cutoff}{Cutoff for cosine similarity. Signatures are merged when their
cosine similarity is higher than the limit. Default: 0.8}

\item{merge_char}{Character used to merge the signature names. This character shouldn't
be in the signature names beforehand. Default: ";"}

\item{verbose}{Verbosity. If TRUE it shows which signatures got merged. Default: TRUE}
}
\value{
Signature matrix (dimensions: x mutation types
X n signatures)
}
\description{
This function merges signatures based on their cosine similarity.
It iteratively merges the two signatures with the highest cosine similarity.
Merging is stopped when the maximum cosine similarity is lower than the limit.
}
\examples{

## Get signatures
signatures <- get_known_signatures()

## Merge signatures
merge_signatures(signatures)


## Merge signatures using a stricter cutoff
merge_signatures(signatures, cos_sim_cutoff = 0.9)

## Merge signatures using a different merging character
merge_signatures(signatures, merge_char = "_")

## Merge signatures silently
merge_signatures(signatures, verbose = FALSE)
}
