% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mut_type.R
\name{get_mut_type}
\alias{get_mut_type}
\title{Get variants with mut_type from GRanges}
\usage{
get_mut_type(
  vcf_list,
  type = c("snv", "indel", "dbs", "mbs"),
  predefined_dbs_mbs = FALSE
)
}
\arguments{
\item{vcf_list}{GRanges/GRangesList}

\item{type}{The type of variant that will be returned.}

\item{predefined_dbs_mbs}{Boolean. Whether dbs and mbs variants have been
predefined in your vcf. This function by default assumes that dbs and mbs
variants are present in the vcf as snvs, which are positioned next to each
other. If your dbs/mbs variants are called separately you should set this
argument to TRUE. (default = FALSE)}
}
\value{
GRanges/GRangesList of the desired mutation type.
}
\description{
Get the variants of a certain mutation type from a GRanges or GRangesList object.
All other variants will be filtered out.
It is assumed that DBS/MBSs are called as separate SNVs.
They are merged into single variants.
The type of variant can be chosen with type.
}
\examples{
## Get a GRanges list object.
## See 'read_vcfs_as_granges' for more info how to do this.
grl <- readRDS(system.file("states/blood_grl.rds",
  package = "MutationalPatterns"
))

## Here we only use two samples to reduce runtime
grl <- grl[1:2]

## Get a specific mutation type.
snv_grl <- get_mut_type(grl, "snv")
indel_grl <- get_mut_type(grl, "indel")
dbs_grl <- get_mut_type(grl, "dbs")
mbs_grl <- get_mut_type(grl, "mbs")
}
\seealso{
\code{\link{read_vcfs_as_granges}}
}
