% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_indel_contexts.R
\name{count_indel_contexts}
\alias{count_indel_contexts}
\title{Count indel contexts}
\usage{
count_indel_contexts(vcf_list)
}
\arguments{
\item{vcf_list}{GRanges or GRangesList object containing indel mutations in which the context was added with get_indel_context.}
}
\value{
A tibble containing the number of indels per COSMIC context per gr.
}
\description{
Count indel contexts
}
\details{
Counts the number of indels per COSMIC context from a GRanges or GRangesList object containing indel mutations.
This function applies the count_indel_contexts_gr function to each gr in its input.
It then combines the results in a single tibble and returns this.
}
\examples{
## Get a GRangesList or GRanges object with indel contexts.
## See 'indel_get_context' for more info on how to do this.
grl_indel_context <- readRDS(system.file("states/blood_grl_indel_context.rds",
  package = "MutationalPatterns"
))

# Count the indel contexts
count_indel_contexts(grl_indel_context)
}
\seealso{
\code{\link{get_indel_context}}

Other Indels: 
\code{\link{get_indel_context}()},
\code{\link{plot_compare_indels}()},
\code{\link{plot_indel_contexts}()},
\code{\link{plot_main_indel_contexts}()}
}
\concept{Indels}
