% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetSamples.R
\name{upsetSamples}
\alias{upsetSamples}
\title{Create a generalized Venn Diagram analog for sample membership in multiple
assays, using the upset algorithm in \code{UpSetR}}
\usage{
upsetSamples(
  MultiAssayExperiment,
  nsets = NULL,
  sets = names(MultiAssayExperiment),
  nintersects = NA_integer_,
  order.by = "freq",
  check.names = FALSE,
  ...
)
}
\arguments{
\item{MultiAssayExperiment}{A \code{MultiAssayExperiment} object}

\item{nsets}{numeric(1) The number of sets to analyze. If specified,
\code{sets} will be ignored.}

\item{sets}{character() A character vector of names in MultiAssayExperiment
to use. If specified, \code{nsets} will be ignored.}

\item{nintersects}{numeric() The number of intersections to plot. By
default, all intersections will be plotted.}

\item{order.by}{How the intersections in the matrix should be ordered by.
Options include frequency (entered as "freq"), degree, or both in any order.}

\item{check.names}{logical(1) Whether to munge names as in the
\code{data.frame()} constructor (default FALSE).}

\item{...}{parameters passed to \code{\link[UpSetR]{upset}}}
}
\value{
Produces a visualization of set intersections using the UpSet matrix
design
}
\description{
Create a generalized Venn Diagram analog for sample membership in multiple
assays, using the upset algorithm in \code{UpSetR}
}
\note{
This function is intended to provide convenient visualization of assay
availability configurations in MultiAssayExperiment instances. The
\code{UpSetR::upset} function requires \code{data.frame} input and has
many parameters to tune appearance of the result. Assay name handling is
important for interpretability.
}
\examples{

data(miniACC)
upsetSamples(miniACC)
upsetSamples(miniACC, nsets = 3, nintersects = 3)

}
\author{
Vincent J Carey
}
