% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_factors.R
\name{plot_factor_cor}
\alias{plot_factor_cor}
\title{Plot correlation matrix between latent factors}
\usage{
plot_factor_cor(object, method = "pearson", ...)
}
\arguments{
\item{object}{a trained \code{\link{MOFA}} object.}

\item{method}{a character indicating the type of correlation coefficient to be computed: pearson (default), kendall, or spearman.}

\item{...}{arguments passed to \code{\link[corrplot]{corrplot}}}
}
\value{
Returns a symmetric matrix with the correlation coefficient between every pair of factors.
}
\description{
Function to plot the correlation matrix between the latent factors.
}
\details{
This method plots the correlation matrix between the latent factors. \cr 
The model encourages the factors to be uncorrelated, so this function usually yields a diagonal correlation matrix. \cr 
However, it is not a hard constraint such as in Principal Component Analysis and correlations between factors can occur, 
particularly with large number factors. \cr
Generally, correlated factors are redundant and should be avoided, as they make interpretation harder. Therefore, 
if you have too many correlated factors we suggest you try reducing the number of factors.
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)

# Plot correlation between all factors
plot_factor_cor(model)

}
