% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subsetViews}
\alias{subsetViews}
\title{Subset views}
\usage{
subsetViews(object, views)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view names, numeric vector with the view indices
or logical vector with the view to be kept as TRUE.}
}
\value{
\code{\link{MOFAmodel}} object with a subset of views
}
\description{
Method to subset (or sort) views.
This function can remove entire views from the model. 
For example, you might want to generate the \code{\link{plotVarianceExplained}} plot
 excluding a particular view. \cr
This functionality is only for exploratory purposes.
If some view(s) are not of interest we strongly recommend removing them before training the model.
}
\examples{
# Using an existing trained model on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
# Subset views via character vector
MOFA_CLL_small <- subsetViews(MOFA_CLL, views=c("Drugs","Methylation"))
MOFA_CLL_small
# Subset views via numeric vector
MOFA_CLL_small <- subsetViews(MOFA_CLL, views=2:3)
MOFA_CLL_small

}
