% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subsetSamples}
\alias{subsetSamples}
\title{Subset samples}
\usage{
subsetSamples(object, samples)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{samples}{character vector with the sample names, numeric vector with the sample indices or 
logical vector with the samples to be kept as TRUE.}
}
\value{
\code{\link{MOFAmodel}} object with a subset of samples
}
\description{
Method to subset (or sort) samples. \cr
This function can remove samples from the model. For example,
you might want to observe the effect of Factor 1 on a subset of samples.
You can create a new \code{\link{MOFAmodel}} excluding some samples
and then visualise the effect of Factor 1 on the remaining ones, for instance via 
\code{\link{plotDataHeatmap}} or \code{\link{plotFactorScatter}}. \cr
This functionality is only for exploratory purposes. 
In the case of outliers, we strongly recommend removing them before training the model.
}
\examples{
# Using an existing trained model on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
# Subset samples via character vector
MOFA_CLL_small <- subsetSamples(MOFA_CLL, samples=c("H045","H109","H024","H056"))
MOFA_CLL_small
# Subset samples via numeric vector
MOFA_CLL_small <- subsetSamples(MOFA_CLL, samples=1:10)
MOFA_CLL_small
}
