% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotData.R
\name{plotDataHeatmap}
\alias{plotDataHeatmap}
\title{Plot heatmap of relevant features}
\usage{
plotDataHeatmap(object, view, factor, features = 50,
  includeWeights = FALSE, transpose = FALSE, imputed = FALSE, ...)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{view}{character vector with the view name, or numeric vector with the index of the view.}

\item{factor}{character vector with the factor name, or numeric vector with the index of the factor.}

\item{features}{if an integer, the total number of top features to plot,
 based on the absolute value of the loading.
If a character vector, a set of manually-defined features. 
Default is 50.}

\item{includeWeights}{logical indicating whether to include the weight
of each feature as an extra annotation in the heatmap. Default is FALSE.}

\item{transpose}{logical indicating whether to transpose the output heatmap. 
Default corresponds to features as rows and samples as columns.}

\item{imputed}{logical indicating whether to plot the imputed data instead of the original data. 
Default is FALSE.}

\item{...}{further arguments that can be passed to \code{\link[pheatmap]{pheatmap}}}
}
\value{
plots a heatmap of the data for the top features for a given factor and views
}
\description{
Function to plot a heatmap of the input data for relevant features, 
usually the ones with highest loadings in a given factor.
}
\details{
One of the first steps for the annotation of a given factor
 is to visualise the corresponding loadings, 
using for example \code{\link{plotWeights}} or \code{\link{plotTopWeights}}.
These functions display the top features that are driving the heterogeneity captured by a factor. \cr
However, one might also be interested in visualising the coordinated heterogeneity in the input data, 
rather than looking at "abstract" weights. \cr
This function extracts the top features for a given factor and view, 
and generates a heatmap with dimensions (samples,features). This should reveal
the underlying heterogeneity that is captured by the latent factor. \cr
A similar function for doing scatterplots rather than heatmaps is \code{\link{plotDataScatter}}.
}
\examples{
# Load CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
# plot top 30 features on Factor 1 in the mRNA view
plotDataHeatmap(MOFA_CLL, view="mRNA", factor=1, features=30)
# without column names (extra arguments passed to pheatmap)
plotDataHeatmap(MOFA_CLL, view="mRNA", factor=1, features=30, show_colnames = FALSE)
# transpose the heatmap
plotDataHeatmap(MOFA_CLL, view="mRNA", factor=1, features=30, transpose=TRUE)
# do not cluster rows (extra arguments passed to pheatmap)
plotDataHeatmap(MOFA_CLL, view="mRNA", factor=1, features=30, cluster_rows=FALSE)
}
