% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{factorNames}
\alias{factorNames}
\alias{factorNames<-}
\alias{factorNames,MOFAmodel-method}
\alias{factorNames<-,MOFAmodel,vector-method}
\title{factorNames: set and retrieve factor names}
\usage{
factorNames(object)

factorNames(object) <- value

\S4method{factorNames}{MOFAmodel}(object)

\S4method{factorNames}{MOFAmodel,vector}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{value}{a character vector of factor names}
}
\value{
character vector with the features names
}
\description{
Function to set and retrieve factor names.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
factorNames(MOFAobject)
factorNames(MOFAobject) <- paste("Factor",1:3,sep="_")
factorNames(MOFAobject)
}
