% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{ImputedData}
\alias{ImputedData}
\alias{ImputedData<-}
\alias{ImputedData,MOFAmodel-method}
\alias{ImputedData<-,MOFAmodel,list-method}
\title{ImputedData: set and retrieve imputed data}
\usage{
ImputedData(object)

ImputedData(object) <- value

\S4method{ImputedData}{MOFAmodel}(object)

\S4method{ImputedData}{MOFAmodel,list}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{value}{a list of matrices containing the imputed data}
}
\value{
list of matrices containing the imputed data
}
\description{
Function to set and retrieve imputed data.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
MOFAobject <- impute(MOFAobject)
str(ImputedData(MOFAobject))
}
