% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{ssPermAnalysis}
\alias{ssPermAnalysis}
\title{smoothing-splines anova fits for each permutation}
\usage{
ssPermAnalysis(
  data,
  formula,
  permList,
  intTimes,
  timePoints,
  include = c("class", "time:class"),
  ...
)
}
\arguments{
\item{data}{Data used in estimation.}

\item{formula}{Formula for ssanova. Of the form: abundance ~ ... where ... includes any pData slot value.}

\item{permList}{A list of permutted class memberships}

\item{intTimes}{Interesting time intervals.}

\item{timePoints}{Time points to interpolate over.}

\item{include}{Parameters to include in prediction.}

\item{...}{Options for ssanova}
}
\value{
A matrix of permutted area estimates for time intervals of interest.
}
\description{
Calculates the fit for each permutation and estimates 
the area under the null (permutted) model for interesting time 
intervals of differential abundance.
}
\examples{

# Not run

}
\seealso{
\code{\link{cumNorm}} \code{\link{fitTimeSeries}} \code{\link{ssFit}} \code{\link{ssPerm}} \code{\link{ssIntervalCandidate}}
}
