% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnaseq.R
\name{getRNASeqData}
\alias{getRNASeqData}
\title{Get GEO RNA-seq quantifications as a SummarizedExperiment object}
\usage{
getRNASeqData(accession)
}
\arguments{
\item{accession}{GEO accession number}
}
\value{
A SummarizedExperiment object with the raw counts as the counts
assay, the annotation as the rowData, and the metadata from GEO as
the colData.
}
\description{
For human and mouse GEO datasets, NCBI GEO attempts to process
the raw data and provide quantifications in the form of raw counts
and an annotation file. This function downloads the raw counts and
annotation files from GEO and merges that with the metadata from the GEO
object to create a SummarizedExperiment.
}
\details{
A major barrier to fully exploiting and reanalyzing the massive volumes
of public RNA-seq data archived by SRA is the cost and effort required to
consistently process raw RNA-seq reads into concise formats that summarize
the expression results. To help address this need, the NCBI SRA and GEO
teams have built a pipeline that precomputes RNA-seq gene expression counts
and delivers them as count matrices that may be incorporated into commonly
used differential expression analysis and visualization software.

The pipeline processes RNA-seq data from SRA using the HISAT2 aligner and
and then generates gene expression counts using the featureCounts program.

See the
\href{https://ncbi.nlm.nih.gov/geo/info/rnaseqcounts.html}{GEO documentation}
for more details.
}
\examples{
se <- getRNASeqData("GSE164073")
se

}
