% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{design,DESeqDataSet-method}
\alias{design,DESeqDataSet-method}
\alias{design<-,DESeqDataSet,formula-method}
\alias{design<-,DESeqDataSet,matrix-method}
\title{Accessors for the 'design' slot of a DESeqDataSet object.}
\usage{
\S4method{design}{DESeqDataSet}(object)

\S4method{design}{DESeqDataSet,formula}(object) <- value

\S4method{design}{DESeqDataSet,matrix}(object) <- value
}
\arguments{
\item{object}{a \code{DESeqDataSet} object}

\item{value}{a \code{formula} used for estimating dispersion
and fitting Negative Binomial GLMs}
}
\description{
The design holds the R \code{formula} which expresses how the
counts depend on the variables in \code{colData}.
See \code{\link{DESeqDataSet}} for details.
}
\examples{

dds <- makeExampleDESeqDataSet(m=4)
design(dds) <- formula(~ 1)

}
