% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorModels.R
\name{noqualErrfun}
\alias{noqualErrfun}
\title{Estimate error rates for each type of transition while ignoring quality scores.}
\usage{
noqualErrfun(trans, pseudocount = 1)
}
\arguments{
\item{trans}{(Required). A matrix of the observed transition counts. Must be 16 rows,
with the rows named "A2A", "A2C", ...}

\item{pseudocount}{(Optional). Default 1. 
Added to each type of transition.}
}
\value{
A numeric matrix with 16 rows and the same number of columns as trans.
 The estimated error rates for each transition (row, eg. "A2C") are identical across
 all columns (which correspond to quality scores).
}
\description{
This function accepts a matrix of observed transitions, groups together all observed
transitions regardless of quality scores, and estimates the error rate for that transition
as the observed fraction of those transitions. This can be used in place of the default
\code{\link{loessErrfun}} when calling \code{\link{learnErrors}} or \code{link{dada}}
with the effect that quality scores will be effectively ignored.
}
\examples{
fl1 <- system.file("extdata", "sam1F.fastq.gz", package="dada2")
err.noqual <- learnErrors(fl1, errorEstimationFunction=noqualErrfun)

}
