% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rc}
\alias{rc}
\title{Reverse complement DNA sequences.}
\usage{
rc(sq)
}
\arguments{
\item{sq}{(Required). \code{character}. The DNA sequence(s) to reverse-complement.
\code{\link[Biostrings]{DNAString}}, or \code{\link[Biostrings]{DNAStringSet}} formats
are also accepted.}
}
\value{
\code{character}. The reverse-complemented DNA sequence(s).
}
\description{
This function reverse complements DNA sequence(s) provided.
This function is nothing more than a concisely-named convenience wrapper for 
\code{\link[Biostrings]{reverseComplement}} that handles the \code{character} vector
DNA sequences generated in the the dada2 package.
}
\examples{
R1492 <- "RGYTACCTTGTTACGACTT"
rc(R1492)
sqs <- getSequences(system.file("extdata", "example_seqs.fa", package="dada2"))
rc(sqs)

}
\seealso{
\code{\link[Biostrings]{reverseComplement}}
}
