% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorModels.R
\name{inflateErr}
\alias{inflateErr}
\title{Inflates an error rate matrix by a specified factor, while accounting for saturation.}
\usage{
inflateErr(err, inflation, inflateSelfTransitions = FALSE)
}
\arguments{
\item{err}{(Required). A numeric matrix of transition rates (16 rows, named "A2A", "A2C", ...).}

\item{inflation}{(Required). The fold-factor by which to inflate the transition rates.}

\item{inflateSelfTransitions}{(Optional). Default FALSE.
If True, self-transitions (eg. A->A) are also inflated.}
}
\value{
An error rate matrix of the same dimensions as the input error rate matrix.
}
\description{
Error rates are "inflated" by the specified factor, while appropriately saturating so that rates
cannot exceed 1. The formula is:
  new_err_rate <- err_rate * inflate / (1 + (inflate-1) * err_rate)
}
\examples{
 tperr2 <- inflateErr(tperr1, 2)
 tperr3.all <- inflateErr(tperr1, 3, inflateSelfTransitions=TRUE)

}
