% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/buildIndex.R
\name{buildIndex}
\alias{buildIndex}
\alias{buildIndex,matrix,NULL-method}
\alias{buildIndex,matrix,missing-method}
\alias{buildIndex,matrix,BiocNeighborParam-method}
\alias{buildIndex,matrix,list-method}
\title{Build a nearest-neighbor index}
\usage{
buildIndex(X, transposed = FALSE, ..., BNPARAM = NULL)
}
\arguments{
\item{X}{A numeric matrix where rows correspond to data points and columns correspond to variables (i.e., dimensions).}

\item{transposed}{Logical scalar indicating whether \code{X} is transposed, i.e., rows are variables and columns are data points.}

\item{...}{Further arguments to be passed to individual methods.}

\item{BNPARAM}{A \linkS4class{BiocNeighborParam} object specifying the type of index to be constructed.
If \code{NULL}, this defaults to a \linkS4class{KmknnParam} object. 

Alternatively, this may be a list returned by \code{\link{defineBuilder}}.}
}
\value{
A \linkS4class{BiocNeighborIndex} object can be used in \code{\link{findKNN}} and related functions as the \code{X=} argument.
Users should assume that the index is not serializable, i.e., cannot be saved or transferred between processes.
}
\description{
Build indices for nearest-neighbor searching with different algorithms.
}
\details{
Each \code{buildIndex} method is expected to return an instance of a \linkS4class{BiocNeighborIndex} subclass.
The structure of this subclass is arbitrary and left to the discretion of the method developer.
Developers are also responsible for defining methods for their subclass in each of the relevant functions (e.g., \code{\link{findKNN}}, \code{\link{queryKNN}}).
The exception is if the method returns an instance of a \linkS4class{BiocNeighborGenericIndex} subclass,
which can be used with the existing methods for \code{\link{findKNN}}, etc. without further effort.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
(k.out <- buildIndex(Y))
(a.out <- buildIndex(Y, BNPARAM=AnnoyParam()))

}
\author{
Aaron Lun
}
