% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgcvExports.R
\name{Sl.repara}
\alias{Sl.repara}
\title{Applying re-parameterization from log-determinant of penalty matrix to
model matrix.}
\usage{
Sl.repara(rp, X, inverse = FALSE, both.sides = TRUE)
}
\arguments{
\item{rp}{reparametrization.}

\item{X}{if \code{X} is a matrix it is assumed to be a model matrix 
whereas if \code{X} is a vector it is assumed to be a parameter vector.}

\item{inverse}{if \code{TRUE} an inverse re-parametrization is performed.}

\item{both.sides}{if \code{inverse==TRUE} and \code{both.sides==FALSE} then
the re-parametrization only applied to rhs, as appropriate for a choleski factor.
If \code{both.sides==FALSE}, \code{X} is a vector and \code{inverse==FALSE} then \code{X} is
taken as a coefficient vector (so re-parametrization is inverse of that for the model matrix).}
}
\value{
A re-parametrized version of \code{X}.
}
\description{
INTERNAL routine to apply re-parameterization from log-determinant of penalty matrix, \code{ldetS} to
model matrix, \code{X}, blockwise.
}
\author{
Simon N. Wood <simon.wood@r-project.org>.
}
