# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SecondaryAuthTokenList(ListResource):

    def __init__(self, version):
        """
        Initialize the SecondaryAuthTokenList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenList
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenList
        """
        super(SecondaryAuthTokenList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a SecondaryAuthTokenContext

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        """
        return SecondaryAuthTokenContext(self._version, )

    def __call__(self):
        """
        Constructs a SecondaryAuthTokenContext

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        """
        return SecondaryAuthTokenContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Accounts.V1.SecondaryAuthTokenList>'


class SecondaryAuthTokenPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the SecondaryAuthTokenPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenPage
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenPage
        """
        super(SecondaryAuthTokenPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SecondaryAuthTokenInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        """
        return SecondaryAuthTokenInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Accounts.V1.SecondaryAuthTokenPage>'


class SecondaryAuthTokenContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the SecondaryAuthTokenContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        """
        super(SecondaryAuthTokenContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/AuthTokens/Secondary'.format(**self._solution)

    def create(self):
        """
        Create the SecondaryAuthTokenInstance

        :returns: The created SecondaryAuthTokenInstance
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        """
        payload = self._version.create(method='POST', uri=self._uri, )

        return SecondaryAuthTokenInstance(self._version, payload, )

    def delete(self):
        """
        Deletes the SecondaryAuthTokenInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Accounts.V1.SecondaryAuthTokenContext {}>'.format(context)


class SecondaryAuthTokenInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the SecondaryAuthTokenInstance

        :returns: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        """
        super(SecondaryAuthTokenInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'secondary_auth_token': payload.get('secondary_auth_token'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SecondaryAuthTokenContext for this SecondaryAuthTokenInstance
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenContext
        """
        if self._context is None:
            self._context = SecondaryAuthTokenContext(self._version, )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that the secondary Auth Token was created for
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 formatted date and time in UTC when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 formatted date and time in UTC when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def secondary_auth_token(self):
        """
        :returns: The generated secondary Auth Token
        :rtype: unicode
        """
        return self._properties['secondary_auth_token']

    @property
    def url(self):
        """
        :returns: The URI for this resource, relative to `https://accounts.twilio.com`
        :rtype: unicode
        """
        return self._properties['url']

    def create(self):
        """
        Create the SecondaryAuthTokenInstance

        :returns: The created SecondaryAuthTokenInstance
        :rtype: twilio.rest.accounts.v1.secondary_auth_token.SecondaryAuthTokenInstance
        """
        return self._proxy.create()

    def delete(self):
        """
        Deletes the SecondaryAuthTokenInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Accounts.V1.SecondaryAuthTokenInstance {}>'.format(context)
