#!/usr/bin/env python
import logging
import sys

from ncclient import manager


def connect(host, port, user, password):
    conn = manager.connect(host=host,
                           port=port,
                           username=user,
                           password=password,
                           timeout=60,
                           device_params={'name': 'junos'},
                           hostkey_verify=False)

    result = conn.get_chassis_inventory()
    logging.info("Chassis: %s", result.xpath('//chassis/description')[0].text)
    logging.info("Chassis Serial-Number: %s", result.xpath('//chassis/serial-number')[0].text)


if __name__ == '__main__':
    LOG_FORMAT = '%(asctime)s %(levelname)s %(filename)s:%(lineno)d %(message)s'
    logging.basicConfig(stream=sys.stdout, level=logging.INFO, format=LOG_FORMAT)

    connect('router', 830, 'netconf', 'juniper!')
