"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2014 The Chromium Authors. All rights reserved.
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.

Request and reply to the "checkin server" devices poll every few hours.
"""

from . import android_checkin_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class GservicesSetting(google.protobuf.message.Message):
    """A concrete name/value pair sent to the device's Gservices database."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.bytes
    value: builtins.bytes
    def __init__(
        self,
        *,
        name: builtins.bytes | None = ...,
        value: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]
    ) -> builtins.bool: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]
    ) -> None: ...

global___GservicesSetting = GservicesSetting

@typing_extensions.final
class AndroidCheckinRequest(google.protobuf.message.Message):
    """Devices send this every few hours to tell us how they're doing."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMEI_FIELD_NUMBER: builtins.int
    MEID_FIELD_NUMBER: builtins.int
    MAC_ADDR_FIELD_NUMBER: builtins.int
    MAC_ADDR_TYPE_FIELD_NUMBER: builtins.int
    SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    ESN_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    LOGGING_ID_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    LOCALE_FIELD_NUMBER: builtins.int
    CHECKIN_FIELD_NUMBER: builtins.int
    DESIRED_BUILD_FIELD_NUMBER: builtins.int
    MARKET_CHECKIN_FIELD_NUMBER: builtins.int
    ACCOUNT_COOKIE_FIELD_NUMBER: builtins.int
    TIME_ZONE_FIELD_NUMBER: builtins.int
    SECURITY_TOKEN_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    OTA_CERT_FIELD_NUMBER: builtins.int
    FRAGMENT_FIELD_NUMBER: builtins.int
    USER_NAME_FIELD_NUMBER: builtins.int
    USER_SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    imei: builtins.str
    """IMEI (used by GSM phones) is sent and stored as 15 decimal
    digits; the 15th is a check digit.
    IMEI, reported but not logged.
    """
    meid: builtins.str
    """MEID (used by CDMA phones) is sent and stored as 14 hexadecimal
    digits (no check digit).
    MEID, reported but not logged.
    """
    @property
    def mac_addr(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """MAC address (used by non-phone devices).  12 hexadecimal digits;
        no separators (eg "0016E6513AC2", not "00:16:E6:51:3A:C2").
        MAC address, reported but not logged.
        """
    @property
    def mac_addr_type(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """An array parallel to mac_addr, describing the type of interface.
        Currently accepted values: "wifi", "ethernet", "bluetooth".  If
        not present, "wifi" is assumed.
        """
    serial_number: builtins.str
    """Serial number (a manufacturer-defined unique hardware
    identifier).  Alphanumeric, case-insensitive.
    """
    esn: builtins.str
    """Older CDMA networks use an ESN (8 hex digits) instead of an MEID.
    ESN, reported but not logged
    """
    id: builtins.int
    """Android device ID, not logged"""
    logging_id: builtins.int
    """Pseudonymous logging ID for Sawmill"""
    digest: builtins.str
    """Digest of device provisioning, not logged."""
    locale: builtins.str
    """Current locale in standard (xx_XX) format"""
    @property
    def checkin(self) -> android_checkin_pb2.AndroidCheckinProto: ...
    desired_build: builtins.str
    """DEPRECATED, see AndroidCheckinProto.requested_group"""
    market_checkin: builtins.str
    """Blob of data from the Market app to be passed to Market API server"""
    @property
    def account_cookie(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """SID cookies of any google accounts stored on the phone.  Not logged."""
    time_zone: builtins.str
    """Time zone.  Not currently logged."""
    security_token: builtins.int
    """Security token used to validate the checkin request.
    Required for android IDs issued to Froyo+ devices, not for legacy IDs.
    """
    version: builtins.int
    """Version of checkin protocol.

    There are currently two versions:

    - version field missing: android IDs are assigned based on
      hardware identifiers.  unsecured in the sense that you can
      "unregister" someone's phone by sending a registration request
      with their IMEI/MEID/MAC.

    - version=2: android IDs are assigned randomly.  The device is
      sent a security token that must be included in all future
      checkins for that android id.

    - version=3: same as version 2, but the 'fragment' field is
      provided, and the device understands incremental updates to the
      gservices table (ie, only returning the keys whose values have
      changed.)

    (version=1 was skipped to avoid confusion with the "missing"
    version field that is effectively version 1.)
    """
    @property
    def ota_cert(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """OTA certs accepted by device (base-64 SHA-1 of cert files).  Not
        logged.
        """
    fragment: builtins.int
    """Honeycomb and newer devices send configuration data with their checkin.
    optional DeviceConfigurationProto device_configuration = 18;

    A single CheckinTask on the device may lead to multiple checkin
    requests if there is too much log data to upload in a single
    request.  For version 3 and up, this field will be filled in with
    the number of the request, starting with 0.
    """
    user_name: builtins.str
    """For devices supporting multiple users, the name of the current
    profile (they all check in independently, just as if they were
    multiple physical devices).  This may not be set, even if the
    device is using multiuser.  (checkin.user_number should be set to
    the ordinal of the user.)
    """
    user_serial_number: builtins.int
    """For devices supporting multiple user profiles, the serial number
    for the user checking in.  Not logged.  May not be set, even if
    the device supportes multiuser.  checkin.user_number is the
    ordinal of the user (0, 1, 2, ...), which may be reused if users
    are deleted and re-created.  user_serial_number is never reused
    (unless the device is wiped).
    """
    def __init__(
        self,
        *,
        imei: builtins.str | None = ...,
        meid: builtins.str | None = ...,
        mac_addr: collections.abc.Iterable[builtins.str] | None = ...,
        mac_addr_type: collections.abc.Iterable[builtins.str] | None = ...,
        serial_number: builtins.str | None = ...,
        esn: builtins.str | None = ...,
        id: builtins.int | None = ...,
        logging_id: builtins.int | None = ...,
        digest: builtins.str | None = ...,
        locale: builtins.str | None = ...,
        checkin: android_checkin_pb2.AndroidCheckinProto | None = ...,
        desired_build: builtins.str | None = ...,
        market_checkin: builtins.str | None = ...,
        account_cookie: collections.abc.Iterable[builtins.str] | None = ...,
        time_zone: builtins.str | None = ...,
        security_token: builtins.int | None = ...,
        version: builtins.int | None = ...,
        ota_cert: collections.abc.Iterable[builtins.str] | None = ...,
        fragment: builtins.int | None = ...,
        user_name: builtins.str | None = ...,
        user_serial_number: builtins.int | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "checkin",
            b"checkin",
            "desired_build",
            b"desired_build",
            "digest",
            b"digest",
            "esn",
            b"esn",
            "fragment",
            b"fragment",
            "id",
            b"id",
            "imei",
            b"imei",
            "locale",
            b"locale",
            "logging_id",
            b"logging_id",
            "market_checkin",
            b"market_checkin",
            "meid",
            b"meid",
            "security_token",
            b"security_token",
            "serial_number",
            b"serial_number",
            "time_zone",
            b"time_zone",
            "user_name",
            b"user_name",
            "user_serial_number",
            b"user_serial_number",
            "version",
            b"version",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "account_cookie",
            b"account_cookie",
            "checkin",
            b"checkin",
            "desired_build",
            b"desired_build",
            "digest",
            b"digest",
            "esn",
            b"esn",
            "fragment",
            b"fragment",
            "id",
            b"id",
            "imei",
            b"imei",
            "locale",
            b"locale",
            "logging_id",
            b"logging_id",
            "mac_addr",
            b"mac_addr",
            "mac_addr_type",
            b"mac_addr_type",
            "market_checkin",
            b"market_checkin",
            "meid",
            b"meid",
            "ota_cert",
            b"ota_cert",
            "security_token",
            b"security_token",
            "serial_number",
            b"serial_number",
            "time_zone",
            b"time_zone",
            "user_name",
            b"user_name",
            "user_serial_number",
            b"user_serial_number",
            "version",
            b"version",
        ],
    ) -> None: ...

global___AndroidCheckinRequest = AndroidCheckinRequest

@typing_extensions.final
class AndroidCheckinResponse(google.protobuf.message.Message):
    """The response to the device."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATS_OK_FIELD_NUMBER: builtins.int
    TIME_MSEC_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    SETTINGS_DIFF_FIELD_NUMBER: builtins.int
    DELETE_SETTING_FIELD_NUMBER: builtins.int
    SETTING_FIELD_NUMBER: builtins.int
    MARKET_OK_FIELD_NUMBER: builtins.int
    ANDROID_ID_FIELD_NUMBER: builtins.int
    SECURITY_TOKEN_FIELD_NUMBER: builtins.int
    VERSION_INFO_FIELD_NUMBER: builtins.int
    stats_ok: builtins.bool
    """Whether statistics were recorded properly."""
    time_msec: builtins.int
    """Time of day from server (Java epoch)."""
    digest: builtins.str
    """repeated AndroidIntentProto intent = 2;

    Provisioning is sent if the request included an obsolete digest.

    For version <= 2, 'digest' contains the digest that should be
    sent back to the server on the next checkin, and 'setting'
    contains the entire gservices table (which replaces the entire
    current table on the device).

    for version >= 3, 'digest' will be absent.  If 'settings_diff'
    is false, then 'setting' contains the entire table, as in version
    2.  If 'settings_diff' is true, then 'delete_setting' contains
    the keys to delete, and 'setting' contains only keys to be added
    or for which the value has changed.  All other keys in the
    current table should be left untouched.  If 'settings_diff' is
    absent, don't touch the existing gservices table.
    """
    settings_diff: builtins.bool
    @property
    def delete_setting(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        builtins.str
    ]: ...
    @property
    def setting(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___GservicesSetting
    ]: ...
    market_ok: builtins.bool
    """If Market got the market_checkin data OK."""
    android_id: builtins.int
    """From the request, or newly assigned"""
    security_token: builtins.int
    """The associated security token"""
    version_info: builtins.str
    """NEXT TAG: 12"""
    def __init__(
        self,
        *,
        stats_ok: builtins.bool | None = ...,
        time_msec: builtins.int | None = ...,
        digest: builtins.str | None = ...,
        settings_diff: builtins.bool | None = ...,
        delete_setting: collections.abc.Iterable[builtins.str] | None = ...,
        setting: collections.abc.Iterable[global___GservicesSetting] | None = ...,
        market_ok: builtins.bool | None = ...,
        android_id: builtins.int | None = ...,
        security_token: builtins.int | None = ...,
        version_info: builtins.str | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "android_id",
            b"android_id",
            "digest",
            b"digest",
            "market_ok",
            b"market_ok",
            "security_token",
            b"security_token",
            "settings_diff",
            b"settings_diff",
            "stats_ok",
            b"stats_ok",
            "time_msec",
            b"time_msec",
            "version_info",
            b"version_info",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "android_id",
            b"android_id",
            "delete_setting",
            b"delete_setting",
            "digest",
            b"digest",
            "market_ok",
            b"market_ok",
            "security_token",
            b"security_token",
            "setting",
            b"setting",
            "settings_diff",
            b"settings_diff",
            "stats_ok",
            b"stats_ok",
            "time_msec",
            b"time_msec",
            "version_info",
            b"version_info",
        ],
    ) -> None: ...

global___AndroidCheckinResponse = AndroidCheckinResponse
