# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains common data types used within the users namespace.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

class AccountType(bb.Union):
    """
    What type of account this user has.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar basic: The basic account type.
    :ivar pro: The Dropbox Pro account type.
    :ivar business: The Dropbox Business account type.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    basic = None
    # Attribute is overwritten below the class definition
    pro = None
    # Attribute is overwritten below the class definition
    business = None

    def is_basic(self):
        """
        Check if the union tag is ``basic``.

        :rtype: bool
        """
        return self._tag == 'basic'

    def is_pro(self):
        """
        Check if the union tag is ``pro``.

        :rtype: bool
        """
        return self._tag == 'pro'

    def is_business(self):
        """
        Check if the union tag is ``business``.

        :rtype: bool
        """
        return self._tag == 'business'

    def __repr__(self):
        return 'AccountType(%r, %r)' % (self._tag, self._value)

AccountType_validator = bv.Union(AccountType)

AccountId_validator = bv.String(min_length=40, max_length=40)
AccountType._basic_validator = bv.Void()
AccountType._pro_validator = bv.Void()
AccountType._business_validator = bv.Void()
AccountType._tagmap = {
    'basic': AccountType._basic_validator,
    'pro': AccountType._pro_validator,
    'business': AccountType._business_validator,
}

AccountType.basic = AccountType('basic')
AccountType.pro = AccountType('pro')
AccountType.business = AccountType('business')

ROUTES = {
}

