# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.resources.v2022_09_01 import ResourceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceManagementResourcesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_list_by_resource_group(self, resource_group):
        response = self.client.resources.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2022-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_move_resources(self, resource_group):
        response = self.client.resources.begin_move_resources(
            source_resource_group_name="str",
            parameters={"resources": ["str"], "targetResourceGroup": "str"},
            api_version="2022-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_validate_move_resources(self, resource_group):
        response = self.client.resources.begin_validate_move_resources(
            source_resource_group_name="str",
            parameters={"resources": ["str"], "targetResourceGroup": "str"},
            api_version="2022-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_list(self, resource_group):
        response = self.client.resources.list(
            api_version="2022-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_check_existence(self, resource_group):
        response = self.client.resources.check_existence(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_delete(self, resource_group):
        response = self.client.resources.begin_delete(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_create_or_update(self, resource_group):
        response = self.client.resources.begin_create_or_update(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="str",
            parameters={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "managedBy": "str",
                "name": "str",
                "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str", "version": "str"},
                "properties": {},
                "sku": {"capacity": 0, "family": "str", "model": "str", "name": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_update(self, resource_group):
        response = self.client.resources.begin_update(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="str",
            parameters={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "managedBy": "str",
                "name": "str",
                "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str", "version": "str"},
                "properties": {},
                "sku": {"capacity": 0, "family": "str", "model": "str", "name": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_get(self, resource_group):
        response = self.client.resources.get(
            resource_group_name=resource_group.name,
            resource_provider_namespace="str",
            parent_resource_path="str",
            resource_type="str",
            resource_name="str",
            api_version="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_check_existence_by_id(self, resource_group):
        response = self.client.resources.check_existence_by_id(
            resource_id="str",
            api_version="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_delete_by_id(self, resource_group):
        response = self.client.resources.begin_delete_by_id(
            resource_id="str",
            api_version="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_create_or_update_by_id(self, resource_group):
        response = self.client.resources.begin_create_or_update_by_id(
            resource_id="str",
            api_version="str",
            parameters={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "managedBy": "str",
                "name": "str",
                "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str", "version": "str"},
                "properties": {},
                "sku": {"capacity": 0, "family": "str", "model": "str", "name": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_begin_update_by_id(self, resource_group):
        response = self.client.resources.begin_update_by_id(
            resource_id="str",
            api_version="str",
            parameters={
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "kind": "str",
                "location": "str",
                "managedBy": "str",
                "name": "str",
                "plan": {"name": "str", "product": "str", "promotionCode": "str", "publisher": "str", "version": "str"},
                "properties": {},
                "sku": {"capacity": 0, "family": "str", "model": "str", "name": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resources_get_by_id(self, resource_group):
        response = self.client.resources.get_by_id(
            resource_id="str",
            api_version="str",
        )

        # please add some check logic here by yourself
        # ...
