# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, List, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ...operations._operations import (
    build_operations_list_request,
    build_scheduled_actions_virtual_machines_cancel_operations_request,
    build_scheduled_actions_virtual_machines_execute_deallocate_request,
    build_scheduled_actions_virtual_machines_execute_hibernate_request,
    build_scheduled_actions_virtual_machines_execute_start_request,
    build_scheduled_actions_virtual_machines_get_operation_errors_request,
    build_scheduled_actions_virtual_machines_get_operation_status_request,
    build_scheduled_actions_virtual_machines_submit_deallocate_request,
    build_scheduled_actions_virtual_machines_submit_hibernate_request,
    build_scheduled_actions_virtual_machines_submit_start_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computeschedule.aio.ComputeScheduleMgmtClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Operation"]:
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computeschedule.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ScheduledActionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computeschedule.aio.ComputeScheduleMgmtClient`'s
        :attr:`scheduled_actions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def virtual_machines_submit_deallocate(
        self,
        locationparameter: str,
        request_body: _models.SubmitDeallocateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesSubmitDeallocate: Schedule deallocate operation for a batch of virtual machines
        at datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitDeallocateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_deallocate(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesSubmitDeallocate: Schedule deallocate operation for a batch of virtual machines
        at datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_deallocate(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesSubmitDeallocate: Schedule deallocate operation for a batch of virtual machines
        at datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_submit_deallocate(
        self,
        locationparameter: str,
        request_body: Union[_models.SubmitDeallocateRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesSubmitDeallocate: Schedule deallocate operation for a batch of virtual machines
        at datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: SubmitDeallocateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitDeallocateRequest or JSON or
         IO[bytes]
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeallocateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_submit_deallocate_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeallocateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_submit_hibernate(
        self,
        locationparameter: str,
        request_body: _models.SubmitHibernateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesSubmitHibernate: Schedule hibernate operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitHibernateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_hibernate(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesSubmitHibernate: Schedule hibernate operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_hibernate(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesSubmitHibernate: Schedule hibernate operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_submit_hibernate(
        self,
        locationparameter: str,
        request_body: Union[_models.SubmitHibernateRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesSubmitHibernate: Schedule hibernate operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: SubmitHibernateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitHibernateRequest or JSON or
         IO[bytes]
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HibernateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_submit_hibernate_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.HibernateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_submit_start(
        self,
        locationparameter: str,
        request_body: _models.SubmitStartRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesSubmitStart: Schedule start operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitStartRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_start(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesSubmitStart: Schedule start operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_submit_start(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesSubmitStart: Schedule start operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_submit_start(
        self, locationparameter: str, request_body: Union[_models.SubmitStartRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesSubmitStart: Schedule start operation for a batch of virtual machines at
        datetime in future.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: SubmitStartRequest, JSON,
         IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.SubmitStartRequest or JSON or IO[bytes]
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StartResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_submit_start_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StartResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_deallocate(
        self,
        locationparameter: str,
        request_body: _models.ExecuteDeallocateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteDeallocateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_deallocate(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_deallocate(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_deallocate(
        self,
        locationparameter: str,
        request_body: Union[_models.ExecuteDeallocateRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: ExecuteDeallocateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteDeallocateRequest or JSON or
         IO[bytes]
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeallocateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_execute_deallocate_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeallocateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_hibernate(
        self,
        locationparameter: str,
        request_body: _models.ExecuteHibernateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteHibernateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_hibernate(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_hibernate(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_hibernate(
        self,
        locationparameter: str,
        request_body: Union[_models.ExecuteHibernateRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: ExecuteHibernateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteHibernateRequest or JSON or
         IO[bytes]
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HibernateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_execute_hibernate_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.HibernateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_start(
        self,
        locationparameter: str,
        request_body: _models.ExecuteStartRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteStartRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_start(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_start(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_start(
        self, locationparameter: str, request_body: Union[_models.ExecuteStartRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: ExecuteStartRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.ExecuteStartRequest or JSON or IO[bytes]
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StartResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_execute_start_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StartResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_get_operation_status(
        self,
        locationparameter: str,
        request_body: _models.GetOperationStatusRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.GetOperationStatusRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_status(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_status(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_get_operation_status(
        self,
        locationparameter: str,
        request_body: Union[_models.GetOperationStatusRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types:
         GetOperationStatusRequest, JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.GetOperationStatusRequest or JSON or
         IO[bytes]
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GetOperationStatusResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_get_operation_status_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GetOperationStatusResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_cancel_operations(
        self,
        locationparameter: str,
        request_body: _models.CancelOperationsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.CancelOperationsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_cancel_operations(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_cancel_operations(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_cancel_operations(
        self,
        locationparameter: str,
        request_body: Union[_models.CancelOperationsRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types: CancelOperationsRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.CancelOperationsRequest or JSON or
         IO[bytes]
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CancelOperationsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_cancel_operations_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CancelOperationsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_get_operation_errors(
        self,
        locationparameter: str,
        request_body: _models.GetOperationErrorsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GetOperationErrorsResponse:
        """VirtualMachinesGetOperationErrors: Get error details on operation errors (like transient errors
        encountered, additional logs) if they exist.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computeschedule.models.GetOperationErrorsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationErrorsResponse. The GetOperationErrorsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationErrorsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_errors(
        self, locationparameter: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationErrorsResponse:
        """VirtualMachinesGetOperationErrors: Get error details on operation errors (like transient errors
        encountered, additional logs) if they exist.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationErrorsResponse. The GetOperationErrorsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationErrorsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_errors(
        self, locationparameter: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationErrorsResponse:
        """VirtualMachinesGetOperationErrors: Get error details on operation errors (like transient errors
        encountered, additional logs) if they exist.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationErrorsResponse. The GetOperationErrorsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationErrorsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_get_operation_errors(
        self,
        locationparameter: str,
        request_body: Union[_models.GetOperationErrorsRequest, JSON, IO[bytes]],
        **kwargs: Any
    ) -> _models.GetOperationErrorsResponse:
        """VirtualMachinesGetOperationErrors: Get error details on operation errors (like transient errors
        encountered, additional logs) if they exist.

        :param locationparameter: The location name. Required.
        :type locationparameter: str
        :param request_body: The request body. Is one of the following types:
         GetOperationErrorsRequest, JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computeschedule.models.GetOperationErrorsRequest or JSON or
         IO[bytes]
        :return: GetOperationErrorsResponse. The GetOperationErrorsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computeschedule.models.GetOperationErrorsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GetOperationErrorsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_scheduled_actions_virtual_machines_get_operation_errors_request(
            locationparameter=locationparameter,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GetOperationErrorsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
