# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddonStatusProfile(_serialization.Model):
    """The status profile of the addons and other kubernetes components.

    :ivar name: Name of the addon or component.
    :vartype name: str
    :ivar phase: Observed phase of the addon or component on the provisioned cluster. Possible
     values include: 'pending', 'provisioning', 'provisioning {HelmChartInstalled}', 'provisioning
     {MSICertificateDownloaded}', 'provisioned', 'deleting', 'failed', 'upgrading'. Known values
     are: "pending", "provisioning", "provisioning {HelmChartInstalled}", "provisioning
     {MSICertificateDownloaded}", "provisioned", "deleting", "failed", and "upgrading".
    :vartype phase: str or ~azure.mgmt.hybridcontainerservice.models.AddonPhase
    :ivar ready: Indicates whether the addon or component is ready.
    :vartype ready: bool
    :ivar error_message: Observed error message from the addon or component.
    :vartype error_message: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "phase": {"key": "phase", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        phase: Optional[Union[str, "_models.AddonPhase"]] = None,
        ready: Optional[bool] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the addon or component.
        :paramtype name: str
        :keyword phase: Observed phase of the addon or component on the provisioned cluster. Possible
         values include: 'pending', 'provisioning', 'provisioning {HelmChartInstalled}', 'provisioning
         {MSICertificateDownloaded}', 'provisioned', 'deleting', 'failed', 'upgrading'. Known values
         are: "pending", "provisioning", "provisioning {HelmChartInstalled}", "provisioning
         {MSICertificateDownloaded}", "provisioned", "deleting", "failed", and "upgrading".
        :paramtype phase: str or ~azure.mgmt.hybridcontainerservice.models.AddonPhase
        :keyword ready: Indicates whether the addon or component is ready.
        :paramtype ready: bool
        :keyword error_message: Observed error message from the addon or component.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.phase = phase
        self.ready = ready
        self.error_message = error_message


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class AgentPool(ProxyResource):
    """The agentPool resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar properties: Properties of the agent pool resource.
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar extended_location: Extended location pointing to the underlying infrastructure.
    :vartype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AgentPoolProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.AgentPoolProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the agent pool resource.
        :paramtype properties: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword extended_location: Extended location pointing to the underlying infrastructure.
        :paramtype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags
        self.extended_location = extended_location


class AgentPoolListResult(_serialization.Model):
    """List of all agent pool resources associated with the provisioned cluster.

    :ivar value:
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.AgentPool]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AgentPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AgentPool"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.AgentPool]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AgentPoolName(_serialization.Model):
    """Name of the default Agent Pool.

    :ivar name: Unique name of the default agent pool in the context of the provisioned cluster.
     Default value is :code:`<clusterName>`-nodepool1.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Unique name of the default agent pool in the context of the provisioned cluster.
         Default value is :code:`<clusterName>`-nodepool1.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class AgentPoolProfile(_serialization.Model):
    """Profile for agent pool properties specified during creation.

    :ivar os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType
     is Linux. The default is Windows2019 when OSType is Windows. Known values are: "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
    :vartype enable_auto_scaling: bool
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    """

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSKU", "type": "str"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "max_pods": {"key": "maxPods", "type": "int"},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: bool = False,
        max_pods: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if
         OSType is Linux. The default is Windows2019 when OSType is Windows. Known values are:
         "CBLMariner", "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
        :paramtype enable_auto_scaling: bool
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        """
        super().__init__(**kwargs)
        self.os_type = os_type
        self.os_sku = os_sku
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.max_pods = max_pods


class AgentPoolProvisioningStatus(_serialization.Model):
    """The agentPool resource provisioning status definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the latest long running operation for the agent pool.
     Known values are: "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Deleting",
     "Updating", "Upgrading", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar status: The observed status of the agent pool.
    :vartype status: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProvisioningStatusStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "AgentPoolProvisioningStatusStatus"},
    }

    def __init__(self, *, status: Optional["_models.AgentPoolProvisioningStatusStatus"] = None, **kwargs: Any) -> None:
        """
        :keyword status: The observed status of the agent pool.
        :paramtype status: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProvisioningStatusStatus
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.status = status


class AgentPoolUpdateProfile(_serialization.Model):
    """Profile for agent pool properties that can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: Number of nodes in the agent pool. The default value is 1.
    :vartype count: int
    :ivar vm_size: The VM sku size of the agent pool node VMs.
    :vartype vm_size: str
    :ivar kubernetes_version: Version of Kubernetes in use by the agent pool. This is inherited
     from the kubernetesVersion of the provisioned cluster.
    :vartype kubernetes_version: str
    """

    _validation = {
        "kubernetes_version": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
    }

    def __init__(self, *, count: int = 1, vm_size: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Number of nodes in the agent pool. The default value is 1.
        :paramtype count: int
        :keyword vm_size: The VM sku size of the agent pool node VMs.
        :paramtype vm_size: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.kubernetes_version = None


class AgentPoolProperties(
    AgentPoolProfile, AgentPoolUpdateProfile, AgentPoolProvisioningStatus
):  # pylint: disable=too-many-instance-attributes
    """Properties of the agent pool resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the latest long running operation for the agent pool.
     Known values are: "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Deleting",
     "Updating", "Upgrading", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar status: The observed status of the agent pool.
    :vartype status: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProvisioningStatusStatus
    :ivar count: Number of nodes in the agent pool. The default value is 1.
    :vartype count: int
    :ivar vm_size: The VM sku size of the agent pool node VMs.
    :vartype vm_size: str
    :ivar kubernetes_version: Version of Kubernetes in use by the agent pool. This is inherited
     from the kubernetesVersion of the provisioned cluster.
    :vartype kubernetes_version: str
    :ivar os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType
     is Linux. The default is Windows2019 when OSType is Windows. Known values are: "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
    :vartype enable_auto_scaling: bool
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "kubernetes_version": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "AgentPoolProvisioningStatusStatus"},
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSKU", "type": "str"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "max_pods": {"key": "maxPods", "type": "int"},
    }

    def __init__(
        self,
        *,
        status: Optional["_models.AgentPoolProvisioningStatusStatus"] = None,
        count: int = 1,
        vm_size: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: bool = False,
        max_pods: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The observed status of the agent pool.
        :paramtype status: ~azure.mgmt.hybridcontainerservice.models.AgentPoolProvisioningStatusStatus
        :keyword count: Number of nodes in the agent pool. The default value is 1.
        :paramtype count: int
        :keyword vm_size: The VM sku size of the agent pool node VMs.
        :paramtype vm_size: str
        :keyword os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if
         OSType is Linux. The default is Windows2019 when OSType is Windows. Known values are:
         "CBLMariner", "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
        :paramtype enable_auto_scaling: bool
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        """
        super().__init__(
            os_type=os_type,
            os_sku=os_sku,
            node_labels=node_labels,
            node_taints=node_taints,
            max_count=max_count,
            min_count=min_count,
            enable_auto_scaling=enable_auto_scaling,
            max_pods=max_pods,
            count=count,
            vm_size=vm_size,
            status=status,
            **kwargs
        )
        self.provisioning_state = None
        self.status = status
        self.count = count
        self.vm_size = vm_size
        self.kubernetes_version = None
        self.os_type = os_type
        self.os_sku = os_sku
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.max_pods = max_pods


class AgentPoolProvisioningStatusStatus(_serialization.Model):
    """The observed status of the agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_state: The current state of the agent pool. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and
     "Accepted".
    :vartype current_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar error_message: Error messages during an agent pool operation or steady state.
    :vartype error_message: str
    :ivar ready_replicas:
    :vartype ready_replicas: list[~azure.mgmt.hybridcontainerservice.models.AgentPoolUpdateProfile]
    """

    _validation = {
        "current_state": {"readonly": True},
    }

    _attribute_map = {
        "current_state": {"key": "currentState", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "ready_replicas": {"key": "readyReplicas", "type": "[AgentPoolUpdateProfile]"},
    }

    def __init__(
        self,
        *,
        error_message: Optional[str] = None,
        ready_replicas: Optional[List["_models.AgentPoolUpdateProfile"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_message: Error messages during an agent pool operation or steady state.
        :paramtype error_message: str
        :keyword ready_replicas:
        :paramtype ready_replicas:
         list[~azure.mgmt.hybridcontainerservice.models.AgentPoolUpdateProfile]
        """
        super().__init__(**kwargs)
        self.current_state = None
        self.error_message = error_message
        self.ready_replicas = ready_replicas


class CloudProviderProfile(_serialization.Model):
    """The profile for the underlying cloud infrastructure provider for the provisioned cluster.

    :ivar infra_network_profile: The profile for the infrastructure networks used by the
     provisioned cluster.
    :vartype infra_network_profile:
     ~azure.mgmt.hybridcontainerservice.models.CloudProviderProfileInfraNetworkProfile
    """

    _attribute_map = {
        "infra_network_profile": {"key": "infraNetworkProfile", "type": "CloudProviderProfileInfraNetworkProfile"},
    }

    def __init__(
        self,
        *,
        infra_network_profile: Optional["_models.CloudProviderProfileInfraNetworkProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infra_network_profile: The profile for the infrastructure networks used by the
         provisioned cluster.
        :paramtype infra_network_profile:
         ~azure.mgmt.hybridcontainerservice.models.CloudProviderProfileInfraNetworkProfile
        """
        super().__init__(**kwargs)
        self.infra_network_profile = infra_network_profile


class CloudProviderProfileInfraNetworkProfile(_serialization.Model):
    """The profile for the infrastructure networks used by the provisioned cluster.

    :ivar vnet_subnet_ids: List of ARM resource Ids (maximum 1) for the infrastructure network
     object e.g.
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}.
    :vartype vnet_subnet_ids: list[str]
    """

    _attribute_map = {
        "vnet_subnet_ids": {"key": "vnetSubnetIds", "type": "[str]"},
    }

    def __init__(self, *, vnet_subnet_ids: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword vnet_subnet_ids: List of ARM resource Ids (maximum 1) for the infrastructure network
         object e.g.
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}.
        :paramtype vnet_subnet_ids: list[str]
        """
        super().__init__(**kwargs)
        self.vnet_subnet_ids = vnet_subnet_ids


class ClusterVMAccessProfile(_serialization.Model):
    """The SSH restricted access profile for the VMs in the provisioned cluster.

    :ivar authorized_ip_ranges: IP Address or CIDR for SSH access to VMs in the provisioned
     cluster.
    :vartype authorized_ip_ranges: str
    """

    _attribute_map = {
        "authorized_ip_ranges": {"key": "authorizedIPRanges", "type": "str"},
    }

    def __init__(self, *, authorized_ip_ranges: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword authorized_ip_ranges: IP Address or CIDR for SSH access to VMs in the provisioned
         cluster.
        :paramtype authorized_ip_ranges: str
        """
        super().__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges


class ControlPlaneProfile(_serialization.Model):
    """The properties of the control plane nodes of the provisioned cluster.

    :ivar count: Number of control plane nodes. The default value is 1, and the count should be an
     odd number.
    :vartype count: int
    :ivar vm_size: VM sku size of the control plane nodes.
    :vartype vm_size: str
    :ivar control_plane_endpoint: IP Address of the Kubernetes API server.
    :vartype control_plane_endpoint:
     ~azure.mgmt.hybridcontainerservice.models.ControlPlaneProfileControlPlaneEndpoint
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "control_plane_endpoint": {"key": "controlPlaneEndpoint", "type": "ControlPlaneProfileControlPlaneEndpoint"},
    }

    def __init__(
        self,
        *,
        count: int = 1,
        vm_size: Optional[str] = None,
        control_plane_endpoint: Optional["_models.ControlPlaneProfileControlPlaneEndpoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of control plane nodes. The default value is 1, and the count should be
         an odd number.
        :paramtype count: int
        :keyword vm_size: VM sku size of the control plane nodes.
        :paramtype vm_size: str
        :keyword control_plane_endpoint: IP Address of the Kubernetes API server.
        :paramtype control_plane_endpoint:
         ~azure.mgmt.hybridcontainerservice.models.ControlPlaneProfileControlPlaneEndpoint
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.control_plane_endpoint = control_plane_endpoint


class ControlPlaneProfileControlPlaneEndpoint(_serialization.Model):
    """IP Address of the Kubernetes API server.

    :ivar host_ip: IP address of the Kubernetes API server.
    :vartype host_ip: str
    """

    _attribute_map = {
        "host_ip": {"key": "hostIP", "type": "str"},
    }

    def __init__(self, *, host_ip: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword host_ip: IP address of the Kubernetes API server.
        :paramtype host_ip: str
        """
        super().__init__(**kwargs)
        self.host_ip = host_ip


class CredentialResult(_serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridcontainerservice.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridcontainerservice.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridcontainerservice.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hybridcontainerservice.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtendedLocation(_serialization.Model):
    """Extended location pointing to the underlying infrastructure.

    :ivar type: The extended location type. Allowed value: 'CustomLocation'. "CustomLocation"
    :vartype type: str or ~azure.mgmt.hybridcontainerservice.models.ExtendedLocationTypes
    :ivar name: ARM Id of the extended location.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The extended location type. Allowed value: 'CustomLocation'. "CustomLocation"
        :paramtype type: str or ~azure.mgmt.hybridcontainerservice.models.ExtendedLocationTypes
        :keyword name: ARM Id of the extended location.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class HybridIdentityMetadata(ProxyResource):
    """Defines the hybridIdentityMetadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar properties: Resource properties. Required.
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.HybridIdentityMetadataProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "HybridIdentityMetadataProperties"},
    }

    def __init__(self, *, properties: "_models.HybridIdentityMetadataProperties", **kwargs: Any) -> None:
        """
        :keyword properties: Resource properties. Required.
        :paramtype properties:
         ~azure.mgmt.hybridcontainerservice.models.HybridIdentityMetadataProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class HybridIdentityMetadataList(_serialization.Model):
    """List of hybridIdentityMetadata.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of hybridIdentityMetadata.
    :vartype next_link: str
    :ivar value: Array of hybridIdentityMetadata. Required.
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.HybridIdentityMetadata]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[HybridIdentityMetadata]"},
    }

    def __init__(
        self, *, value: List["_models.HybridIdentityMetadata"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: Url to follow for getting next page of hybridIdentityMetadata.
        :paramtype next_link: str
        :keyword value: Array of hybridIdentityMetadata. Required.
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.HybridIdentityMetadata]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class HybridIdentityMetadataProperties(_serialization.Model):
    """Defines the resource properties for the hybrid identity metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_uid: Unique id of the parent provisioned cluster resource.
    :vartype resource_uid: str
    :ivar public_key: Onboarding public key for provisioning the Managed identity for the connected
     cluster.
    :vartype public_key: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "resource_uid": {"key": "resourceUid", "type": "str"},
        "public_key": {"key": "publicKey", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, resource_uid: Optional[str] = None, public_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_uid: Unique id of the parent provisioned cluster resource.
        :paramtype resource_uid: str
        :keyword public_key: Onboarding public key for provisioning the Managed identity for the
         connected cluster.
        :paramtype public_key: str
        """
        super().__init__(**kwargs)
        self.resource_uid = resource_uid
        self.public_key = public_key
        self.provisioning_state = None


class KubernetesPatchVersions(_serialization.Model):
    """Kubernetes Patch Version profile.

    :ivar readiness: Indicates whether the kubernetes version image is ready or not.
    :vartype readiness: list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionReadiness]
    :ivar upgrades: Possible upgrade paths for given patch version.
    :vartype upgrades: list[str]
    """

    _attribute_map = {
        "readiness": {"key": "readiness", "type": "[KubernetesVersionReadiness]"},
        "upgrades": {"key": "upgrades", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        readiness: Optional[List["_models.KubernetesVersionReadiness"]] = None,
        upgrades: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword readiness: Indicates whether the kubernetes version image is ready or not.
        :paramtype readiness:
         list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionReadiness]
        :keyword upgrades: Possible upgrade paths for given patch version.
        :paramtype upgrades: list[str]
        """
        super().__init__(**kwargs)
        self.readiness = readiness
        self.upgrades = upgrades


class KubernetesVersionProfile(ProxyResource):
    """The supported kubernetes versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar extended_location: Extended location pointing to the underlying infrastructure.
    :vartype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.hybridcontainerservice.models.KubernetesVersionProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "properties": {"key": "properties", "type": "KubernetesVersionProfileProperties"},
    }

    def __init__(self, *, extended_location: Optional["_models.ExtendedLocation"] = None, **kwargs: Any) -> None:
        """
        :keyword extended_location: Extended location pointing to the underlying infrastructure.
        :paramtype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.extended_location = extended_location
        self.properties = None


class KubernetesVersionProfileList(_serialization.Model):
    """List of supported kubernetes versions.

    :ivar value:
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionProfile]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[KubernetesVersionProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.KubernetesVersionProfile"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionProfile]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class KubernetesVersionProfileProperties(_serialization.Model):
    """KubernetesVersionProfileProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar values: List of supported Kubernetes versions.
    :vartype values: list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionProperties]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "values": {"key": "values", "type": "[KubernetesVersionProperties]"},
    }

    def __init__(self, *, values: Optional[List["_models.KubernetesVersionProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword values: List of supported Kubernetes versions.
        :paramtype values: list[~azure.mgmt.hybridcontainerservice.models.KubernetesVersionProperties]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.values = values


class KubernetesVersionProperties(_serialization.Model):
    """Kubernetes version profile for given major.minor release.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: major.minor version of Kubernetes release.
    :vartype version: str
    :ivar is_preview: Whether this version is in preview mode.
    :vartype is_preview: bool
    :ivar patch_versions: Patch versions of a Kubernetes release.
    :vartype patch_versions: dict[str,
     ~azure.mgmt.hybridcontainerservice.models.KubernetesPatchVersions]
    """

    _validation = {
        "version": {"readonly": True},
        "is_preview": {"readonly": True},
        "patch_versions": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
        "patch_versions": {"key": "patchVersions", "type": "{KubernetesPatchVersions}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.is_preview = None
        self.patch_versions = None


class KubernetesVersionReadiness(_serialization.Model):
    """Indicates whether the kubernetes version image is ready or not.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType
     is Linux. The default is Windows2019 when OSType is Windows. Known values are: "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
    :ivar ready: Whether the kubernetes version image is ready or not.
    :vartype ready: bool
    :ivar error_message: The error message for version not being ready.
    :vartype error_message: str
    """

    _validation = {
        "os_type": {"readonly": True},
        "ready": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSku", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(self, *, os_sku: Optional[Union[str, "_models.OSSKU"]] = None, **kwargs: Any) -> None:
        """
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if
         OSType is Linux. The default is Windows2019 when OSType is Windows. Known values are:
         "CBLMariner", "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
        """
        super().__init__(**kwargs)
        self.os_type = None
        self.os_sku = os_sku
        self.ready = None
        self.error_message = None


class LinuxProfile(_serialization.Model):
    """The profile for Linux VMs in the provisioned cluster.

    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile: ~azure.mgmt.hybridcontainerservice.models.LinuxProfileProperties
    """

    _attribute_map = {
        "linux_profile": {"key": "linuxProfile", "type": "LinuxProfileProperties"},
    }

    def __init__(self, *, linux_profile: Optional["_models.LinuxProfileProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile: ~azure.mgmt.hybridcontainerservice.models.LinuxProfileProperties
        """
        super().__init__(**kwargs)
        self.linux_profile = linux_profile


class LinuxProfileProperties(_serialization.Model):
    """SSH profile for control plane and nodepool VMs of the provisioned cluster.

    :ivar ssh: SSH configuration for VMs of the provisioned cluster.
    :vartype ssh: ~azure.mgmt.hybridcontainerservice.models.LinuxProfilePropertiesSsh
    """

    _attribute_map = {
        "ssh": {"key": "ssh", "type": "LinuxProfilePropertiesSsh"},
    }

    def __init__(self, *, ssh: Optional["_models.LinuxProfilePropertiesSsh"] = None, **kwargs: Any) -> None:
        """
        :keyword ssh: SSH configuration for VMs of the provisioned cluster.
        :paramtype ssh: ~azure.mgmt.hybridcontainerservice.models.LinuxProfilePropertiesSsh
        """
        super().__init__(**kwargs)
        self.ssh = ssh


class LinuxProfilePropertiesSsh(_serialization.Model):
    """SSH configuration for VMs of the provisioned cluster.

    :ivar public_keys: The list of SSH public keys used to authenticate with VMs. A maximum of 1
     key may be specified.
    :vartype public_keys:
     list[~azure.mgmt.hybridcontainerservice.models.LinuxProfilePropertiesSshPublicKeysItem]
    """

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[LinuxProfilePropertiesSshPublicKeysItem]"},
    }

    def __init__(
        self, *, public_keys: Optional[List["_models.LinuxProfilePropertiesSshPublicKeysItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with VMs. A maximum of 1
         key may be specified.
        :paramtype public_keys:
         list[~azure.mgmt.hybridcontainerservice.models.LinuxProfilePropertiesSshPublicKeysItem]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class LinuxProfilePropertiesSshPublicKeysItem(_serialization.Model):
    """LinuxProfilePropertiesSshPublicKeysItem.

    :ivar key_data: Certificate public key used to authenticate with VMs through SSH. The
     certificate must be in PEM format with or without headers.
    :vartype key_data: str
    """

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_data: Certificate public key used to authenticate with VMs through SSH. The
         certificate must be in PEM format with or without headers.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class ListCredentialResponse(_serialization.Model):
    """The list kubeconfig result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Operation Id.
    :vartype id: str
    :ivar name: Operation Name.
    :vartype name: str
    :ivar resource_id: ARM Resource Id of the provisioned cluster instance.
    :vartype resource_id: str
    :ivar status: Provisioning state of the resource. Known values are: "Succeeded", "Failed",
     "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and "Accepted".
    :vartype status: str or ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar error:
    :vartype error: ~azure.mgmt.hybridcontainerservice.models.ListCredentialResponseError
    :ivar properties:
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.ListCredentialResponseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "resource_id": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ListCredentialResponseError"},
        "properties": {"key": "properties", "type": "ListCredentialResponseProperties"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ListCredentialResponseError"] = None,
        properties: Optional["_models.ListCredentialResponseProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error:
        :paramtype error: ~azure.mgmt.hybridcontainerservice.models.ListCredentialResponseError
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.hybridcontainerservice.models.ListCredentialResponseProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.resource_id = None
        self.status = None
        self.error = error
        self.properties = properties


class ListCredentialResponseError(_serialization.Model):
    """ListCredentialResponseError.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ListCredentialResponseProperties(_serialization.Model):
    """ListCredentialResponseProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.hybridcontainerservice.models.CredentialResult]
    """

    _validation = {
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "kubeconfigs": {"key": "kubeconfigs", "type": "[CredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubeconfigs = None


class NamedAgentPoolProfile(
    AgentPoolProfile, AgentPoolUpdateProfile, AgentPoolName
):  # pylint: disable=too-many-instance-attributes
    """Profile of the default agent pool along with a name parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Unique name of the default agent pool in the context of the provisioned cluster.
     Default value is :code:`<clusterName>`-nodepool1.
    :vartype name: str
    :ivar count: Number of nodes in the agent pool. The default value is 1.
    :vartype count: int
    :ivar vm_size: The VM sku size of the agent pool node VMs.
    :vartype vm_size: str
    :ivar kubernetes_version: Version of Kubernetes in use by the agent pool. This is inherited
     from the kubernetesVersion of the provisioned cluster.
    :vartype kubernetes_version: str
    :ivar os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
    :ivar os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if OSType
     is Linux. The default is Windows2019 when OSType is Windows. Known values are: "CBLMariner",
     "Windows2019", and "Windows2022".
    :vartype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
    :ivar node_labels: The node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar max_count: The maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: The minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
    :vartype enable_auto_scaling: bool
    :ivar max_pods: The maximum number of pods that can run on a node.
    :vartype max_pods: int
    """

    _validation = {
        "kubernetes_version": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "os_sku": {"key": "osSKU", "type": "str"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "max_pods": {"key": "maxPods", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        count: int = 1,
        vm_size: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        os_sku: Optional[Union[str, "_models.OSSKU"]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: bool = False,
        max_pods: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Unique name of the default agent pool in the context of the provisioned cluster.
         Default value is :code:`<clusterName>`-nodepool1.
        :paramtype name: str
        :keyword count: Number of nodes in the agent pool. The default value is 1.
        :paramtype count: int
        :keyword vm_size: The VM sku size of the agent pool node VMs.
        :paramtype vm_size: str
        :keyword os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
         are: "Windows" and "Linux".
        :paramtype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
        :keyword os_sku: Specifies the OS SKU used by the agent pool. The default is CBLMariner if
         OSType is Linux. The default is Windows2019 when OSType is Windows. Known values are:
         "CBLMariner", "Windows2019", and "Windows2022".
        :paramtype os_sku: str or ~azure.mgmt.hybridcontainerservice.models.OSSKU
        :keyword node_labels: The node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword max_count: The maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: The minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler. Default value is false.
        :paramtype enable_auto_scaling: bool
        :keyword max_pods: The maximum number of pods that can run on a node.
        :paramtype max_pods: int
        """
        super().__init__(
            os_type=os_type,
            os_sku=os_sku,
            node_labels=node_labels,
            node_taints=node_taints,
            max_count=max_count,
            min_count=min_count,
            enable_auto_scaling=enable_auto_scaling,
            max_pods=max_pods,
            count=count,
            vm_size=vm_size,
            name=name,
            **kwargs
        )
        self.name = name
        self.count = count
        self.vm_size = vm_size
        self.kubernetes_version = None
        self.os_type = os_type
        self.os_sku = os_sku
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.max_pods = max_pods


class NetworkProfile(_serialization.Model):
    """The network configuration profile for the provisioned cluster.

    :ivar load_balancer_profile: Profile of the HA Proxy load balancer.
    :vartype load_balancer_profile:
     ~azure.mgmt.hybridcontainerservice.models.NetworkProfileLoadBalancerProfile
    :ivar network_policy: Network policy used for building Kubernetes network. Possible values
     include: 'calico'. "calico"
    :vartype network_policy: str or ~azure.mgmt.hybridcontainerservice.models.NetworkPolicy
    :ivar pod_cidr: A CIDR notation IP Address range from which to assign pod IPs.
    :vartype pod_cidr: str
    """

    _attribute_map = {
        "load_balancer_profile": {"key": "loadBalancerProfile", "type": "NetworkProfileLoadBalancerProfile"},
        "network_policy": {"key": "networkPolicy", "type": "str"},
        "pod_cidr": {"key": "podCidr", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_balancer_profile: Optional["_models.NetworkProfileLoadBalancerProfile"] = None,
        network_policy: Union[str, "_models.NetworkPolicy"] = "calico",
        pod_cidr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_balancer_profile: Profile of the HA Proxy load balancer.
        :paramtype load_balancer_profile:
         ~azure.mgmt.hybridcontainerservice.models.NetworkProfileLoadBalancerProfile
        :keyword network_policy: Network policy used for building Kubernetes network. Possible values
         include: 'calico'. "calico"
        :paramtype network_policy: str or ~azure.mgmt.hybridcontainerservice.models.NetworkPolicy
        :keyword pod_cidr: A CIDR notation IP Address range from which to assign pod IPs.
        :paramtype pod_cidr: str
        """
        super().__init__(**kwargs)
        self.load_balancer_profile = load_balancer_profile
        self.network_policy = network_policy
        self.pod_cidr = pod_cidr


class NetworkProfileLoadBalancerProfile(_serialization.Model):
    """Profile of the HA Proxy load balancer.

    :ivar count: Number of HA Proxy load balancer VMs. The default value is 0.
    :vartype count: int
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: int = 0, **kwargs: Any) -> None:
        """
        :keyword count: Number of HA Proxy load balancer VMs. The default value is 0.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.hybridcontainerservice.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.hybridcontainerservice.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.hybridcontainerservice.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.hybridcontainerservice.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ProvisionedCluster(ProxyResource):
    """The provisioned cluster resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar properties: Properties of the provisioned cluster.
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterProperties
    :ivar extended_location: Extended location pointing to the underlying infrastructure.
    :vartype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ProvisionedClusterProperties"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ProvisionedClusterProperties"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the provisioned cluster.
        :paramtype properties: ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterProperties
        :keyword extended_location: Extended location pointing to the underlying infrastructure.
        :paramtype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.extended_location = extended_location


class ProvisionedClusterLicenseProfile(_serialization.Model):
    """The license profile of the provisioned cluster.

    :ivar azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Default value
     is false. Known values are: "True", "False", and "NotApplicable".
    :vartype azure_hybrid_benefit: str or
     ~azure.mgmt.hybridcontainerservice.models.AzureHybridBenefit
    """

    _attribute_map = {
        "azure_hybrid_benefit": {"key": "azureHybridBenefit", "type": "str"},
    }

    def __init__(
        self, *, azure_hybrid_benefit: Union[str, "_models.AzureHybridBenefit"] = "NotApplicable", **kwargs: Any
    ) -> None:
        """
        :keyword azure_hybrid_benefit: Indicates whether Azure Hybrid Benefit is opted in. Default
         value is false. Known values are: "True", "False", and "NotApplicable".
        :paramtype azure_hybrid_benefit: str or
         ~azure.mgmt.hybridcontainerservice.models.AzureHybridBenefit
        """
        super().__init__(**kwargs)
        self.azure_hybrid_benefit = azure_hybrid_benefit


class ProvisionedClusterListResult(_serialization.Model):
    """Lists the ProvisionedClusterInstance resource associated with the ConnectedCluster.

    :ivar value:
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.ProvisionedCluster]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProvisionedCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ProvisionedCluster"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.ProvisionedCluster]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProvisionedClusterPoolUpgradeProfile(_serialization.Model):
    """The list of available kubernetes versions for upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubernetes_version: The Kubernetes version (major.minor.patch).
    :vartype kubernetes_version: str
    :ivar os_type: The particular KubernetesVersion Image OS Type (Linux, Windows). Known values
     are: "Windows" and "Linux".
    :vartype os_type: str or ~azure.mgmt.hybridcontainerservice.models.OsType
    :ivar upgrades: List of available kubernetes versions for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPoolUpgradeProfileProperties]
    """

    _validation = {
        "kubernetes_version": {"readonly": True},
        "os_type": {"readonly": True},
    }

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "upgrades": {"key": "upgrades", "type": "[ProvisionedClusterPoolUpgradeProfileProperties]"},
    }

    def __init__(
        self,
        *,
        upgrades: Optional[List["_models.ProvisionedClusterPoolUpgradeProfileProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword upgrades: List of available kubernetes versions for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPoolUpgradeProfileProperties]
        """
        super().__init__(**kwargs)
        self.kubernetes_version = None
        self.os_type = None
        self.upgrades = upgrades


class ProvisionedClusterPoolUpgradeProfileProperties(_serialization.Model):
    """The upgrade properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubernetes_version: The Kubernetes version (major.minor.patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether the Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _validation = {
        "kubernetes_version": {"readonly": True},
        "is_preview": {"readonly": True},
    }

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubernetes_version = None
        self.is_preview = None


class ProvisionedClusterProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of the provisioned cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar linux_profile: The profile for Linux VMs in the provisioned cluster.
    :vartype linux_profile: ~azure.mgmt.hybridcontainerservice.models.LinuxProfileProperties
    :ivar control_plane: The profile for control plane of the provisioned cluster.
    :vartype control_plane: ~azure.mgmt.hybridcontainerservice.models.ControlPlaneProfile
    :ivar kubernetes_version: The version of Kubernetes in use by the provisioned cluster.
    :vartype kubernetes_version: str
    :ivar network_profile: The network configuration profile for the provisioned cluster.
    :vartype network_profile: ~azure.mgmt.hybridcontainerservice.models.NetworkProfile
    :ivar storage_profile: The storage configuration profile for the provisioned cluster.
    :vartype storage_profile: ~azure.mgmt.hybridcontainerservice.models.StorageProfile
    :ivar cluster_vm_access_profile: The SSH restricted access profile for the VMs in the
     provisioned cluster.
    :vartype cluster_vm_access_profile:
     ~azure.mgmt.hybridcontainerservice.models.ClusterVMAccessProfile
    :ivar agent_pool_profiles: The agent pool properties for the provisioned cluster.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.hybridcontainerservice.models.NamedAgentPoolProfile]
    :ivar cloud_provider_profile: The profile for the underlying cloud infrastructure provider for
     the provisioned cluster.
    :vartype cloud_provider_profile: ~azure.mgmt.hybridcontainerservice.models.CloudProviderProfile
    :ivar provisioning_state: The status of the latest long running operation for the provisioned
     cluster. Known values are: "Succeeded", "Failed", "Canceled", "Pending", "Creating",
     "Deleting", "Updating", "Upgrading", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar status: The observed status of the provisioned cluster.
    :vartype status: ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPropertiesStatus
    :ivar license_profile: The license profile of the provisioned cluster.
    :vartype license_profile:
     ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterLicenseProfile
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when auto scaling
     is enabled for the provisioned cluster.
    :vartype auto_scaler_profile:
     ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPropertiesAutoScalerProfile
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "linux_profile": {"key": "linuxProfile", "type": "LinuxProfileProperties"},
        "control_plane": {"key": "controlPlane", "type": "ControlPlaneProfile"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfile"},
        "storage_profile": {"key": "storageProfile", "type": "StorageProfile"},
        "cluster_vm_access_profile": {"key": "clusterVMAccessProfile", "type": "ClusterVMAccessProfile"},
        "agent_pool_profiles": {"key": "agentPoolProfiles", "type": "[NamedAgentPoolProfile]"},
        "cloud_provider_profile": {"key": "cloudProviderProfile", "type": "CloudProviderProfile"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "ProvisionedClusterPropertiesStatus"},
        "license_profile": {"key": "licenseProfile", "type": "ProvisionedClusterLicenseProfile"},
        "auto_scaler_profile": {"key": "autoScalerProfile", "type": "ProvisionedClusterPropertiesAutoScalerProfile"},
    }

    def __init__(
        self,
        *,
        linux_profile: Optional["_models.LinuxProfileProperties"] = None,
        control_plane: Optional["_models.ControlPlaneProfile"] = None,
        kubernetes_version: Optional[str] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        storage_profile: Optional["_models.StorageProfile"] = None,
        cluster_vm_access_profile: Optional["_models.ClusterVMAccessProfile"] = None,
        agent_pool_profiles: Optional[List["_models.NamedAgentPoolProfile"]] = None,
        cloud_provider_profile: Optional["_models.CloudProviderProfile"] = None,
        license_profile: Optional["_models.ProvisionedClusterLicenseProfile"] = None,
        auto_scaler_profile: Optional["_models.ProvisionedClusterPropertiesAutoScalerProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword linux_profile: The profile for Linux VMs in the provisioned cluster.
        :paramtype linux_profile: ~azure.mgmt.hybridcontainerservice.models.LinuxProfileProperties
        :keyword control_plane: The profile for control plane of the provisioned cluster.
        :paramtype control_plane: ~azure.mgmt.hybridcontainerservice.models.ControlPlaneProfile
        :keyword kubernetes_version: The version of Kubernetes in use by the provisioned cluster.
        :paramtype kubernetes_version: str
        :keyword network_profile: The network configuration profile for the provisioned cluster.
        :paramtype network_profile: ~azure.mgmt.hybridcontainerservice.models.NetworkProfile
        :keyword storage_profile: The storage configuration profile for the provisioned cluster.
        :paramtype storage_profile: ~azure.mgmt.hybridcontainerservice.models.StorageProfile
        :keyword cluster_vm_access_profile: The SSH restricted access profile for the VMs in the
         provisioned cluster.
        :paramtype cluster_vm_access_profile:
         ~azure.mgmt.hybridcontainerservice.models.ClusterVMAccessProfile
        :keyword agent_pool_profiles: The agent pool properties for the provisioned cluster.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.hybridcontainerservice.models.NamedAgentPoolProfile]
        :keyword cloud_provider_profile: The profile for the underlying cloud infrastructure provider
         for the provisioned cluster.
        :paramtype cloud_provider_profile:
         ~azure.mgmt.hybridcontainerservice.models.CloudProviderProfile
        :keyword license_profile: The license profile of the provisioned cluster.
        :paramtype license_profile:
         ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterLicenseProfile
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when auto
         scaling is enabled for the provisioned cluster.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPropertiesAutoScalerProfile
        """
        super().__init__(**kwargs)
        self.linux_profile = linux_profile
        self.control_plane = control_plane
        self.kubernetes_version = kubernetes_version
        self.network_profile = network_profile
        self.storage_profile = storage_profile
        self.cluster_vm_access_profile = cluster_vm_access_profile
        self.agent_pool_profiles = agent_pool_profiles
        self.cloud_provider_profile = cloud_provider_profile
        self.provisioning_state = None
        self.status = None
        self.license_profile = license_profile
        self.auto_scaler_profile = auto_scaler_profile


class ProvisionedClusterPropertiesAutoScalerProfile(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes
    """Parameters to be applied to the cluster-autoscaler when auto scaling is enabled for the
    provisioned cluster.

    :ivar balance_similar_node_groups: Valid values are 'true' and 'false'.
    :vartype balance_similar_node_groups: str
    :ivar expander: If not specified, the default is 'random'. See `expanders
     <https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders>`_
     for more information. Known values are: "least-waste", "most-pods", "priority", and "random".
    :vartype expander: str or ~azure.mgmt.hybridcontainerservice.models.Expander
    :ivar max_empty_bulk_delete: The default is 10.
    :vartype max_empty_bulk_delete: str
    :ivar max_graceful_termination_sec: The default is 600.
    :vartype max_graceful_termination_sec: str
    :ivar max_node_provision_time: The default is '15m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype max_node_provision_time: str
    :ivar max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is 0.
    :vartype max_total_unready_percentage: str
    :ivar new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA to
     act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
     unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer
     followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
    :vartype new_pod_scale_up_delay: str
    :ivar ok_total_unready_count: This must be an integer. The default is 3.
    :vartype ok_total_unready_count: str
    :ivar scan_interval: The default is '10'. Values must be an integer number of seconds.
    :vartype scan_interval: str
    :ivar scale_down_delay_after_add: The default is '10m'. Values must be an integer followed by
     an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_add: str
    :ivar scale_down_delay_after_delete: The default is the scan-interval. Values must be an
     integer followed by an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_delete: str
    :ivar scale_down_delay_after_failure: The default is '3m'. Values must be an integer followed
     by an 'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_delay_after_failure: str
    :ivar scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_unneeded_time: str
    :ivar scale_down_unready_time: The default is '20m'. Values must be an integer followed by an
     'm'. No unit of time other than minutes (m) is supported.
    :vartype scale_down_unready_time: str
    :ivar scale_down_utilization_threshold: The default is '0.5'.
    :vartype scale_down_utilization_threshold: str
    :ivar skip_nodes_with_local_storage: The default is true.
    :vartype skip_nodes_with_local_storage: str
    :ivar skip_nodes_with_system_pods: The default is true.
    :vartype skip_nodes_with_system_pods: str
    """

    _attribute_map = {
        "balance_similar_node_groups": {"key": "balance-similar-node-groups", "type": "str"},
        "expander": {"key": "expander", "type": "str"},
        "max_empty_bulk_delete": {"key": "max-empty-bulk-delete", "type": "str"},
        "max_graceful_termination_sec": {"key": "max-graceful-termination-sec", "type": "str"},
        "max_node_provision_time": {"key": "max-node-provision-time", "type": "str"},
        "max_total_unready_percentage": {"key": "max-total-unready-percentage", "type": "str"},
        "new_pod_scale_up_delay": {"key": "new-pod-scale-up-delay", "type": "str"},
        "ok_total_unready_count": {"key": "ok-total-unready-count", "type": "str"},
        "scan_interval": {"key": "scan-interval", "type": "str"},
        "scale_down_delay_after_add": {"key": "scale-down-delay-after-add", "type": "str"},
        "scale_down_delay_after_delete": {"key": "scale-down-delay-after-delete", "type": "str"},
        "scale_down_delay_after_failure": {"key": "scale-down-delay-after-failure", "type": "str"},
        "scale_down_unneeded_time": {"key": "scale-down-unneeded-time", "type": "str"},
        "scale_down_unready_time": {"key": "scale-down-unready-time", "type": "str"},
        "scale_down_utilization_threshold": {"key": "scale-down-utilization-threshold", "type": "str"},
        "skip_nodes_with_local_storage": {"key": "skip-nodes-with-local-storage", "type": "str"},
        "skip_nodes_with_system_pods": {"key": "skip-nodes-with-system-pods", "type": "str"},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        expander: Optional[Union[str, "_models.Expander"]] = None,
        max_empty_bulk_delete: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        max_node_provision_time: Optional[str] = None,
        max_total_unready_percentage: Optional[str] = None,
        new_pod_scale_up_delay: Optional[str] = None,
        ok_total_unready_count: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        skip_nodes_with_local_storage: Optional[str] = None,
        skip_nodes_with_system_pods: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword balance_similar_node_groups: Valid values are 'true' and 'false'.
        :paramtype balance_similar_node_groups: str
        :keyword expander: If not specified, the default is 'random'. See `expanders
         <https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/FAQ.md#what-are-expanders>`_
         for more information. Known values are: "least-waste", "most-pods", "priority", and "random".
        :paramtype expander: str or ~azure.mgmt.hybridcontainerservice.models.Expander
        :keyword max_empty_bulk_delete: The default is 10.
        :paramtype max_empty_bulk_delete: str
        :keyword max_graceful_termination_sec: The default is 600.
        :paramtype max_graceful_termination_sec: str
        :keyword max_node_provision_time: The default is '15m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype max_node_provision_time: str
        :keyword max_total_unready_percentage: The default is 45. The maximum is 100 and the minimum is
         0.
        :paramtype max_total_unready_percentage: str
        :keyword new_pod_scale_up_delay: For scenarios like burst/batch scale where you don't want CA
         to act before the kubernetes scheduler could schedule all the pods, you can tell CA to ignore
         unscheduled pods before they're a certain age. The default is '0s'. Values must be an integer
         followed by a unit ('s' for seconds, 'm' for minutes, 'h' for hours, etc).
        :paramtype new_pod_scale_up_delay: str
        :keyword ok_total_unready_count: This must be an integer. The default is 3.
        :paramtype ok_total_unready_count: str
        :keyword scan_interval: The default is '10'. Values must be an integer number of seconds.
        :paramtype scan_interval: str
        :keyword scale_down_delay_after_add: The default is '10m'. Values must be an integer followed
         by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_add: str
        :keyword scale_down_delay_after_delete: The default is the scan-interval. Values must be an
         integer followed by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_delete: str
        :keyword scale_down_delay_after_failure: The default is '3m'. Values must be an integer
         followed by an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_delay_after_failure: str
        :keyword scale_down_unneeded_time: The default is '10m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_unneeded_time: str
        :keyword scale_down_unready_time: The default is '20m'. Values must be an integer followed by
         an 'm'. No unit of time other than minutes (m) is supported.
        :paramtype scale_down_unready_time: str
        :keyword scale_down_utilization_threshold: The default is '0.5'.
        :paramtype scale_down_utilization_threshold: str
        :keyword skip_nodes_with_local_storage: The default is true.
        :paramtype skip_nodes_with_local_storage: str
        :keyword skip_nodes_with_system_pods: The default is true.
        :paramtype skip_nodes_with_system_pods: str
        """
        super().__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.expander = expander
        self.max_empty_bulk_delete = max_empty_bulk_delete
        self.max_graceful_termination_sec = max_graceful_termination_sec
        self.max_node_provision_time = max_node_provision_time
        self.max_total_unready_percentage = max_total_unready_percentage
        self.new_pod_scale_up_delay = new_pod_scale_up_delay
        self.ok_total_unready_count = ok_total_unready_count
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.skip_nodes_with_local_storage = skip_nodes_with_local_storage
        self.skip_nodes_with_system_pods = skip_nodes_with_system_pods


class ProvisionedClusterPropertiesStatus(_serialization.Model):
    """The observed status of the provisioned cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar control_plane_status: The detailed status of the provisioned cluster components including
     addons.
    :vartype control_plane_status:
     list[~azure.mgmt.hybridcontainerservice.models.AddonStatusProfile]
    :ivar current_state: The current state of the provisioned cluster. Known values are:
     "Succeeded", "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading",
     and "Accepted".
    :vartype current_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar error_message: Error messages during a provisioned cluster operation or steady state.
    :vartype error_message: str
    """

    _validation = {
        "current_state": {"readonly": True},
    }

    _attribute_map = {
        "control_plane_status": {"key": "controlPlaneStatus", "type": "[AddonStatusProfile]"},
        "current_state": {"key": "currentState", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        control_plane_status: Optional[List["_models.AddonStatusProfile"]] = None,
        error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword control_plane_status: The detailed status of the provisioned cluster components
         including addons.
        :paramtype control_plane_status:
         list[~azure.mgmt.hybridcontainerservice.models.AddonStatusProfile]
        :keyword error_message: Error messages during a provisioned cluster operation or steady state.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.control_plane_status = control_plane_status
        self.current_state = None
        self.error_message = error_message


class ProvisionedClusterUpgradeProfile(ProxyResource):
    """The list of available kubernetes version upgrades for the provisioned cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar properties: The properties of the upgrade profile. Required.
    :vartype properties:
     ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterUpgradeProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ProvisionedClusterUpgradeProfileProperties"},
    }

    def __init__(self, *, properties: "_models.ProvisionedClusterUpgradeProfileProperties", **kwargs: Any) -> None:
        """
        :keyword properties: The properties of the upgrade profile. Required.
        :paramtype properties:
         ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterUpgradeProfileProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ProvisionedClusterUpgradeProfileProperties(_serialization.Model):
    """Control plane and agent pool upgrade profiles.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar control_plane_profile: The list of available kubernetes version upgrades for the control
     plane. Required.
    :vartype control_plane_profile:
     ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPoolUpgradeProfile
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "control_plane_profile": {"required": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "control_plane_profile": {"key": "controlPlaneProfile", "type": "ProvisionedClusterPoolUpgradeProfile"},
    }

    def __init__(self, *, control_plane_profile: "_models.ProvisionedClusterPoolUpgradeProfile", **kwargs: Any) -> None:
        """
        :keyword control_plane_profile: The list of available kubernetes version upgrades for the
         control plane. Required.
        :paramtype control_plane_profile:
         ~azure.mgmt.hybridcontainerservice.models.ProvisionedClusterPoolUpgradeProfile
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.control_plane_profile = control_plane_profile


class StorageProfile(_serialization.Model):
    """The storage configuration profile for the provisioned cluster.

    :ivar smb_csi_driver: SMB CSI Driver settings for the storage profile.
    :vartype smb_csi_driver: ~azure.mgmt.hybridcontainerservice.models.StorageProfileSmbCSIDriver
    :ivar nfs_csi_driver: NFS CSI Driver settings for the storage profile.
    :vartype nfs_csi_driver: ~azure.mgmt.hybridcontainerservice.models.StorageProfileNfsCSIDriver
    """

    _attribute_map = {
        "smb_csi_driver": {"key": "smbCsiDriver", "type": "StorageProfileSmbCSIDriver"},
        "nfs_csi_driver": {"key": "nfsCsiDriver", "type": "StorageProfileNfsCSIDriver"},
    }

    def __init__(
        self,
        *,
        smb_csi_driver: Optional["_models.StorageProfileSmbCSIDriver"] = None,
        nfs_csi_driver: Optional["_models.StorageProfileNfsCSIDriver"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword smb_csi_driver: SMB CSI Driver settings for the storage profile.
        :paramtype smb_csi_driver: ~azure.mgmt.hybridcontainerservice.models.StorageProfileSmbCSIDriver
        :keyword nfs_csi_driver: NFS CSI Driver settings for the storage profile.
        :paramtype nfs_csi_driver: ~azure.mgmt.hybridcontainerservice.models.StorageProfileNfsCSIDriver
        """
        super().__init__(**kwargs)
        self.smb_csi_driver = smb_csi_driver
        self.nfs_csi_driver = nfs_csi_driver


class StorageProfileNfsCSIDriver(_serialization.Model):
    """NFS CSI Driver settings for the storage profile.

    :ivar enabled: Indicates whether to enable NFS CSI Driver. The default value is true.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether to enable NFS CSI Driver. The default value is true.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class StorageProfileSmbCSIDriver(_serialization.Model):
    """SMB CSI Driver settings for the storage profile.

    :ivar enabled: Indicates whether to enable SMB CSI Driver. The default value is true.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword enabled: Indicates whether to enable SMB CSI Driver. The default value is true.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hybridcontainerservice.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hybridcontainerservice.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hybridcontainerservice.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.hybridcontainerservice.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class VirtualNetwork(TrackedResource):
    """The Virtual Network resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the virtual network resource.
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkProperties
    :ivar extended_location: Extended location pointing to the underlying infrastructure.
    :vartype extended_location:
     ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkExtendedLocation
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "VirtualNetworkProperties"},
        "extended_location": {"key": "extendedLocation", "type": "VirtualNetworkExtendedLocation"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.VirtualNetworkProperties"] = None,
        extended_location: Optional["_models.VirtualNetworkExtendedLocation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Properties of the virtual network resource.
        :paramtype properties: ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkProperties
        :keyword extended_location: Extended location pointing to the underlying infrastructure.
        :paramtype extended_location:
         ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkExtendedLocation
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.extended_location = extended_location


class VirtualNetworkExtendedLocation(_serialization.Model):
    """Extended location pointing to the underlying infrastructure.

    :ivar type: The extended location type. Allowed value: 'CustomLocation'. "CustomLocation"
    :vartype type: str or ~azure.mgmt.hybridcontainerservice.models.ExtendedLocationTypes
    :ivar name: ARM Id of the extended location.
    :vartype name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The extended location type. Allowed value: 'CustomLocation'. "CustomLocation"
        :paramtype type: str or ~azure.mgmt.hybridcontainerservice.models.ExtendedLocationTypes
        :keyword name: ARM Id of the extended location.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class VirtualNetworkProperties(_serialization.Model):
    """Properties of the virtual network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar infra_vnet_profile:
    :vartype infra_vnet_profile:
     ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesInfraVnetProfile
    :ivar vip_pool: Range of IP Addresses for Kubernetes API Server and services if using HA Proxy
     load balancer.
    :vartype vip_pool:
     list[~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesVipPoolItem]
    :ivar vmip_pool: Range of IP Addresses for Kubernetes node VMs.
    :vartype vmip_pool:
     list[~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesVmipPoolItem]
    :ivar dns_servers: List of DNS server IP Addresses associated with the network.
    :vartype dns_servers: list[str]
    :ivar gateway: IP Address of the Gateway associated with the network.
    :vartype gateway: str
    :ivar ip_address_prefix: IP Address Prefix of the network.
    :vartype ip_address_prefix: str
    :ivar vlan_id: VLAN Id used by the network.
    :vartype vlan_id: int
    :ivar provisioning_state: Known values are: "Succeeded", "Failed", "Canceled", "Pending",
     "Creating", "Deleting", "Updating", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.hybridcontainerservice.models.ProvisioningState
    :ivar status: Status of the virtual network resource.
    :vartype status: ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "infra_vnet_profile": {"key": "infraVnetProfile", "type": "VirtualNetworkPropertiesInfraVnetProfile"},
        "vip_pool": {"key": "vipPool", "type": "[VirtualNetworkPropertiesVipPoolItem]"},
        "vmip_pool": {"key": "vmipPool", "type": "[VirtualNetworkPropertiesVmipPoolItem]"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "gateway": {"key": "gateway", "type": "str"},
        "ip_address_prefix": {"key": "ipAddressPrefix", "type": "str"},
        "vlan_id": {"key": "vlanID", "type": "int"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "VirtualNetworkPropertiesStatus"},
    }

    def __init__(
        self,
        *,
        infra_vnet_profile: Optional["_models.VirtualNetworkPropertiesInfraVnetProfile"] = None,
        vip_pool: Optional[List["_models.VirtualNetworkPropertiesVipPoolItem"]] = None,
        vmip_pool: Optional[List["_models.VirtualNetworkPropertiesVmipPoolItem"]] = None,
        dns_servers: Optional[List[str]] = None,
        gateway: Optional[str] = None,
        ip_address_prefix: Optional[str] = None,
        vlan_id: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword infra_vnet_profile:
        :paramtype infra_vnet_profile:
         ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesInfraVnetProfile
        :keyword vip_pool: Range of IP Addresses for Kubernetes API Server and services if using HA
         Proxy load balancer.
        :paramtype vip_pool:
         list[~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesVipPoolItem]
        :keyword vmip_pool: Range of IP Addresses for Kubernetes node VMs.
        :paramtype vmip_pool:
         list[~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesVmipPoolItem]
        :keyword dns_servers: List of DNS server IP Addresses associated with the network.
        :paramtype dns_servers: list[str]
        :keyword gateway: IP Address of the Gateway associated with the network.
        :paramtype gateway: str
        :keyword ip_address_prefix: IP Address Prefix of the network.
        :paramtype ip_address_prefix: str
        :keyword vlan_id: VLAN Id used by the network.
        :paramtype vlan_id: int
        """
        super().__init__(**kwargs)
        self.infra_vnet_profile = infra_vnet_profile
        self.vip_pool = vip_pool
        self.vmip_pool = vmip_pool
        self.dns_servers = dns_servers
        self.gateway = gateway
        self.ip_address_prefix = ip_address_prefix
        self.vlan_id = vlan_id
        self.provisioning_state = None
        self.status = None


class VirtualNetworkPropertiesInfraVnetProfile(_serialization.Model):
    """VirtualNetworkPropertiesInfraVnetProfile.

    :ivar hci: Infrastructure network profile for HCI platform.
    :vartype hci:
     ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesInfraVnetProfileHci
    """

    _attribute_map = {
        "hci": {"key": "hci", "type": "VirtualNetworkPropertiesInfraVnetProfileHci"},
    }

    def __init__(
        self, *, hci: Optional["_models.VirtualNetworkPropertiesInfraVnetProfileHci"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword hci: Infrastructure network profile for HCI platform.
        :paramtype hci:
         ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesInfraVnetProfileHci
        """
        super().__init__(**kwargs)
        self.hci = hci


class VirtualNetworkPropertiesInfraVnetProfileHci(_serialization.Model):
    """Infrastructure network profile for HCI platform.

    :ivar moc_group: Group in MOC(Microsoft On-premises Cloud).
    :vartype moc_group: str
    :ivar moc_location: Location in MOC(Microsoft On-premises Cloud).
    :vartype moc_location: str
    :ivar moc_vnet_name: Virtual Network name in MOC(Microsoft On-premises Cloud).
    :vartype moc_vnet_name: str
    """

    _attribute_map = {
        "moc_group": {"key": "mocGroup", "type": "str"},
        "moc_location": {"key": "mocLocation", "type": "str"},
        "moc_vnet_name": {"key": "mocVnetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        moc_group: Optional[str] = None,
        moc_location: Optional[str] = None,
        moc_vnet_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword moc_group: Group in MOC(Microsoft On-premises Cloud).
        :paramtype moc_group: str
        :keyword moc_location: Location in MOC(Microsoft On-premises Cloud).
        :paramtype moc_location: str
        :keyword moc_vnet_name: Virtual Network name in MOC(Microsoft On-premises Cloud).
        :paramtype moc_vnet_name: str
        """
        super().__init__(**kwargs)
        self.moc_group = moc_group
        self.moc_location = moc_location
        self.moc_vnet_name = moc_vnet_name


class VirtualNetworkPropertiesStatus(_serialization.Model):
    """Status of the virtual network resource.

    :ivar operation_status: The detailed status of the long running operation.
    :vartype operation_status:
     ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesStatusOperationStatus
    """

    _attribute_map = {
        "operation_status": {"key": "operationStatus", "type": "VirtualNetworkPropertiesStatusOperationStatus"},
    }

    def __init__(
        self,
        *,
        operation_status: Optional["_models.VirtualNetworkPropertiesStatusOperationStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_status: The detailed status of the long running operation.
        :paramtype operation_status:
         ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesStatusOperationStatus
        """
        super().__init__(**kwargs)
        self.operation_status = operation_status


class VirtualNetworkPropertiesStatusOperationStatus(_serialization.Model):
    """The detailed status of the long running operation.

    :ivar error: The error if any from the operation.
    :vartype error:
     ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesStatusOperationStatusError
    :ivar operation_id: The identifier of the operation.
    :vartype operation_id: str
    :ivar status: The status of the operation.
    :vartype status: str
    """

    _attribute_map = {
        "error": {"key": "error", "type": "VirtualNetworkPropertiesStatusOperationStatusError"},
        "operation_id": {"key": "operationId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.VirtualNetworkPropertiesStatusOperationStatusError"] = None,
        operation_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: The error if any from the operation.
        :paramtype error:
         ~azure.mgmt.hybridcontainerservice.models.VirtualNetworkPropertiesStatusOperationStatusError
        :keyword operation_id: The identifier of the operation.
        :paramtype operation_id: str
        :keyword status: The status of the operation.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.error = error
        self.operation_id = operation_id
        self.status = status


class VirtualNetworkPropertiesStatusOperationStatusError(_serialization.Model):
    """The error if any from the operation.

    :ivar code: The error code from the operation.
    :vartype code: str
    :ivar message: The error message from the operation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The error code from the operation.
        :paramtype code: str
        :keyword message: The error message from the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class VirtualNetworkPropertiesVipPoolItem(_serialization.Model):
    """VirtualNetworkPropertiesVipPoolItem.

    :ivar end_ip: Ending IP address for the IP Pool.
    :vartype end_ip: str
    :ivar start_ip: Starting IP address for the IP Pool.
    :vartype start_ip: str
    """

    _attribute_map = {
        "end_ip": {"key": "endIP", "type": "str"},
        "start_ip": {"key": "startIP", "type": "str"},
    }

    def __init__(self, *, end_ip: Optional[str] = None, start_ip: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword end_ip: Ending IP address for the IP Pool.
        :paramtype end_ip: str
        :keyword start_ip: Starting IP address for the IP Pool.
        :paramtype start_ip: str
        """
        super().__init__(**kwargs)
        self.end_ip = end_ip
        self.start_ip = start_ip


class VirtualNetworkPropertiesVmipPoolItem(_serialization.Model):
    """VirtualNetworkPropertiesVmipPoolItem.

    :ivar end_ip: Ending IP address for the IP Pool.
    :vartype end_ip: str
    :ivar start_ip: Starting IP address for the IP Pool.
    :vartype start_ip: str
    """

    _attribute_map = {
        "end_ip": {"key": "endIP", "type": "str"},
        "start_ip": {"key": "startIP", "type": "str"},
    }

    def __init__(self, *, end_ip: Optional[str] = None, start_ip: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword end_ip: Ending IP address for the IP Pool.
        :paramtype end_ip: str
        :keyword start_ip: Starting IP address for the IP Pool.
        :paramtype start_ip: str
        """
        super().__init__(**kwargs)
        self.end_ip = end_ip
        self.start_ip = start_ip


class VirtualNetworksListResult(_serialization.Model):
    """A list of virtual network resources.

    :ivar value:
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.VirtualNetwork]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.VirtualNetwork]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworksPatch(_serialization.Model):
    """The Virtual Network resource patch definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class VmSkuCapabilities(_serialization.Model):
    """Describes the VM SKU capabilities like MemoryGB, vCPUs, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the VM SKU capability.
    :vartype name: str
    :ivar value: Value of the VM SKU capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class VmSkuProfile(ProxyResource):
    """The list of supported VM SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcontainerservice.models.SystemData
    :ivar extended_location: Extended location pointing to the underlying infrastructure.
    :vartype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
    :ivar properties:
    :vartype properties: ~azure.mgmt.hybridcontainerservice.models.VmSkuProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "properties": {"key": "properties", "type": "VmSkuProfileProperties"},
    }

    def __init__(self, *, extended_location: Optional["_models.ExtendedLocation"] = None, **kwargs: Any) -> None:
        """
        :keyword extended_location: Extended location pointing to the underlying infrastructure.
        :paramtype extended_location: ~azure.mgmt.hybridcontainerservice.models.ExtendedLocation
        """
        super().__init__(**kwargs)
        self.extended_location = extended_location
        self.properties = None


class VmSkuProfileList(_serialization.Model):
    """The list of supported VM SKUs.

    :ivar value:
    :vartype value: list[~azure.mgmt.hybridcontainerservice.models.VmSkuProfile]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VmSkuProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VmSkuProfile"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.hybridcontainerservice.models.VmSkuProfile]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VmSkuProfileProperties(_serialization.Model):
    """VmSkuProfileProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Creating", "Deleting", "Updating", "Upgrading", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.hybridcontainerservice.models.ResourceProvisioningState
    :ivar values: List of supported VM SKUs.
    :vartype values: list[~azure.mgmt.hybridcontainerservice.models.VmSkuProperties]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "values": {"key": "values", "type": "[VmSkuProperties]"},
    }

    def __init__(self, *, values: Optional[List["_models.VmSkuProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword values: List of supported VM SKUs.
        :paramtype values: list[~azure.mgmt.hybridcontainerservice.models.VmSkuProperties]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.values = values


class VmSkuProperties(_serialization.Model):
    """The profile for supported VM SKUs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar capabilities: The list of name-value pairs to describe VM SKU capabilities like MemoryGB,
     vCPUs, etc.
    :vartype capabilities: list[~azure.mgmt.hybridcontainerservice.models.VmSkuCapabilities]
    :ivar name: The name of the VM SKU.
    :vartype name: str
    :ivar tier: The tier of the VM SKU.
    :vartype tier: str
    :ivar size: The size of the VM SKU.
    :vartype size: str
    """

    _validation = {
        "resource_type": {"readonly": True},
        "capabilities": {"readonly": True},
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "size": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "capabilities": {"key": "capabilities", "type": "[VmSkuCapabilities]"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type = None
        self.capabilities = None
        self.name = None
        self.tier = None
        self.size = None
