# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, Generic, IO, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class BlobOperations:
    """BlobOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.storage.blob.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def download(
        self,
        snapshot: Optional[str] = None,
        version_id: Optional[str] = None,
        timeout: Optional[int] = None,
        range: Optional[str] = None,
        range_get_content_md5: Optional[bool] = None,
        range_get_content_crc64: Optional[bool] = None,
        encryption_algorithm: Optional[str] = "AES256",
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        cpk_info: Optional["_models.CpkInfo"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> IO:
        """The Download operation reads or downloads a blob from the system, including its metadata and
        properties. You can also call Download to read a snapshot.

        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param range: Return only the bytes of the blob in the specified range.
        :type range: str
        :param range_get_content_md5: When set to true and specified together with the Range, the
         service returns the MD5 hash for the range, as long as the range is less than or equal to 4 MB
         in size.
        :type range_get_content_md5: bool
        :param range_get_content_crc64: When set to true and specified together with the Range, the
         service returns the CRC64 hash for the range, as long as the range is less than or equal to 4
         MB in size.
        :type range_get_content_crc64: bool
        :param encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
         the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
         provided.
        :type encryption_algorithm: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        accept = "application/xml"

        # Construct URL
        url = self.download.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if range is not None:
            header_parameters['x-ms-range'] = self._serialize.header("range", range, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if range_get_content_md5 is not None:
            header_parameters['x-ms-range-get-content-md5'] = self._serialize.header("range_get_content_md5", range_get_content_md5, 'bool')
        if range_get_content_crc64 is not None:
            header_parameters['x-ms-range-get-content-crc64'] = self._serialize.header("range_get_content_crc64", range_get_content_crc64, 'bool')
        if _encryption_key is not None:
            header_parameters['x-ms-encryption-key'] = self._serialize.header("encryption_key", _encryption_key, 'str')
        if _encryption_key_sha256 is not None:
            header_parameters['x-ms-encryption-key-sha256'] = self._serialize.header("encryption_key_sha256", _encryption_key_sha256, 'str')
        if encryption_algorithm is not None:
            header_parameters['x-ms-encryption-algorithm'] = self._serialize.header("encryption_algorithm", encryption_algorithm, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('str', response.headers.get('x-ms-meta'))
            response_headers['x-ms-or-policy-id']=self._deserialize('str', response.headers.get('x-ms-or-policy-id'))
            response_headers['x-ms-or']=self._deserialize('str', response.headers.get('x-ms-or'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
            response_headers['x-ms-blob-type']=self._deserialize('str', response.headers.get('x-ms-blob-type'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-blob-committed-block-count']=self._deserialize('int', response.headers.get('x-ms-blob-committed-block-count'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
            response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))
            response_headers['x-ms-blob-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-blob-content-md5'))
            response_headers['x-ms-tag-count']=self._deserialize('long', response.headers.get('x-ms-tag-count'))
            response_headers['x-ms-blob-sealed']=self._deserialize('bool', response.headers.get('x-ms-blob-sealed'))
            response_headers['x-ms-last-access-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-last-access-time'))
            deserialized = response.stream_download(self._client._pipeline)

        if response.status_code == 206:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('str', response.headers.get('x-ms-meta'))
            response_headers['x-ms-or-policy-id']=self._deserialize('str', response.headers.get('x-ms-or-policy-id'))
            response_headers['x-ms-or']=self._deserialize('str', response.headers.get('x-ms-or'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
            response_headers['x-ms-blob-type']=self._deserialize('str', response.headers.get('x-ms-blob-type'))
            response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-blob-committed-block-count']=self._deserialize('int', response.headers.get('x-ms-blob-committed-block-count'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
            response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))
            response_headers['x-ms-blob-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-blob-content-md5'))
            response_headers['x-ms-tag-count']=self._deserialize('long', response.headers.get('x-ms-tag-count'))
            response_headers['x-ms-blob-sealed']=self._deserialize('bool', response.headers.get('x-ms-blob-sealed'))
            response_headers['x-ms-last-access-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-last-access-time'))
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    download.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def get_properties(
        self,
        snapshot: Optional[str] = None,
        version_id: Optional[str] = None,
        timeout: Optional[int] = None,
        encryption_algorithm: Optional[str] = "AES256",
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        cpk_info: Optional["_models.CpkInfo"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Get Properties operation returns all user-defined metadata, standard HTTP properties, and
        system properties for the blob. It does not return the content of the blob.

        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
         the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
         provided.
        :type encryption_algorithm: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        accept = "application/xml"

        # Construct URL
        url = self.get_properties.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _encryption_key is not None:
            header_parameters['x-ms-encryption-key'] = self._serialize.header("encryption_key", _encryption_key, 'str')
        if _encryption_key_sha256 is not None:
            header_parameters['x-ms-encryption-key-sha256'] = self._serialize.header("encryption_key_sha256", _encryption_key_sha256, 'str')
        if encryption_algorithm is not None:
            header_parameters['x-ms-encryption-algorithm'] = self._serialize.header("encryption_algorithm", encryption_algorithm, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-creation-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-creation-time'))
        response_headers['x-ms-meta']=self._deserialize('str', response.headers.get('x-ms-meta'))
        response_headers['x-ms-or-policy-id']=self._deserialize('str', response.headers.get('x-ms-or-policy-id'))
        response_headers['x-ms-or']=self._deserialize('str', response.headers.get('x-ms-or'))
        response_headers['x-ms-blob-type']=self._deserialize('str', response.headers.get('x-ms-blob-type'))
        response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
        response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
        response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
        response_headers['x-ms-incremental-copy']=self._deserialize('bool', response.headers.get('x-ms-incremental-copy'))
        response_headers['x-ms-copy-destination-snapshot']=self._deserialize('str', response.headers.get('x-ms-copy-destination-snapshot'))
        response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
        response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
        response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
        response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
        response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
        response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
        response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
        response_headers['x-ms-blob-committed-block-count']=self._deserialize('int', response.headers.get('x-ms-blob-committed-block-count'))
        response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))
        response_headers['x-ms-access-tier']=self._deserialize('str', response.headers.get('x-ms-access-tier'))
        response_headers['x-ms-access-tier-inferred']=self._deserialize('bool', response.headers.get('x-ms-access-tier-inferred'))
        response_headers['x-ms-archive-status']=self._deserialize('str', response.headers.get('x-ms-archive-status'))
        response_headers['x-ms-access-tier-change-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-access-tier-change-time'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['x-ms-is-current-version']=self._deserialize('bool', response.headers.get('x-ms-is-current-version'))
        response_headers['x-ms-tag-count']=self._deserialize('long', response.headers.get('x-ms-tag-count'))
        response_headers['x-ms-expiry-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-expiry-time'))
        response_headers['x-ms-blob-sealed']=self._deserialize('bool', response.headers.get('x-ms-blob-sealed'))
        response_headers['x-ms-rehydrate-priority']=self._deserialize('str', response.headers.get('x-ms-rehydrate-priority'))
        response_headers['x-ms-last-access-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-last-access-time'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_properties.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def delete(
        self,
        snapshot: Optional[str] = None,
        version_id: Optional[str] = None,
        timeout: Optional[int] = None,
        delete_snapshots: Optional[Union[str, "_models.DeleteSnapshotsOptionType"]] = None,
        request_id_parameter: Optional[str] = None,
        blob_delete_type: Optional[str] = "Permanent",
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """If the storage account's soft delete feature is disabled then, when a blob is deleted, it is
        permanently removed from the storage account. If the storage account's soft delete feature is
        enabled, then, when a blob is deleted, it is marked for deletion and becomes inaccessible
        immediately. However, the blob service retains the blob or snapshot for the number of days
        specified by the DeleteRetentionPolicy section of [Storage service properties] (Set-Blob-
        Service-Properties.md). After the specified number of days has passed, the blob's data is
        permanently removed from the storage account. Note that you continue to be charged for the
        soft-deleted blob's storage until it is permanently removed. Use the List Blobs API and specify
        the "include=deleted" query parameter to discover which blobs and snapshots have been soft
        deleted. You can then use the Undelete Blob API to restore a soft-deleted blob. All other
        operations on a soft-deleted blob or snapshot causes the service to return an HTTP status code
        of 404 (ResourceNotFound).

        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param delete_snapshots: Required if the blob has associated snapshots. Specify one of the
         following two options: include: Delete the base blob and all of its snapshots. only: Delete
         only the blob's snapshots and not the blob itself.
        :type delete_snapshots: str or ~azure.storage.blob.models.DeleteSnapshotsOptionType
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param blob_delete_type: Optional.  Only possible value is 'permanent', which specifies to
         permanently delete a blob if blob soft delete is enabled.
        :type blob_delete_type: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        accept = "application/xml"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if blob_delete_type is not None:
            query_parameters['deletetype'] = self._serialize.query("blob_delete_type", blob_delete_type, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if delete_snapshots is not None:
            header_parameters['x-ms-delete-snapshots'] = self._serialize.header("delete_snapshots", delete_snapshots, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    delete.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_access_control(
        self,
        timeout: Optional[int] = None,
        owner: Optional[str] = None,
        group: Optional[str] = None,
        posix_permissions: Optional[str] = None,
        posix_acl: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """Set the owner, group, permissions, or access control list for a blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param owner: Optional. The owner of the blob or directory.
        :type owner: str
        :param group: Optional. The owning group of the blob or directory.
        :type group: str
        :param posix_permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type posix_permissions: str
        :param posix_acl: Sets POSIX access control rights on files and directories. The value is a
         comma-separated list of access control entries. Each access control entry (ACE) consists of a
         scope, a type, a user or group identifier, and permissions in the format
         "[scope:][type]:[id]:[permissions]".
        :type posix_acl: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        action = "setAccessControl"
        accept = "application/xml"

        # Construct URL
        url = self.set_access_control.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if owner is not None:
            header_parameters['x-ms-owner'] = self._serialize.header("owner", owner, 'str')
        if group is not None:
            header_parameters['x-ms-group'] = self._serialize.header("group", group, 'str')
        if posix_permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("posix_permissions", posix_permissions, 'str')
        if posix_acl is not None:
            header_parameters['x-ms-acl'] = self._serialize.header("posix_acl", posix_acl, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.patch(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_access_control.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    async def get_access_control(
        self,
        timeout: Optional[int] = None,
        upn: Optional[bool] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """Get the owner, group, permissions, or access control list for a blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param upn: Optional. Valid only when Hierarchical Namespace is enabled for the account. If
         "true", the identity values returned in the x-ms-owner, x-ms-group, and x-ms-acl response
         headers will be transformed from Azure Active Directory Object IDs to User Principal Names.  If
         "false", the values will be returned as Azure Active Directory Object IDs. The default value is
         false.
        :type upn: bool
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_match = None
        _if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
        action = "getAccessControl"
        accept = "application/xml"

        # Construct URL
        url = self.get_access_control.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['action'] = self._serialize.query("action", action, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if upn is not None:
            query_parameters['upn'] = self._serialize.query("upn", upn, 'bool')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-owner']=self._deserialize('str', response.headers.get('x-ms-owner'))
        response_headers['x-ms-group']=self._deserialize('str', response.headers.get('x-ms-group'))
        response_headers['x-ms-permissions']=self._deserialize('str', response.headers.get('x-ms-permissions'))
        response_headers['x-ms-acl']=self._deserialize('str', response.headers.get('x-ms-acl'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_access_control.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    async def rename(
        self,
        rename_source: str,
        timeout: Optional[int] = None,
        path_rename_mode: Optional[Union[str, "_models.PathRenameMode"]] = None,
        directory_properties: Optional[str] = None,
        posix_permissions: Optional[str] = None,
        posix_umask: Optional[str] = None,
        source_lease_id: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        directory_http_headers: Optional["_models.DirectoryHttpHeaders"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        source_modified_access_conditions: Optional["_models.SourceModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """Rename a blob/file.  By default, the destination is overwritten and if the destination already
        exists and has a lease the lease is broken.  This operation supports conditional HTTP requests.
        For more information, see `Specifying Conditional Headers for Blob Service Operations
        <https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-
        blob-service-operations>`_.  To fail if the destination already exists, use a conditional
        request with If-None-Match: "*".

        :param rename_source: The file or directory to be renamed. The value must have the following
         format: "/{filesysystem}/{path}".  If "x-ms-properties" is specified, the properties will
         overwrite the existing properties; otherwise, the existing properties will be preserved.
        :type rename_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param path_rename_mode: Determines the behavior of the rename operation.
        :type path_rename_mode: str or ~azure.storage.blob.models.PathRenameMode
        :param directory_properties: Optional.  User-defined properties to be stored with the file or
         directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2, ...",
         where each value is base64 encoded.
        :type directory_properties: str
        :param posix_permissions: Optional and only valid if Hierarchical Namespace is enabled for the
         account. Sets POSIX access permissions for the file owner, the file owning group, and others.
         Each class may be granted read, write, or execute permission.  The sticky bit is also
         supported.  Both symbolic (rwxrw-rw-) and 4-digit octal notation (e.g. 0766) are supported.
        :type posix_permissions: str
        :param posix_umask: Only valid if Hierarchical Namespace is enabled for the account. This umask
         restricts permission settings for file and directory, and will only be applied when default Acl
         does not exist in parent directory. If the umask bit has set, it means that the corresponding
         permission will be disabled. Otherwise the corresponding permission will be determined by the
         permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
         a default umask - 0027 will be used.
        :type posix_umask: str
        :param source_lease_id: A lease ID for the source path. If specified, the source path must have
         an active lease and the lease ID must match.
        :type source_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param directory_http_headers: Parameter group.
        :type directory_http_headers: ~azure.storage.blob.models.DirectoryHttpHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param source_modified_access_conditions: Parameter group.
        :type source_modified_access_conditions: ~azure.storage.blob.models.SourceModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _cache_control = None
        _content_type = None
        _content_encoding = None
        _content_language = None
        _content_disposition = None
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        if directory_http_headers is not None:
            _cache_control = directory_http_headers.cache_control
            _content_type = directory_http_headers.content_type
            _content_encoding = directory_http_headers.content_encoding
            _content_language = directory_http_headers.content_language
            _content_disposition = directory_http_headers.content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
        accept = "application/xml"

        # Construct URL
        url = self.rename.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if path_rename_mode is not None:
            query_parameters['mode'] = self._serialize.query("path_rename_mode", path_rename_mode, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-rename-source'] = self._serialize.header("rename_source", rename_source, 'str')
        if directory_properties is not None:
            header_parameters['x-ms-properties'] = self._serialize.header("directory_properties", directory_properties, 'str')
        if posix_permissions is not None:
            header_parameters['x-ms-permissions'] = self._serialize.header("posix_permissions", posix_permissions, 'str')
        if posix_umask is not None:
            header_parameters['x-ms-umask'] = self._serialize.header("posix_umask", posix_umask, 'str')
        if _cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("cache_control", _cache_control, 'str')
        if _content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("content_type", _content_type, 'str')
        if _content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("content_encoding", _content_encoding, 'str')
        if _content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("content_language", _content_language, 'str')
        if _content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("content_disposition", _content_disposition, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if source_lease_id is not None:
            header_parameters['x-ms-source-lease-id'] = self._serialize.header("source_lease_id", source_lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", _source_if_modified_since, 'rfc-1123')
        if _source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", _source_if_unmodified_since, 'rfc-1123')
        if _source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", _source_if_match, 'str')
        if _source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", _source_if_none_match, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.DataLakeStorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    rename.metadata = {'url': '/{filesystem}/{path}'}  # type: ignore

    async def undelete(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs
    ) -> None:
        """Undelete a blob that was previously soft deleted.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        comp = "undelete"
        accept = "application/xml"

        # Construct URL
        url = self.undelete.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    undelete.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_expiry(
        self,
        expiry_options: Union[str, "_models.BlobExpiryOptions"],
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        expires_on: Optional[str] = None,
        **kwargs
    ) -> None:
        """Sets the time a blob will expire and be deleted.

        :param expiry_options: Required. Indicates mode of the expiry time.
        :type expiry_options: str or ~azure.storage.blob.models.BlobExpiryOptions
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param expires_on: The time to set the blob to expiry.
        :type expires_on: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        comp = "expiry"
        accept = "application/xml"

        # Construct URL
        url = self.set_expiry.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['x-ms-expiry-option'] = self._serialize.header("expiry_options", expiry_options, 'str')
        if expires_on is not None:
            header_parameters['x-ms-expiry-time'] = self._serialize.header("expires_on", expires_on, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_expiry.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_http_headers(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        blob_http_headers: Optional["_models.BlobHTTPHeaders"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Set HTTP Headers operation sets system properties on the blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param blob_http_headers: Parameter group.
        :type blob_http_headers: ~azure.storage.blob.models.BlobHTTPHeaders
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _blob_cache_control = None
        _blob_content_type = None
        _blob_content_md5 = None
        _blob_content_encoding = None
        _blob_content_language = None
        _lease_id = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        _blob_content_disposition = None
        if blob_http_headers is not None:
            _blob_cache_control = blob_http_headers.blob_cache_control
            _blob_content_type = blob_http_headers.blob_content_type
            _blob_content_md5 = blob_http_headers.blob_content_md5
            _blob_content_encoding = blob_http_headers.blob_content_encoding
            _blob_content_language = blob_http_headers.blob_content_language
            _blob_content_disposition = blob_http_headers.blob_content_disposition
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "properties"
        accept = "application/xml"

        # Construct URL
        url = self.set_http_headers.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _blob_cache_control is not None:
            header_parameters['x-ms-blob-cache-control'] = self._serialize.header("blob_cache_control", _blob_cache_control, 'str')
        if _blob_content_type is not None:
            header_parameters['x-ms-blob-content-type'] = self._serialize.header("blob_content_type", _blob_content_type, 'str')
        if _blob_content_md5 is not None:
            header_parameters['x-ms-blob-content-md5'] = self._serialize.header("blob_content_md5", _blob_content_md5, 'bytearray')
        if _blob_content_encoding is not None:
            header_parameters['x-ms-blob-content-encoding'] = self._serialize.header("blob_content_encoding", _blob_content_encoding, 'str')
        if _blob_content_language is not None:
            header_parameters['x-ms-blob-content-language'] = self._serialize.header("blob_content_language", _blob_content_language, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        if _blob_content_disposition is not None:
            header_parameters['x-ms-blob-content-disposition'] = self._serialize.header("blob_content_disposition", _blob_content_disposition, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_http_headers.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_metadata(
        self,
        timeout: Optional[int] = None,
        metadata: Optional[str] = None,
        encryption_algorithm: Optional[str] = "AES256",
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        cpk_info: Optional["_models.CpkInfo"] = None,
        cpk_scope_info: Optional["_models.CpkScopeInfo"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Set Blob Metadata operation sets user-defined metadata for the specified blob as one or
        more name-value pairs.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information.
        :type metadata: str
        :param encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
         the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
         provided.
        :type encryption_algorithm: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_scope = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "metadata"
        accept = "application/xml"

        # Construct URL
        url = self.set_metadata.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _encryption_key is not None:
            header_parameters['x-ms-encryption-key'] = self._serialize.header("encryption_key", _encryption_key, 'str')
        if _encryption_key_sha256 is not None:
            header_parameters['x-ms-encryption-key-sha256'] = self._serialize.header("encryption_key_sha256", _encryption_key_sha256, 'str')
        if encryption_algorithm is not None:
            header_parameters['x-ms-encryption-algorithm'] = self._serialize.header("encryption_algorithm", encryption_algorithm, 'str')
        if _encryption_scope is not None:
            header_parameters['x-ms-encryption-scope'] = self._serialize.header("encryption_scope", _encryption_scope, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))
        response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
        response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_metadata.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def acquire_lease(
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """[Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The Blob service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats.
        :type proposed_lease_id: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "lease"
        action = "acquire"
        accept = "application/xml"

        # Construct URL
        url = self.acquire_lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        if duration is not None:
            header_parameters['x-ms-lease-duration'] = self._serialize.header("duration", duration, 'int')
        if proposed_lease_id is not None:
            header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    acquire_lease.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def release_lease(
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """[Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "lease"
        action = "release"
        accept = "application/xml"

        # Construct URL
        url = self.release_lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    release_lease.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def renew_lease(
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """[Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "lease"
        action = "renew"
        accept = "application/xml"

        # Construct URL
        url = self.renew_lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    renew_lease.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def change_lease(
        self,
        lease_id: str,
        proposed_lease_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """[Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
        operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The Blob service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats.
        :type proposed_lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "lease"
        action = "change"
        accept = "application/xml"

        # Construct URL
        url = self.change_lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-lease-id']=self._deserialize('str', response.headers.get('x-ms-lease-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    change_lease.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def break_lease(
        self,
        timeout: Optional[int] = None,
        break_period: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """[Update] The Lease Blob operation establishes and manages a lock on a blob for write and delete
        operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param break_period: For a break operation, proposed duration the lease should continue before
         it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter
         than the time remaining on the lease. If longer, the time remaining on the lease is used. A new
         lease will not be available before the break period has expired, but the lease may be held for
         longer than the break period. If this header does not appear with a break operation, a fixed-
         duration lease breaks after the remaining lease period elapses, and an infinite lease breaks
         immediately.
        :type break_period: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "lease"
        action = "break"
        accept = "application/xml"

        # Construct URL
        url = self.break_lease.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        if break_period is not None:
            header_parameters['x-ms-lease-break-period'] = self._serialize.header("break_period", break_period, 'int')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-lease-time']=self._deserialize('int', response.headers.get('x-ms-lease-time'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    break_lease.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def create_snapshot(
        self,
        timeout: Optional[int] = None,
        metadata: Optional[str] = None,
        encryption_algorithm: Optional[str] = "AES256",
        request_id_parameter: Optional[str] = None,
        cpk_info: Optional["_models.CpkInfo"] = None,
        cpk_scope_info: Optional["_models.CpkScopeInfo"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Create Snapshot operation creates a read-only snapshot of a blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information.
        :type metadata: str
        :param encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
         the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
         provided.
        :type encryption_algorithm: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param cpk_info: Parameter group.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param cpk_scope_info: Parameter group.
        :type cpk_scope_info: ~azure.storage.blob.models.CpkScopeInfo
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _encryption_key = None
        _encryption_key_sha256 = None
        _encryption_scope = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        _lease_id = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
        if cpk_scope_info is not None:
            _encryption_scope = cpk_scope_info.encryption_scope
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "snapshot"
        accept = "application/xml"

        # Construct URL
        url = self.create_snapshot.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        if _encryption_key is not None:
            header_parameters['x-ms-encryption-key'] = self._serialize.header("encryption_key", _encryption_key, 'str')
        if _encryption_key_sha256 is not None:
            header_parameters['x-ms-encryption-key-sha256'] = self._serialize.header("encryption_key_sha256", _encryption_key_sha256, 'str')
        if encryption_algorithm is not None:
            header_parameters['x-ms-encryption-algorithm'] = self._serialize.header("encryption_algorithm", encryption_algorithm, 'str')
        if _encryption_scope is not None:
            header_parameters['x-ms-encryption-scope'] = self._serialize.header("encryption_scope", _encryption_scope, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-snapshot']=self._deserialize('str', response.headers.get('x-ms-snapshot'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-request-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    create_snapshot.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def start_copy_from_url(
        self,
        copy_source: str,
        timeout: Optional[int] = None,
        metadata: Optional[str] = None,
        tier: Optional[Union[str, "_models.AccessTierOptional"]] = None,
        rehydrate_priority: Optional[Union[str, "_models.RehydratePriority"]] = None,
        request_id_parameter: Optional[str] = None,
        blob_tags_string: Optional[str] = None,
        seal_blob: Optional[bool] = None,
        source_modified_access_conditions: Optional["_models.SourceModifiedAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Start Copy From URL operation copies a blob or an internet resource to a new blob.

        :param copy_source: Specifies the name of the source page blob snapshot. This value is a URL of
         up to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
         would appear in a request URI. The source blob must either be public or must be authenticated
         via a shared access signature.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information.
        :type metadata: str
        :param tier: Optional. Indicates the tier to be set on the blob.
        :type tier: str or ~azure.storage.blob.models.AccessTierOptional
        :param rehydrate_priority: Optional: Indicates the priority with which to rehydrate an archived
         blob.
        :type rehydrate_priority: str or ~azure.storage.blob.models.RehydratePriority
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param blob_tags_string: Optional.  Used to set blob tags in various blob operations.
        :type blob_tags_string: str
        :param seal_blob: Overrides the sealed state of the destination blob.  Service version
         2019-12-12 and newer.
        :type seal_blob: bool
        :param source_modified_access_conditions: Parameter group.
        :type source_modified_access_conditions: ~azure.storage.blob.models.SourceModifiedAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        _source_if_tags = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
            _source_if_tags = source_modified_access_conditions.source_if_tags
        accept = "application/xml"

        # Construct URL
        url = self.start_copy_from_url.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        if tier is not None:
            header_parameters['x-ms-access-tier'] = self._serialize.header("tier", tier, 'str')
        if rehydrate_priority is not None:
            header_parameters['x-ms-rehydrate-priority'] = self._serialize.header("rehydrate_priority", rehydrate_priority, 'str')
        if _source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", _source_if_modified_since, 'rfc-1123')
        if _source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", _source_if_unmodified_since, 'rfc-1123')
        if _source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", _source_if_match, 'str')
        if _source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", _source_if_none_match, 'str')
        if _source_if_tags is not None:
            header_parameters['x-ms-source-if-tags'] = self._serialize.header("source_if_tags", _source_if_tags, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-copy-source'] = self._serialize.header("copy_source", copy_source, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        if blob_tags_string is not None:
            header_parameters['x-ms-tags'] = self._serialize.header("blob_tags_string", blob_tags_string, 'str')
        if seal_blob is not None:
            header_parameters['x-ms-seal-blob'] = self._serialize.header("seal_blob", seal_blob, 'bool')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    start_copy_from_url.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def copy_from_url(
        self,
        copy_source: str,
        timeout: Optional[int] = None,
        metadata: Optional[str] = None,
        tier: Optional[Union[str, "_models.AccessTierOptional"]] = None,
        request_id_parameter: Optional[str] = None,
        source_content_md5: Optional[bytearray] = None,
        blob_tags_string: Optional[str] = None,
        source_modified_access_conditions: Optional["_models.SourceModifiedAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Copy From URL operation copies a blob or an internet resource to a new blob. It will not
        return a response until the copy is complete.

        :param copy_source: Specifies the name of the source page blob snapshot. This value is a URL of
         up to 2 KB in length that specifies a page blob snapshot. The value should be URL-encoded as it
         would appear in a request URI. The source blob must either be public or must be authenticated
         via a shared access signature.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param metadata: Optional. Specifies a user-defined name-value pair associated with the blob.
         If no name-value pairs are specified, the operation will copy the metadata from the source blob
         or file to the destination blob. If one or more name-value pairs are specified, the destination
         blob is created with the specified metadata, and metadata is not copied from the source blob or
         file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
         rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more
         information.
        :type metadata: str
        :param tier: Optional. Indicates the tier to be set on the blob.
        :type tier: str or ~azure.storage.blob.models.AccessTierOptional
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param source_content_md5: Specify the md5 calculated for the range of bytes that must be read
         from the copy source.
        :type source_content_md5: bytearray
        :param blob_tags_string: Optional.  Used to set blob tags in various blob operations.
        :type blob_tags_string: str
        :param source_modified_access_conditions: Parameter group.
        :type source_modified_access_conditions: ~azure.storage.blob.models.SourceModifiedAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _source_if_modified_since = None
        _source_if_unmodified_since = None
        _source_if_match = None
        _source_if_none_match = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        if source_modified_access_conditions is not None:
            _source_if_modified_since = source_modified_access_conditions.source_if_modified_since
            _source_if_unmodified_since = source_modified_access_conditions.source_if_unmodified_since
            _source_if_match = source_modified_access_conditions.source_if_match
            _source_if_none_match = source_modified_access_conditions.source_if_none_match
        x_ms_requires_sync = "true"
        accept = "application/xml"

        # Construct URL
        url = self.copy_from_url.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-requires-sync'] = self._serialize.header("x_ms_requires_sync", x_ms_requires_sync, 'str')
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        if tier is not None:
            header_parameters['x-ms-access-tier'] = self._serialize.header("tier", tier, 'str')
        if _source_if_modified_since is not None:
            header_parameters['x-ms-source-if-modified-since'] = self._serialize.header("source_if_modified_since", _source_if_modified_since, 'rfc-1123')
        if _source_if_unmodified_since is not None:
            header_parameters['x-ms-source-if-unmodified-since'] = self._serialize.header("source_if_unmodified_since", _source_if_unmodified_since, 'rfc-1123')
        if _source_if_match is not None:
            header_parameters['x-ms-source-if-match'] = self._serialize.header("source_if_match", _source_if_match, 'str')
        if _source_if_none_match is not None:
            header_parameters['x-ms-source-if-none-match'] = self._serialize.header("source_if_none_match", _source_if_none_match, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-copy-source'] = self._serialize.header("copy_source", copy_source, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        if source_content_md5 is not None:
            header_parameters['x-ms-source-content-md5'] = self._serialize.header("source_content_md5", source_content_md5, 'bytearray')
        if blob_tags_string is not None:
            header_parameters['x-ms-tags'] = self._serialize.header("blob_tags_string", blob_tags_string, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['x-ms-version-id']=self._deserialize('str', response.headers.get('x-ms-version-id'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
        response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
        response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
        response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    copy_from_url.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def abort_copy_from_url(
        self,
        copy_id: str,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Abort Copy From URL operation aborts a pending Copy From URL operation, and leaves a
        destination blob with zero length and full metadata.

        :param copy_id: The copy identifier provided in the x-ms-copy-id header of the original Copy
         Blob operation.
        :type copy_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        comp = "copy"
        copy_action_abort_constant = "abort"
        accept = "application/xml"

        # Construct URL
        url = self.abort_copy_from_url.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        query_parameters['copyid'] = self._serialize.query("copy_id", copy_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-copy-action'] = self._serialize.header("copy_action_abort_constant", copy_action_abort_constant, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    abort_copy_from_url.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_tier(
        self,
        tier: Union[str, "_models.AccessTierRequired"],
        snapshot: Optional[str] = None,
        version_id: Optional[str] = None,
        timeout: Optional[int] = None,
        rehydrate_priority: Optional[Union[str, "_models.RehydratePriority"]] = None,
        request_id_parameter: Optional[str] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Set Tier operation sets the tier on a blob. The operation is allowed on a page blob in a
        premium storage account and on a block blob in a blob storage account (locally redundant
        storage only). A premium page blob's tier determines the allowed size, IOPS, and bandwidth of
        the blob. A block blob's tier determines Hot/Cool/Archive storage type. This operation does not
        update the blob's ETag.

        :param tier: Indicates the tier to be set on the blob.
        :type tier: str or ~azure.storage.blob.models.AccessTierRequired
        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param rehydrate_priority: Optional: Indicates the priority with which to rehydrate an archived
         blob.
        :type rehydrate_priority: str or ~azure.storage.blob.models.RehydratePriority
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _if_tags = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_tags = modified_access_conditions.if_tags
        comp = "tier"
        accept = "application/xml"

        # Construct URL
        url = self.set_tier.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-access-tier'] = self._serialize.header("tier", tier, 'str')
        if rehydrate_priority is not None:
            header_parameters['x-ms-rehydrate-priority'] = self._serialize.header("rehydrate_priority", rehydrate_priority, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if response.status_code == 202:
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_tier.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def get_account_info(
        self,
        **kwargs
    ) -> None:
        """Returns the sku name and account kind.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        restype = "account"
        comp = "properties"
        accept = "application/xml"

        # Construct URL
        url = self.get_account_info.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['restype'] = self._serialize.query("restype", restype, 'str')
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        response_headers['x-ms-sku-name']=self._deserialize('str', response.headers.get('x-ms-sku-name'))
        response_headers['x-ms-account-kind']=self._deserialize('str', response.headers.get('x-ms-account-kind'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    get_account_info.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def query(
        self,
        snapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        encryption_algorithm: Optional[str] = "AES256",
        request_id_parameter: Optional[str] = None,
        query_request: Optional["_models.QueryRequest"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        cpk_info: Optional["_models.CpkInfo"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        **kwargs
    ) -> IO:
        """The Query operation enables users to select/project on blob data by providing simple query
        expressions.

        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
         the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
         provided.
        :type encryption_algorithm: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param query_request: the query request.
        :type query_request: ~azure.storage.blob.models.QueryRequest
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :param cpk_info: Parameter group.
        :type cpk_info: ~azure.storage.blob.models.CpkInfo
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IO, or the result of cls(response)
        :rtype: IO
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[IO]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _lease_id = None
        _encryption_key = None
        _encryption_key_sha256 = None
        _if_modified_since = None
        _if_unmodified_since = None
        _if_match = None
        _if_none_match = None
        _if_tags = None
        if cpk_info is not None:
            _encryption_key = cpk_info.encryption_key
            _encryption_key_sha256 = cpk_info.encryption_key_sha256
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_modified_since = modified_access_conditions.if_modified_since
            _if_unmodified_since = modified_access_conditions.if_unmodified_since
            _if_match = modified_access_conditions.if_match
            _if_none_match = modified_access_conditions.if_none_match
            _if_tags = modified_access_conditions.if_tags
        comp = "query"
        content_type = kwargs.pop("content_type", "application/xml")
        accept = "application/xml"

        # Construct URL
        url = self.query.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        if _encryption_key is not None:
            header_parameters['x-ms-encryption-key'] = self._serialize.header("encryption_key", _encryption_key, 'str')
        if _encryption_key_sha256 is not None:
            header_parameters['x-ms-encryption-key-sha256'] = self._serialize.header("encryption_key_sha256", _encryption_key_sha256, 'str')
        if encryption_algorithm is not None:
            header_parameters['x-ms-encryption-algorithm'] = self._serialize.header("encryption_algorithm", encryption_algorithm, 'str')
        if _if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", _if_modified_since, 'rfc-1123')
        if _if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", _if_unmodified_since, 'rfc-1123')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        if _if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", _if_none_match, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if query_request is not None:
            body_content = self._serialize.body(query_request, 'QueryRequest', is_xml=True)
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 200:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('str', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
            response_headers['x-ms-blob-type']=self._deserialize('str', response.headers.get('x-ms-blob-type'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-blob-committed-block-count']=self._deserialize('int', response.headers.get('x-ms-blob-committed-block-count'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
            response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))
            response_headers['x-ms-blob-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-blob-content-md5'))
            deserialized = response.stream_download(self._client._pipeline)

        if response.status_code == 206:
            response_headers['Last-Modified']=self._deserialize('rfc-1123', response.headers.get('Last-Modified'))
            response_headers['x-ms-meta']=self._deserialize('str', response.headers.get('x-ms-meta'))
            response_headers['Content-Length']=self._deserialize('long', response.headers.get('Content-Length'))
            response_headers['Content-Type']=self._deserialize('str', response.headers.get('Content-Type'))
            response_headers['Content-Range']=self._deserialize('str', response.headers.get('Content-Range'))
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            response_headers['Content-MD5']=self._deserialize('bytearray', response.headers.get('Content-MD5'))
            response_headers['Content-Encoding']=self._deserialize('str', response.headers.get('Content-Encoding'))
            response_headers['Cache-Control']=self._deserialize('str', response.headers.get('Cache-Control'))
            response_headers['Content-Disposition']=self._deserialize('str', response.headers.get('Content-Disposition'))
            response_headers['Content-Language']=self._deserialize('str', response.headers.get('Content-Language'))
            response_headers['x-ms-blob-sequence-number']=self._deserialize('long', response.headers.get('x-ms-blob-sequence-number'))
            response_headers['x-ms-blob-type']=self._deserialize('str', response.headers.get('x-ms-blob-type'))
            response_headers['x-ms-content-crc64']=self._deserialize('bytearray', response.headers.get('x-ms-content-crc64'))
            response_headers['x-ms-copy-completion-time']=self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time'))
            response_headers['x-ms-copy-status-description']=self._deserialize('str', response.headers.get('x-ms-copy-status-description'))
            response_headers['x-ms-copy-id']=self._deserialize('str', response.headers.get('x-ms-copy-id'))
            response_headers['x-ms-copy-progress']=self._deserialize('str', response.headers.get('x-ms-copy-progress'))
            response_headers['x-ms-copy-source']=self._deserialize('str', response.headers.get('x-ms-copy-source'))
            response_headers['x-ms-copy-status']=self._deserialize('str', response.headers.get('x-ms-copy-status'))
            response_headers['x-ms-lease-duration']=self._deserialize('str', response.headers.get('x-ms-lease-duration'))
            response_headers['x-ms-lease-state']=self._deserialize('str', response.headers.get('x-ms-lease-state'))
            response_headers['x-ms-lease-status']=self._deserialize('str', response.headers.get('x-ms-lease-status'))
            response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
            response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
            response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
            response_headers['Accept-Ranges']=self._deserialize('str', response.headers.get('Accept-Ranges'))
            response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
            response_headers['x-ms-blob-committed-block-count']=self._deserialize('int', response.headers.get('x-ms-blob-committed-block-count'))
            response_headers['x-ms-server-encrypted']=self._deserialize('bool', response.headers.get('x-ms-server-encrypted'))
            response_headers['x-ms-encryption-key-sha256']=self._deserialize('str', response.headers.get('x-ms-encryption-key-sha256'))
            response_headers['x-ms-encryption-scope']=self._deserialize('str', response.headers.get('x-ms-encryption-scope'))
            response_headers['x-ms-blob-content-md5']=self._deserialize('bytearray', response.headers.get('x-ms-blob-content-md5'))
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    query.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def get_tags(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        snapshot: Optional[str] = None,
        version_id: Optional[str] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> "_models.BlobTags":
        """The Get Tags operation enables users to get the tags associated with a blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param snapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the blob snapshot to retrieve. For more information on working with blob snapshots,
         see :code:`<a href="https://docs.microsoft.com/en-
         us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot of
         a Blob.</a>`.
        :type snapshot: str
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BlobTags, or the result of cls(response)
        :rtype: ~azure.storage.blob.models.BlobTags
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.BlobTags"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_tags = None
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_tags = modified_access_conditions.if_tags
        comp = "tags"
        accept = "application/xml"

        # Construct URL
        url = self.get_tags.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if snapshot is not None:
            query_parameters['snapshot'] = self._serialize.query("snapshot", snapshot, 'str')
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))
        deserialized = self._deserialize('BlobTags', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_tags.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore

    async def set_tags(
        self,
        timeout: Optional[int] = None,
        version_id: Optional[str] = None,
        transactional_content_md5: Optional[bytearray] = None,
        transactional_content_crc64: Optional[bytearray] = None,
        request_id_parameter: Optional[str] = None,
        tags: Optional["_models.BlobTags"] = None,
        modified_access_conditions: Optional["_models.ModifiedAccessConditions"] = None,
        lease_access_conditions: Optional["_models.LeaseAccessConditions"] = None,
        **kwargs
    ) -> None:
        """The Set Tags operation enables users to set tags on a blob.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-
         timeouts-for-blob-service-operations">Setting Timeouts for Blob Service Operations.</a>`.
        :type timeout: int
        :param version_id: The version id parameter is an opaque DateTime value that, when present,
         specifies the version of the blob to operate on. It's for service version 2019-10-10 and newer.
        :type version_id: str
        :param transactional_content_md5: Specify the transactional md5 for the body, to be validated
         by the service.
        :type transactional_content_md5: bytearray
        :param transactional_content_crc64: Specify the transactional crc64 for the body, to be
         validated by the service.
        :type transactional_content_crc64: bytearray
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled.
        :type request_id_parameter: str
        :param tags: Blob tags.
        :type tags: ~azure.storage.blob.models.BlobTags
        :param modified_access_conditions: Parameter group.
        :type modified_access_conditions: ~azure.storage.blob.models.ModifiedAccessConditions
        :param lease_access_conditions: Parameter group.
        :type lease_access_conditions: ~azure.storage.blob.models.LeaseAccessConditions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        
        _if_tags = None
        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        if modified_access_conditions is not None:
            _if_tags = modified_access_conditions.if_tags
        comp = "tags"
        content_type = kwargs.pop("content_type", "application/xml")
        accept = "application/xml"

        # Construct URL
        url = self.set_tags.metadata['url']  # type: ignore
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if version_id is not None:
            query_parameters['versionid'] = self._serialize.query("version_id", version_id, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if transactional_content_md5 is not None:
            header_parameters['Content-MD5'] = self._serialize.header("transactional_content_md5", transactional_content_md5, 'bytearray')
        if transactional_content_crc64 is not None:
            header_parameters['x-ms-content-crc64'] = self._serialize.header("transactional_content_crc64", transactional_content_crc64, 'bytearray')
        if request_id_parameter is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id_parameter", request_id_parameter, 'str')
        if _if_tags is not None:
            header_parameters['x-ms-if-tags'] = self._serialize.header("if_tags", _if_tags, 'str')
        if _lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", _lease_id, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        if tags is not None:
            body_content = self._serialize.body(tags, 'BlobTags', is_xml=True)
        else:
            body_content = None
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(_models.StorageError, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['x-ms-client-request-id']=self._deserialize('str', response.headers.get('x-ms-client-request-id'))
        response_headers['x-ms-request-id']=self._deserialize('str', response.headers.get('x-ms-request-id'))
        response_headers['x-ms-version']=self._deserialize('str', response.headers.get('x-ms-version'))
        response_headers['Date']=self._deserialize('rfc-1123', response.headers.get('Date'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    set_tags.metadata = {'url': '/{containerName}/{blob}'}  # type: ignore
