# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Action(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action of virtual network rule."""

    ALLOW = "Allow"


class ActionsRequired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A message indicating if changes on the service provider require any updates on the consumer."""

    NONE = "None"
    RECREATE = "Recreate"


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private link service connection status."""

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DefaultAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The default action of allow or deny when no other rules match."""

    ALLOW = "Allow"
    DENY = "Deny"


class EncryptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether or not the encryption is enabled for container registry."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class ImportMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """When Force, any existing target tags will be overwritten. When NoForce, any existing target
    tags will fail the operation before any copying begins.
    """

    NO_FORCE = "NoForce"
    FORCE = "Force"


class LastModifiedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that last modified the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class NetworkRuleBypassOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether to allow trusted Azure services to access a network restricted registry."""

    AZURE_SERVICES = "AzureServices"
    NONE = "None"


class PasswordName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The password name."""

    PASSWORD = "password"
    PASSWORD2 = "password2"


class PipelineOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PipelineOptions."""

    OVERWRITE_TAGS = "OverwriteTags"
    OVERWRITE_BLOBS = "OverwriteBlobs"
    DELETE_SOURCE_BLOB_ON_SUCCESS = "DeleteSourceBlobOnSuccess"
    CONTINUE_ON_ERRORS = "ContinueOnErrors"


class PipelineRunSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the source."""

    AZURE_STORAGE_BLOB = "AzureStorageBlob"


class PipelineRunTargetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the target."""

    AZURE_STORAGE_BLOB = "AzureStorageBlob"


class PipelineSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of source for the import pipeline."""

    AZURE_STORAGE_BLOB_CONTAINER = "AzureStorageBlobContainer"


class PolicyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The value that indicates whether the policy is enabled or not."""

    ENABLED = "enabled"
    DISABLED = "disabled"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the pipeline at the time the operation was called."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether or not public network access is allowed for the container registry."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class RegistryUsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit of measurement."""

    COUNT = "Count"
    BYTES = "Bytes"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU name of the container registry. Required for registry creation."""

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU tier based on the SKU name."""

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"


class TriggerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the source trigger."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class TrustPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of trust policy."""

    NOTARY = "Notary"


class WebhookAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """WebhookAction."""

    PUSH = "push"
    DELETE = "delete"
    QUARANTINE = "quarantine"
    CHART_PUSH = "chart_push"
    CHART_DELETE = "chart_delete"


class WebhookStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the webhook at the time the operation was called."""

    ENABLED = "enabled"
    DISABLED = "disabled"
