# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the action to take on rule match.
    """

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"

class AggregationInterval(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The aggregation interval of the Timeseries
    """

    HOURLY = "Hourly"
    DAILY = "Daily"

class Availability(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether the name is available.
    """

    AVAILABLE = "Available"
    UNAVAILABLE = "Unavailable"

class BackendEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class CustomHttpsProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status of Custom Https of the frontendEndpoint.
    """

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    FAILED = "Failed"

class CustomHttpsProvisioningSubstate(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step.
    """

    SUBMITTING_DOMAIN_CONTROL_VALIDATION_REQUEST = "SubmittingDomainControlValidationRequest"
    PENDING_DOMAIN_CONTROL_VALIDATION_R_EQUEST_APPROVAL = "PendingDomainControlValidationREquestApproval"
    DOMAIN_CONTROL_VALIDATION_REQUEST_APPROVED = "DomainControlValidationRequestApproved"
    DOMAIN_CONTROL_VALIDATION_REQUEST_REJECTED = "DomainControlValidationRequestRejected"
    DOMAIN_CONTROL_VALIDATION_REQUEST_TIMED_OUT = "DomainControlValidationRequestTimedOut"
    ISSUING_CERTIFICATE = "IssuingCertificate"
    DEPLOYING_CERTIFICATE = "DeployingCertificate"
    CERTIFICATE_DEPLOYED = "CertificateDeployed"
    DELETING_CERTIFICATE = "DeletingCertificate"
    CERTIFICATE_DELETED = "CertificateDeleted"

class CustomRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DynamicCompressionEnabled(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to use dynamic compression for cached content
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of endpoint
    """

    AFD = "AFD"
    AZURE_REGION = "AzureRegion"
    CDN = "CDN"
    ATM = "ATM"

class EnforceCertificateNameCheckEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on
    non-HTTPS requests.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class FrontDoorCertificateSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate
    """

    AZURE_KEY_VAULT = "AzureKeyVault"
    FRONT_DOOR = "FrontDoor"

class FrontDoorCertificateType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the type of the certificate used for secure connections to a frontendEndpoint
    """

    DEDICATED = "Dedicated"

class FrontDoorEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operational status of the Front Door load balancer. Permitted values are 'Enabled' or
    'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class FrontDoorForwardingProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol this rule will use when forwarding traffic to backends.
    """

    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"

class FrontDoorHealthProbeMethod(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Configures which HTTP method to use to probe the backends defined under backendPools.
    """

    GET = "GET"
    HEAD = "HEAD"

class FrontDoorProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Accepted protocol schemes.
    """

    HTTP = "Http"
    HTTPS = "Https"

class FrontDoorQuery(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Treatment of URL query terms when forming the cache key.
    """

    STRIP_NONE = "StripNone"
    STRIP_ALL = "StripAll"
    STRIP_ONLY = "StripOnly"
    STRIP_ALL_EXCEPT = "StripAllExcept"

class FrontDoorRedirectProtocol(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The protocol of the destination to where the traffic is redirected
    """

    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"

class FrontDoorRedirectType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The redirect type the rule will use when redirecting traffic.
    """

    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"

class FrontDoorResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the Front Door or Front Door SubResource.
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class FrontDoorTlsProtocolType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the TLS extension protocol that is used for secure delivery
    """

    SERVER_NAME_INDICATION = "ServerNameIndication"

class HeaderActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Which type of manipulation to apply to the header.
    """

    APPEND = "Append"
    DELETE = "Delete"
    OVERWRITE = "Overwrite"

class HealthProbeEnabled(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enable health probes to be made against backends defined under backendPools. Health
    probes can only be disabled if there is a single enabled backend in single enabled backend
    pool.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class LatencyScorecardAggregationInterval(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"

class ManagedRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the managed rule is in enabled or disabled state.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class ManagedRuleExclusionMatchVariable(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The variable type to be excluded.
    """

    REQUEST_HEADER_NAMES = "RequestHeaderNames"
    REQUEST_COOKIE_NAMES = "RequestCookieNames"
    QUERY_STRING_ARG_NAMES = "QueryStringArgNames"
    REQUEST_BODY_POST_ARG_NAMES = "RequestBodyPostArgNames"
    REQUEST_BODY_JSON_ARG_NAMES = "RequestBodyJsonArgNames"

class ManagedRuleExclusionSelectorMatchOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Comparison operator to apply to the selector when specifying which elements in the collection
    this exclusion applies to.
    """

    EQUALS = "Equals"
    CONTAINS = "Contains"
    STARTS_WITH = "StartsWith"
    ENDS_WITH = "EndsWith"
    EQUALS_ANY = "EqualsAny"

class ManagedRuleSetActionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the action to take when a managed rule set score threshold is met.
    """

    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"

class MatchProcessingBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """If this rule is a match should the rules engine continue running the remaining rules or stop.
    If not present, defaults to Continue.
    """

    CONTINUE_ENUM = "Continue"
    STOP = "Stop"

class MatchVariable(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Request variable to compare with.
    """

    REMOTE_ADDR = "RemoteAddr"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    COOKIES = "Cookies"
    SOCKET_ADDR = "SocketAddr"

class MinimumTLSVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The minimum TLS version required from the clients to establish an SSL handshake with Front
    Door.
    """

    ONE0 = "1.0"
    ONE2 = "1.2"

class NetworkExperimentResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the server side resource status
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class NetworkOperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and
    'Failed'.
    """

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class Operator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Comparison type to use for matching with the variable value.
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"

class PolicyEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class PolicyMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if it is in detection mode or prevention mode at policy level.
    """

    PREVENTION = "Prevention"
    DETECTION = "Detection"

class PolicyRequestBodyCheck(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if policy managed rules will inspect the request body content.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class PolicyResourceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the policy.
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class PrivateEndpointStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The Approval status for the connection to the Private Link
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class ResourceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of Front Door resource used in CheckNameAvailability.
    """

    MICROSOFT_NETWORK_FRONT_DOORS = "Microsoft.Network/frontDoors"
    MICROSOFT_NETWORK_FRONT_DOORS_FRONTEND_ENDPOINTS = "Microsoft.Network/frontDoors/frontendEndpoints"

class RoutingRuleEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RulesEngineMatchVariable(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Match Variable
    """

    IS_MOBILE = "IsMobile"
    REMOTE_ADDR = "RemoteAddr"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_PATH = "RequestPath"
    REQUEST_FILENAME = "RequestFilename"
    REQUEST_FILENAME_EXTENSION = "RequestFilenameExtension"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"

class RulesEngineOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to apply to the match condition.
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"

class RuleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes type of rule.
    """

    MATCH_RULE = "MatchRule"
    RATE_LIMIT_RULE = "RateLimitRule"

class SessionAffinityEnabledState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the pricing tier.
    """

    CLASSIC_AZURE_FRONT_DOOR = "Classic_AzureFrontDoor"
    STANDARD_AZURE_FRONT_DOOR = "Standard_AzureFrontDoor"
    PREMIUM_AZURE_FRONT_DOOR = "Premium_AzureFrontDoor"

class State(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the Experiment
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class TimeseriesAggregationInterval(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    HOURLY = "Hourly"
    DAILY = "Daily"

class TimeseriesType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of Timeseries
    """

    MEASUREMENT_COUNTS = "MeasurementCounts"
    LATENCY_P50 = "LatencyP50"
    LATENCY_P75 = "LatencyP75"
    LATENCY_P95 = "LatencyP95"

class Transform(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms are applied before matching
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"

class TransformType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms applied before matching.
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"
