# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AbsoluteMarker(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALL_BACKUP = "AllBackup"
    FIRST_OF_DAY = "FirstOfDay"
    FIRST_OF_MONTH = "FirstOfMonth"
    FIRST_OF_WEEK = "FirstOfWeek"
    FIRST_OF_YEAR = "FirstOfYear"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class CurrentProtectionState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the current protection state of the resource
    """

    INVALID = "Invalid"
    NOT_PROTECTED = "NotProtected"
    CONFIGURING_PROTECTION = "ConfiguringProtection"
    PROTECTION_CONFIGURED = "ProtectionConfigured"
    BACKUP_SCHEDULES_SUSPENDED = "BackupSchedulesSuspended"
    RETENTION_SCHEDULES_SUSPENDED = "RetentionSchedulesSuspended"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_ERROR = "ProtectionError"
    CONFIGURING_PROTECTION_FAILED = "ConfiguringProtectionFailed"
    SOFT_DELETING = "SoftDeleting"
    SOFT_DELETED = "SoftDeleted"
    UPDATING_PROTECTION = "UpdatingProtection"

class DataStoreTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """type of datastore; Operational/Vault/Archive
    """

    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"
    ARCHIVE_STORE = "ArchiveStore"

class DayOfWeek(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    FRIDAY = "Friday"
    MONDAY = "Monday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"
    THURSDAY = "Thursday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"

class FeatureSupportStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """feature support status
    """

    INVALID = "Invalid"
    NOT_SUPPORTED = "NotSupported"
    ALPHA_PREVIEW = "AlphaPreview"
    PRIVATE_PREVIEW = "PrivatePreview"
    PUBLIC_PREVIEW = "PublicPreview"
    GENERALLY_AVAILABLE = "GenerallyAvailable"

class FeatureType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """backup support feature type.
    """

    INVALID = "Invalid"
    DATA_SOURCE_TYPE = "DataSourceType"

class Month(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    APRIL = "April"
    AUGUST = "August"
    DECEMBER = "December"
    FEBRUARY = "February"
    JANUARY = "January"
    JULY = "July"
    JUNE = "June"
    MARCH = "March"
    MAY = "May"
    NOVEMBER = "November"
    OCTOBER = "October"
    SEPTEMBER = "September"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the BackupVault resource
    """

    FAILED = "Failed"
    PROVISIONING = "Provisioning"
    SUCCEEDED = "Succeeded"
    UNKNOWN = "Unknown"
    UPDATING = "Updating"

class RecoveryOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Recovery Option
    """

    FAIL_IF_EXISTS = "FailIfExists"

class RehydrationPriority(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Priority to be used for rehydration. Values High or Standard
    """

    INVALID = "Invalid"
    HIGH = "High"
    STANDARD = "Standard"

class RehydrationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CREATE_IN_PROGRESS = "CREATE_IN_PROGRESS"
    COMPLETED = "COMPLETED"
    DELETE_IN_PROGRESS = "DELETE_IN_PROGRESS"
    DELETED = "DELETED"
    FAILED = "FAILED"

class ResourceMoveState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource move state for backup vault
    """

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    PREPARE_FAILED = "PrepareFailed"
    COMMIT_FAILED = "CommitFailed"
    FAILED = "Failed"
    PREPARE_TIMEDOUT = "PrepareTimedout"
    COMMIT_TIMEDOUT = "CommitTimedout"
    CRITICAL_FAILURE = "CriticalFailure"
    PARTIAL_SUCCESS = "PartialSuccess"
    MOVE_SUCCEEDED = "MoveSucceeded"

class RestoreSourceDataStoreType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type of the source data store.
    """

    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"
    ARCHIVE_STORE = "ArchiveStore"

class RestoreTargetLocationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Denotes the target location where the data will be restored,
    string value for the enum
    {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}
    """

    INVALID = "Invalid"
    AZURE_BLOBS = "AzureBlobs"
    AZURE_FILES = "AzureFiles"

class SecretStoreType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type of secret store
    """

    INVALID = "Invalid"
    AZURE_KEY_VAULT = "AzureKeyVault"

class SourceDataStoreType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type of the source data store.
    """

    ARCHIVE_STORE = "ArchiveStore"
    SNAPSHOT_STORE = "SnapshotStore"
    VAULT_STORE = "VaultStore"

class Status(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the protection status of the resource
    """

    CONFIGURING_PROTECTION = "ConfiguringProtection"
    CONFIGURING_PROTECTION_FAILED = "ConfiguringProtectionFailed"
    PROTECTION_CONFIGURED = "ProtectionConfigured"
    PROTECTION_STOPPED = "ProtectionStopped"
    SOFT_DELETED = "SoftDeleted"
    SOFT_DELETING = "SoftDeleting"

class StorageSettingStoreTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type of the datastore.
    """

    ARCHIVE_STORE = "ArchiveStore"
    SNAPSHOT_STORE = "SnapshotStore"
    VAULT_STORE = "VaultStore"

class StorageSettingTypes(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the type.
    """

    GEO_REDUNDANT = "GeoRedundant"
    LOCALLY_REDUNDANT = "LocallyRedundant"

class WeekNumber(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    FIRST = "First"
    FOURTH = "Fourth"
    LAST = "Last"
    SECOND = "Second"
    THIRD = "Third"
