# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class LabFragment(Resource):
    """Represents a lab.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param max_users_in_lab: Maximum number of users allowed in the lab.
    :type max_users_in_lab: int
    :param usage_quota: Maximum duration a user can use an environment for in
     the lab.
    :type usage_quota: timedelta
    :param user_access_mode: Lab user access mode (open to all vs. restricted
     to those listed on the lab). Possible values include: 'Restricted', 'Open'
    :type user_access_mode: str or
     ~azure.mgmt.labservices.models.LabUserAccessMode
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_users_in_lab': {'key': 'properties.maxUsersInLab', 'type': 'int'},
        'usage_quota': {'key': 'properties.usageQuota', 'type': 'duration'},
        'user_access_mode': {'key': 'properties.userAccessMode', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, max_users_in_lab: int=None, usage_quota=None, user_access_mode=None, provisioning_state: str=None, unique_identifier: str=None, **kwargs) -> None:
        super(LabFragment, self).__init__(location=location, tags=tags, **kwargs)
        self.max_users_in_lab = max_users_in_lab
        self.usage_quota = usage_quota
        self.user_access_mode = user_access_mode
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
