# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdditionalFeaturesServerConfigurations(Model):
    """Additional SQL Server feature settings.

    :param is_rservices_enabled: Enable or disable R services (SQL 2016
     onwards).
    :type is_rservices_enabled: bool
    """

    _attribute_map = {
        'is_rservices_enabled': {'key': 'isRServicesEnabled', 'type': 'bool'},
    }

    def __init__(self, *, is_rservices_enabled: bool=None, **kwargs) -> None:
        super(AdditionalFeaturesServerConfigurations, self).__init__(**kwargs)
        self.is_rservices_enabled = is_rservices_enabled


class AutoBackupSettings(Model):
    """Configure backups for databases in your SQL virtual machine.

    :param enable: Enable or disable autobackup on SQL virtual machine.
    :type enable: bool
    :param enable_encryption: Enable or disable encryption for backup on SQL
     virtual machine.
    :type enable_encryption: bool
    :param retention_period: Retention period of backup: 1-30 days.
    :type retention_period: int
    :param storage_account_url: Storage account url where backup will be taken
     to.
    :type storage_account_url: str
    :param storage_access_key: Storage account key where backup will be taken
     to.
    :type storage_access_key: str
    :param password: Password for encryption on backup.
    :type password: str
    :param backup_system_dbs: Include or exclude system databases from auto
     backup.
    :type backup_system_dbs: bool
    :param backup_schedule_type: Backup schedule type. Possible values
     include: 'Manual', 'Automated'
    :type backup_schedule_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.BackupScheduleType
    :param full_backup_frequency: Frequency of full backups. In both cases,
     full backups begin during the next scheduled time window. Possible values
     include: 'Daily', 'Weekly'
    :type full_backup_frequency: str or
     ~azure.mgmt.sqlvirtualmachine.models.FullBackupFrequencyType
    :param full_backup_start_time: Start time of a given day during which full
     backups can take place. 0-23 hours.
    :type full_backup_start_time: int
    :param full_backup_window_hours: Duration of the time window of a given
     day during which full backups can take place. 1-23 hours.
    :type full_backup_window_hours: int
    :param log_backup_frequency: Frequency of log backups. 5-60 minutes.
    :type log_backup_frequency: int
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'enable_encryption': {'key': 'enableEncryption', 'type': 'bool'},
        'retention_period': {'key': 'retentionPeriod', 'type': 'int'},
        'storage_account_url': {'key': 'storageAccountUrl', 'type': 'str'},
        'storage_access_key': {'key': 'storageAccessKey', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'backup_system_dbs': {'key': 'backupSystemDbs', 'type': 'bool'},
        'backup_schedule_type': {'key': 'backupScheduleType', 'type': 'str'},
        'full_backup_frequency': {'key': 'fullBackupFrequency', 'type': 'str'},
        'full_backup_start_time': {'key': 'fullBackupStartTime', 'type': 'int'},
        'full_backup_window_hours': {'key': 'fullBackupWindowHours', 'type': 'int'},
        'log_backup_frequency': {'key': 'logBackupFrequency', 'type': 'int'},
    }

    def __init__(self, *, enable: bool=None, enable_encryption: bool=None, retention_period: int=None, storage_account_url: str=None, storage_access_key: str=None, password: str=None, backup_system_dbs: bool=None, backup_schedule_type=None, full_backup_frequency=None, full_backup_start_time: int=None, full_backup_window_hours: int=None, log_backup_frequency: int=None, **kwargs) -> None:
        super(AutoBackupSettings, self).__init__(**kwargs)
        self.enable = enable
        self.enable_encryption = enable_encryption
        self.retention_period = retention_period
        self.storage_account_url = storage_account_url
        self.storage_access_key = storage_access_key
        self.password = password
        self.backup_system_dbs = backup_system_dbs
        self.backup_schedule_type = backup_schedule_type
        self.full_backup_frequency = full_backup_frequency
        self.full_backup_start_time = full_backup_start_time
        self.full_backup_window_hours = full_backup_window_hours
        self.log_backup_frequency = log_backup_frequency


class AutoPatchingSettings(Model):
    """Set a patching window during which Windows and SQL patches will be applied.

    :param enable: Enable or disable autopatching on SQL virtual machine.
    :type enable: bool
    :param day_of_week: Day of week to apply the patch on. Possible values
     include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday',
     'Saturday', 'Sunday'
    :type day_of_week: str or ~azure.mgmt.sqlvirtualmachine.models.DayOfWeek
    :param maintenance_window_starting_hour: Hour of the day when patching is
     initiated. Local VM time.
    :type maintenance_window_starting_hour: int
    :param maintenance_window_duration: Duration of patching.
    :type maintenance_window_duration: int
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'DayOfWeek'},
        'maintenance_window_starting_hour': {'key': 'maintenanceWindowStartingHour', 'type': 'int'},
        'maintenance_window_duration': {'key': 'maintenanceWindowDuration', 'type': 'int'},
    }

    def __init__(self, *, enable: bool=None, day_of_week=None, maintenance_window_starting_hour: int=None, maintenance_window_duration: int=None, **kwargs) -> None:
        super(AutoPatchingSettings, self).__init__(**kwargs)
        self.enable = enable
        self.day_of_week = day_of_week
        self.maintenance_window_starting_hour = maintenance_window_starting_hour
        self.maintenance_window_duration = maintenance_window_duration


class Resource(Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class AvailabilityGroupListener(ProxyResource):
    """A SQL Server availability group listener.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state to track the async operation
     status.
    :vartype provisioning_state: str
    :param availability_group_name: Name of the availability group.
    :type availability_group_name: str
    :param load_balancer_configurations: List of load balancer configurations
     for an availability group listener.
    :type load_balancer_configurations:
     list[~azure.mgmt.sqlvirtualmachine.models.LoadBalancerConfiguration]
    :param create_default_availability_group_if_not_exist: Create a default
     availability group if it does not exist.
    :type create_default_availability_group_if_not_exist: bool
    :param port: Listener port.
    :type port: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'availability_group_name': {'key': 'properties.availabilityGroupName', 'type': 'str'},
        'load_balancer_configurations': {'key': 'properties.loadBalancerConfigurations', 'type': '[LoadBalancerConfiguration]'},
        'create_default_availability_group_if_not_exist': {'key': 'properties.createDefaultAvailabilityGroupIfNotExist', 'type': 'bool'},
        'port': {'key': 'properties.port', 'type': 'int'},
    }

    def __init__(self, *, availability_group_name: str=None, load_balancer_configurations=None, create_default_availability_group_if_not_exist: bool=None, port: int=None, **kwargs) -> None:
        super(AvailabilityGroupListener, self).__init__(**kwargs)
        self.provisioning_state = None
        self.availability_group_name = availability_group_name
        self.load_balancer_configurations = load_balancer_configurations
        self.create_default_availability_group_if_not_exist = create_default_availability_group_if_not_exist
        self.port = port


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class KeyVaultCredentialSettings(Model):
    """Configure your SQL virtual machine to be able to connect to the Azure Key
    Vault service.

    :param enable: Enable or disable key vault credential setting.
    :type enable: bool
    :param credential_name: Credential name.
    :type credential_name: str
    :param azure_key_vault_url: Azure Key Vault url.
    :type azure_key_vault_url: str
    :param service_principal_name: Service principal name to access key vault.
    :type service_principal_name: str
    :param service_principal_secret: Service principal name secret to access
     key vault.
    :type service_principal_secret: str
    """

    _attribute_map = {
        'enable': {'key': 'enable', 'type': 'bool'},
        'credential_name': {'key': 'credentialName', 'type': 'str'},
        'azure_key_vault_url': {'key': 'azureKeyVaultUrl', 'type': 'str'},
        'service_principal_name': {'key': 'servicePrincipalName', 'type': 'str'},
        'service_principal_secret': {'key': 'servicePrincipalSecret', 'type': 'str'},
    }

    def __init__(self, *, enable: bool=None, credential_name: str=None, azure_key_vault_url: str=None, service_principal_name: str=None, service_principal_secret: str=None, **kwargs) -> None:
        super(KeyVaultCredentialSettings, self).__init__(**kwargs)
        self.enable = enable
        self.credential_name = credential_name
        self.azure_key_vault_url = azure_key_vault_url
        self.service_principal_name = service_principal_name
        self.service_principal_secret = service_principal_secret


class LoadBalancerConfiguration(Model):
    """A load balancer configuration for an availability group listener.

    :param private_ip_address: Private IP address.
    :type private_ip_address:
     ~azure.mgmt.sqlvirtualmachine.models.PrivateIPAddress
    :param public_ip_address_resource_id: Resource id of the public IP.
    :type public_ip_address_resource_id: str
    :param load_balancer_resource_id: Resource id of the load balancer.
    :type load_balancer_resource_id: str
    :param probe_port: Probe port.
    :type probe_port: int
    :param sql_virtual_machine_instances: List of the SQL virtual machine
     instance resource id's that are enrolled into the availability group
     listener.
    :type sql_virtual_machine_instances: list[str]
    """

    _attribute_map = {
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'PrivateIPAddress'},
        'public_ip_address_resource_id': {'key': 'publicIpAddressResourceId', 'type': 'str'},
        'load_balancer_resource_id': {'key': 'loadBalancerResourceId', 'type': 'str'},
        'probe_port': {'key': 'probePort', 'type': 'int'},
        'sql_virtual_machine_instances': {'key': 'sqlVirtualMachineInstances', 'type': '[str]'},
    }

    def __init__(self, *, private_ip_address=None, public_ip_address_resource_id: str=None, load_balancer_resource_id: str=None, probe_port: int=None, sql_virtual_machine_instances=None, **kwargs) -> None:
        super(LoadBalancerConfiguration, self).__init__(**kwargs)
        self.private_ip_address = private_ip_address
        self.public_ip_address_resource_id = public_ip_address_resource_id
        self.load_balancer_resource_id = load_balancer_resource_id
        self.probe_port = probe_port
        self.sql_virtual_machine_instances = sql_virtual_machine_instances


class Operation(Model):
    """SQL REST API operation definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the operation being performed on this particular
     object.
    :vartype name: str
    :ivar display: The localized display information for this particular
     operation / action.
    :vartype display: ~azure.mgmt.sqlvirtualmachine.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values
     include: 'user', 'system'
    :vartype origin: str or
     ~azure.mgmt.sqlvirtualmachine.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, object]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(self, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related
     to this action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class PrivateIPAddress(Model):
    """A private IP address bound to the availability group listener.

    :param ip_address: Private IP address bound to the availability group
     listener.
    :type ip_address: str
    :param subnet_resource_id: Subnet used to include private IP.
    :type subnet_resource_id: str
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_resource_id': {'key': 'subnetResourceId', 'type': 'str'},
    }

    def __init__(self, *, ip_address: str=None, subnet_resource_id: str=None, **kwargs) -> None:
        super(PrivateIPAddress, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_resource_id = subnet_resource_id


class ResourceIdentity(Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to
     automatically create and assign an Azure Active Directory principal for
     the resource. Possible values include: 'SystemAssigned'
    :type type: str or ~azure.mgmt.sqlvirtualmachine.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = type
        self.tenant_id = None


class ServerConfigurationsManagementSettings(Model):
    """Set the connectivity, storage and workload settings.

    :param sql_connectivity_update_settings: SQL connectivity type settings.
    :type sql_connectivity_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlConnectivityUpdateSettings
    :param sql_workload_type_update_settings: SQL workload type settings.
    :type sql_workload_type_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlWorkloadTypeUpdateSettings
    :param sql_storage_update_settings: SQL storage update settings.
    :type sql_storage_update_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SqlStorageUpdateSettings
    :param additional_features_server_configurations: Additional SQL feature
     settings.
    :type additional_features_server_configurations:
     ~azure.mgmt.sqlvirtualmachine.models.AdditionalFeaturesServerConfigurations
    """

    _attribute_map = {
        'sql_connectivity_update_settings': {'key': 'sqlConnectivityUpdateSettings', 'type': 'SqlConnectivityUpdateSettings'},
        'sql_workload_type_update_settings': {'key': 'sqlWorkloadTypeUpdateSettings', 'type': 'SqlWorkloadTypeUpdateSettings'},
        'sql_storage_update_settings': {'key': 'sqlStorageUpdateSettings', 'type': 'SqlStorageUpdateSettings'},
        'additional_features_server_configurations': {'key': 'additionalFeaturesServerConfigurations', 'type': 'AdditionalFeaturesServerConfigurations'},
    }

    def __init__(self, *, sql_connectivity_update_settings=None, sql_workload_type_update_settings=None, sql_storage_update_settings=None, additional_features_server_configurations=None, **kwargs) -> None:
        super(ServerConfigurationsManagementSettings, self).__init__(**kwargs)
        self.sql_connectivity_update_settings = sql_connectivity_update_settings
        self.sql_workload_type_update_settings = sql_workload_type_update_settings
        self.sql_storage_update_settings = sql_storage_update_settings
        self.additional_features_server_configurations = additional_features_server_configurations


class SqlConnectivityUpdateSettings(Model):
    """Set the access level and network port settings for SQL Server.

    :param connectivity_type: SQL Server connectivity option. Possible values
     include: 'LOCAL', 'PRIVATE', 'PUBLIC'
    :type connectivity_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.ConnectivityType
    :param port: SQL Server port.
    :type port: int
    :param sql_auth_update_user_name: SQL Server sysadmin login to create.
    :type sql_auth_update_user_name: str
    :param sql_auth_update_password: SQL Server sysadmin login password.
    :type sql_auth_update_password: str
    """

    _attribute_map = {
        'connectivity_type': {'key': 'connectivityType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'sql_auth_update_user_name': {'key': 'sqlAuthUpdateUserName', 'type': 'str'},
        'sql_auth_update_password': {'key': 'sqlAuthUpdatePassword', 'type': 'str'},
    }

    def __init__(self, *, connectivity_type=None, port: int=None, sql_auth_update_user_name: str=None, sql_auth_update_password: str=None, **kwargs) -> None:
        super(SqlConnectivityUpdateSettings, self).__init__(**kwargs)
        self.connectivity_type = connectivity_type
        self.port = port
        self.sql_auth_update_user_name = sql_auth_update_user_name
        self.sql_auth_update_password = sql_auth_update_password


class SQLStorageSettings(Model):
    """Set disk storage settings for SQL Server.

    :param luns: Logical Unit Numbers for the disks.
    :type luns: list[int]
    :param default_file_path: SQL Server default file path
    :type default_file_path: str
    """

    _attribute_map = {
        'luns': {'key': 'luns', 'type': '[int]'},
        'default_file_path': {'key': 'defaultFilePath', 'type': 'str'},
    }

    def __init__(self, *, luns=None, default_file_path: str=None, **kwargs) -> None:
        super(SQLStorageSettings, self).__init__(**kwargs)
        self.luns = luns
        self.default_file_path = default_file_path


class SqlStorageUpdateSettings(Model):
    """Set disk storage settings for SQL Server.

    :param disk_count: Virtual machine disk count.
    :type disk_count: int
    :param starting_device_id: Device id of the first disk to be updated.
    :type starting_device_id: int
    :param disk_configuration_type: Disk configuration to apply to SQL Server.
     Possible values include: 'NEW', 'EXTEND', 'ADD'
    :type disk_configuration_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.DiskConfigurationType
    """

    _attribute_map = {
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'starting_device_id': {'key': 'startingDeviceId', 'type': 'int'},
        'disk_configuration_type': {'key': 'diskConfigurationType', 'type': 'str'},
    }

    def __init__(self, *, disk_count: int=None, starting_device_id: int=None, disk_configuration_type=None, **kwargs) -> None:
        super(SqlStorageUpdateSettings, self).__init__(**kwargs)
        self.disk_count = disk_count
        self.starting_device_id = starting_device_id
        self.disk_configuration_type = disk_configuration_type


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class SqlVirtualMachine(TrackedResource):
    """A SQL virtual machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param identity: Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.sqlvirtualmachine.models.ResourceIdentity
    :param virtual_machine_resource_id: ARM Resource id of underlying virtual
     machine created from SQL marketplace image.
    :type virtual_machine_resource_id: str
    :ivar provisioning_state: Provisioning state to track the async operation
     status.
    :vartype provisioning_state: str
    :param sql_image_offer: SQL image offer. Examples include SQL2016-WS2016,
     SQL2017-WS2016.
    :type sql_image_offer: str
    :param sql_server_license_type: SQL Server license type. Possible values
     include: 'PAYG', 'AHUB', 'DR'
    :type sql_server_license_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.SqlServerLicenseType
    :param sql_management: SQL Server Management type. Possible values
     include: 'Full', 'LightWeight', 'NoAgent'
    :type sql_management: str or
     ~azure.mgmt.sqlvirtualmachine.models.SqlManagementMode
    :param sql_image_sku: SQL Server edition type. Possible values include:
     'Developer', 'Express', 'Standard', 'Enterprise', 'Web'
    :type sql_image_sku: str or
     ~azure.mgmt.sqlvirtualmachine.models.SqlImageSku
    :param sql_virtual_machine_group_resource_id: ARM resource id of the SQL
     virtual machine group this SQL virtual machine is or will be part of.
    :type sql_virtual_machine_group_resource_id: str
    :param wsfc_domain_credentials: Domain credentials for setting up Windows
     Server Failover Cluster for SQL availability group.
    :type wsfc_domain_credentials:
     ~azure.mgmt.sqlvirtualmachine.models.WsfcDomainCredentials
    :param auto_patching_settings: Auto patching settings for applying
     critical security updates to SQL virtual machine.
    :type auto_patching_settings:
     ~azure.mgmt.sqlvirtualmachine.models.AutoPatchingSettings
    :param auto_backup_settings: Auto backup settings for SQL Server.
    :type auto_backup_settings:
     ~azure.mgmt.sqlvirtualmachine.models.AutoBackupSettings
    :param key_vault_credential_settings: Key vault credential settings.
    :type key_vault_credential_settings:
     ~azure.mgmt.sqlvirtualmachine.models.KeyVaultCredentialSettings
    :param server_configurations_management_settings: SQL Server configuration
     management settings.
    :type server_configurations_management_settings:
     ~azure.mgmt.sqlvirtualmachine.models.ServerConfigurationsManagementSettings
    :param storage_configuration_settings: Storage Configuration Settings.
    :type storage_configuration_settings:
     ~azure.mgmt.sqlvirtualmachine.models.StorageConfigurationSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'virtual_machine_resource_id': {'key': 'properties.virtualMachineResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_image_offer': {'key': 'properties.sqlImageOffer', 'type': 'str'},
        'sql_server_license_type': {'key': 'properties.sqlServerLicenseType', 'type': 'str'},
        'sql_management': {'key': 'properties.sqlManagement', 'type': 'str'},
        'sql_image_sku': {'key': 'properties.sqlImageSku', 'type': 'str'},
        'sql_virtual_machine_group_resource_id': {'key': 'properties.sqlVirtualMachineGroupResourceId', 'type': 'str'},
        'wsfc_domain_credentials': {'key': 'properties.wsfcDomainCredentials', 'type': 'WsfcDomainCredentials'},
        'auto_patching_settings': {'key': 'properties.autoPatchingSettings', 'type': 'AutoPatchingSettings'},
        'auto_backup_settings': {'key': 'properties.autoBackupSettings', 'type': 'AutoBackupSettings'},
        'key_vault_credential_settings': {'key': 'properties.keyVaultCredentialSettings', 'type': 'KeyVaultCredentialSettings'},
        'server_configurations_management_settings': {'key': 'properties.serverConfigurationsManagementSettings', 'type': 'ServerConfigurationsManagementSettings'},
        'storage_configuration_settings': {'key': 'properties.storageConfigurationSettings', 'type': 'StorageConfigurationSettings'},
    }

    def __init__(self, *, location: str, tags=None, identity=None, virtual_machine_resource_id: str=None, sql_image_offer: str=None, sql_server_license_type=None, sql_management=None, sql_image_sku=None, sql_virtual_machine_group_resource_id: str=None, wsfc_domain_credentials=None, auto_patching_settings=None, auto_backup_settings=None, key_vault_credential_settings=None, server_configurations_management_settings=None, storage_configuration_settings=None, **kwargs) -> None:
        super(SqlVirtualMachine, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.virtual_machine_resource_id = virtual_machine_resource_id
        self.provisioning_state = None
        self.sql_image_offer = sql_image_offer
        self.sql_server_license_type = sql_server_license_type
        self.sql_management = sql_management
        self.sql_image_sku = sql_image_sku
        self.sql_virtual_machine_group_resource_id = sql_virtual_machine_group_resource_id
        self.wsfc_domain_credentials = wsfc_domain_credentials
        self.auto_patching_settings = auto_patching_settings
        self.auto_backup_settings = auto_backup_settings
        self.key_vault_credential_settings = key_vault_credential_settings
        self.server_configurations_management_settings = server_configurations_management_settings
        self.storage_configuration_settings = storage_configuration_settings


class SqlVirtualMachineGroup(TrackedResource):
    """A SQL virtual machine group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state to track the async operation
     status.
    :vartype provisioning_state: str
    :param sql_image_offer: SQL image offer. Examples may include
     SQL2016-WS2016, SQL2017-WS2016.
    :type sql_image_offer: str
    :param sql_image_sku: SQL image sku. Possible values include: 'Developer',
     'Enterprise'
    :type sql_image_sku: str or
     ~azure.mgmt.sqlvirtualmachine.models.SqlVmGroupImageSku
    :ivar scale_type: Scale type. Possible values include: 'HA'
    :vartype scale_type: str or ~azure.mgmt.sqlvirtualmachine.models.ScaleType
    :ivar cluster_manager_type: Type of cluster manager: Windows Server
     Failover Cluster (WSFC), implied by the scale type of the group and the OS
     type. Possible values include: 'WSFC'
    :vartype cluster_manager_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.ClusterManagerType
    :ivar cluster_configuration: Cluster type. Possible values include:
     'Domainful'
    :vartype cluster_configuration: str or
     ~azure.mgmt.sqlvirtualmachine.models.ClusterConfiguration
    :param wsfc_domain_profile: Cluster Active Directory domain profile.
    :type wsfc_domain_profile:
     ~azure.mgmt.sqlvirtualmachine.models.WsfcDomainProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'scale_type': {'readonly': True},
        'cluster_manager_type': {'readonly': True},
        'cluster_configuration': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_image_offer': {'key': 'properties.sqlImageOffer', 'type': 'str'},
        'sql_image_sku': {'key': 'properties.sqlImageSku', 'type': 'str'},
        'scale_type': {'key': 'properties.scaleType', 'type': 'str'},
        'cluster_manager_type': {'key': 'properties.clusterManagerType', 'type': 'str'},
        'cluster_configuration': {'key': 'properties.clusterConfiguration', 'type': 'str'},
        'wsfc_domain_profile': {'key': 'properties.wsfcDomainProfile', 'type': 'WsfcDomainProfile'},
    }

    def __init__(self, *, location: str, tags=None, sql_image_offer: str=None, sql_image_sku=None, wsfc_domain_profile=None, **kwargs) -> None:
        super(SqlVirtualMachineGroup, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.sql_image_offer = sql_image_offer
        self.sql_image_sku = sql_image_sku
        self.scale_type = None
        self.cluster_manager_type = None
        self.cluster_configuration = None
        self.wsfc_domain_profile = wsfc_domain_profile


class SqlVirtualMachineGroupUpdate(Model):
    """An update to a SQL virtual machine group.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(SqlVirtualMachineGroupUpdate, self).__init__(**kwargs)
        self.tags = tags


class SqlVirtualMachineUpdate(Model):
    """An update to a SQL virtual machine.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(SqlVirtualMachineUpdate, self).__init__(**kwargs)
        self.tags = tags


class SqlWorkloadTypeUpdateSettings(Model):
    """Set workload type to optimize storage for SQL Server.

    :param sql_workload_type: SQL Server workload type. Possible values
     include: 'GENERAL', 'OLTP', 'DW'
    :type sql_workload_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.SqlWorkloadType
    """

    _attribute_map = {
        'sql_workload_type': {'key': 'sqlWorkloadType', 'type': 'str'},
    }

    def __init__(self, *, sql_workload_type=None, **kwargs) -> None:
        super(SqlWorkloadTypeUpdateSettings, self).__init__(**kwargs)
        self.sql_workload_type = sql_workload_type


class StorageConfigurationSettings(Model):
    """Storage Configurations for SQL Data, Log and TempDb.

    :param sql_data_settings: SQL Server Data Storage Settings.
    :type sql_data_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param sql_log_settings: SQL Server Log Storage Settings.
    :type sql_log_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param sql_temp_db_settings: SQL Server TempDb Storage Settings.
    :type sql_temp_db_settings:
     ~azure.mgmt.sqlvirtualmachine.models.SQLStorageSettings
    :param disk_configuration_type: Disk configuration to apply to SQL Server.
     Possible values include: 'NEW', 'EXTEND', 'ADD'
    :type disk_configuration_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.DiskConfigurationType
    :param storage_workload_type: Storage workload type. Possible values
     include: 'GENERAL', 'OLTP', 'DW'
    :type storage_workload_type: str or
     ~azure.mgmt.sqlvirtualmachine.models.StorageWorkloadType
    """

    _attribute_map = {
        'sql_data_settings': {'key': 'sqlDataSettings', 'type': 'SQLStorageSettings'},
        'sql_log_settings': {'key': 'sqlLogSettings', 'type': 'SQLStorageSettings'},
        'sql_temp_db_settings': {'key': 'sqlTempDbSettings', 'type': 'SQLStorageSettings'},
        'disk_configuration_type': {'key': 'diskConfigurationType', 'type': 'str'},
        'storage_workload_type': {'key': 'storageWorkloadType', 'type': 'str'},
    }

    def __init__(self, *, sql_data_settings=None, sql_log_settings=None, sql_temp_db_settings=None, disk_configuration_type=None, storage_workload_type=None, **kwargs) -> None:
        super(StorageConfigurationSettings, self).__init__(**kwargs)
        self.sql_data_settings = sql_data_settings
        self.sql_log_settings = sql_log_settings
        self.sql_temp_db_settings = sql_temp_db_settings
        self.disk_configuration_type = disk_configuration_type
        self.storage_workload_type = storage_workload_type


class WsfcDomainCredentials(Model):
    """Domain credentials for setting up Windows Server Failover Cluster for SQL
    availability group.

    :param cluster_bootstrap_account_password: Cluster bootstrap account
     password.
    :type cluster_bootstrap_account_password: str
    :param cluster_operator_account_password: Cluster operator account
     password.
    :type cluster_operator_account_password: str
    :param sql_service_account_password: SQL service account password.
    :type sql_service_account_password: str
    """

    _attribute_map = {
        'cluster_bootstrap_account_password': {'key': 'clusterBootstrapAccountPassword', 'type': 'str'},
        'cluster_operator_account_password': {'key': 'clusterOperatorAccountPassword', 'type': 'str'},
        'sql_service_account_password': {'key': 'sqlServiceAccountPassword', 'type': 'str'},
    }

    def __init__(self, *, cluster_bootstrap_account_password: str=None, cluster_operator_account_password: str=None, sql_service_account_password: str=None, **kwargs) -> None:
        super(WsfcDomainCredentials, self).__init__(**kwargs)
        self.cluster_bootstrap_account_password = cluster_bootstrap_account_password
        self.cluster_operator_account_password = cluster_operator_account_password
        self.sql_service_account_password = sql_service_account_password


class WsfcDomainProfile(Model):
    """Active Directory account details to operate Windows Server Failover
    Cluster.

    :param domain_fqdn: Fully qualified name of the domain.
    :type domain_fqdn: str
    :param ou_path: Organizational Unit path in which the nodes and cluster
     will be present.
    :type ou_path: str
    :param cluster_bootstrap_account: Account name used for creating cluster
     (at minimum needs permissions to 'Create Computer Objects' in domain).
    :type cluster_bootstrap_account: str
    :param cluster_operator_account: Account name used for operating cluster
     i.e. will be part of administrators group on all the participating virtual
     machines in the cluster.
    :type cluster_operator_account: str
    :param sql_service_account: Account name under which SQL service will run
     on all participating SQL virtual machines in the cluster.
    :type sql_service_account: str
    :param file_share_witness_path: Optional path for fileshare witness.
    :type file_share_witness_path: str
    :param storage_account_url: Fully qualified ARM resource id of the witness
     storage account.
    :type storage_account_url: str
    :param storage_account_primary_key: Primary key of the witness storage
     account.
    :type storage_account_primary_key: str
    """

    _attribute_map = {
        'domain_fqdn': {'key': 'domainFqdn', 'type': 'str'},
        'ou_path': {'key': 'ouPath', 'type': 'str'},
        'cluster_bootstrap_account': {'key': 'clusterBootstrapAccount', 'type': 'str'},
        'cluster_operator_account': {'key': 'clusterOperatorAccount', 'type': 'str'},
        'sql_service_account': {'key': 'sqlServiceAccount', 'type': 'str'},
        'file_share_witness_path': {'key': 'fileShareWitnessPath', 'type': 'str'},
        'storage_account_url': {'key': 'storageAccountUrl', 'type': 'str'},
        'storage_account_primary_key': {'key': 'storageAccountPrimaryKey', 'type': 'str'},
    }

    def __init__(self, *, domain_fqdn: str=None, ou_path: str=None, cluster_bootstrap_account: str=None, cluster_operator_account: str=None, sql_service_account: str=None, file_share_witness_path: str=None, storage_account_url: str=None, storage_account_primary_key: str=None, **kwargs) -> None:
        super(WsfcDomainProfile, self).__init__(**kwargs)
        self.domain_fqdn = domain_fqdn
        self.ou_path = ou_path
        self.cluster_bootstrap_account = cluster_bootstrap_account
        self.cluster_operator_account = cluster_operator_account
        self.sql_service_account = sql_service_account
        self.file_share_witness_path = file_share_witness_path
        self.storage_account_url = storage_account_url
        self.storage_account_primary_key = storage_account_primary_key
