# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ArmTemplateParameter(Model):
    """Parameter to pass to ARM template.

    :param name: name of the parameter.
    :type name: str
    :param value: value for the parameter. In Jtoken
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ArmTemplateParameter, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CodeMessageError(Model):
    """The error body contract.

    :param error: The error details for a failed request.
    :type error: ~azure.mgmt.operationsmanagement.models.CodeMessageErrorError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CodeMessageErrorError'},
    }

    def __init__(self, **kwargs):
        super(CodeMessageError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CodeMessageErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CodeMessageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CodeMessageErrorException, self).__init__(deserialize, response, 'CodeMessageError', *args)


class CodeMessageErrorError(Model):
    """The error details for a failed request.

    :param code: The error type.
    :type code: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CodeMessageErrorError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ManagementAssociation(Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param properties: Properties for ManagementAssociation object supported
     by the OperationsManagement resource provider.
    :type properties:
     ~azure.mgmt.operationsmanagement.models.ManagementAssociationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ManagementAssociationProperties'},
    }

    def __init__(self, **kwargs):
        super(ManagementAssociation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)


class ManagementAssociationProperties(Model):
    """ManagementAssociation properties supported by the OperationsManagement
    resource provider.

    All required parameters must be populated in order to send to Azure.

    :param application_id: Required. The applicationId of the appliance for
     this association.
    :type application_id: str
    """

    _validation = {
        'application_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagementAssociationProperties, self).__init__(**kwargs)
        self.application_id = kwargs.get('application_id', None)


class ManagementAssociationPropertiesList(Model):
    """the list of ManagementAssociation response.

    :param value: List of Management Association properties within the
     subscription.
    :type value:
     list[~azure.mgmt.operationsmanagement.models.ManagementAssociation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementAssociation]'},
    }

    def __init__(self, **kwargs):
        super(ManagementAssociationPropertiesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ManagementConfiguration(Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param properties: Properties for ManagementConfiguration object supported
     by the OperationsManagement resource provider.
    :type properties:
     ~azure.mgmt.operationsmanagement.models.ManagementConfigurationProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ManagementConfigurationProperties'},
    }

    def __init__(self, **kwargs):
        super(ManagementConfiguration, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.properties = kwargs.get('properties', None)


class ManagementConfigurationProperties(Model):
    """ManagementConfiguration properties supported by the OperationsManagement
    resource provider.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param application_id: The applicationId of the appliance for this
     Management.
    :type application_id: str
    :param parent_resource_type: Required. The type of the parent resource.
    :type parent_resource_type: str
    :param parameters: Required. Parameters to run the ARM template
    :type parameters:
     list[~azure.mgmt.operationsmanagement.models.ArmTemplateParameter]
    :ivar provisioning_state: The provisioning state for the
     ManagementConfiguration.
    :vartype provisioning_state: str
    :param template: Required. The Json object containing the ARM template to
     deploy
    :type template: object
    """

    _validation = {
        'parent_resource_type': {'required': True},
        'parameters': {'required': True},
        'provisioning_state': {'readonly': True},
        'template': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'parent_resource_type': {'key': 'parentResourceType', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArmTemplateParameter]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'template': {'key': 'template', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ManagementConfigurationProperties, self).__init__(**kwargs)
        self.application_id = kwargs.get('application_id', None)
        self.parent_resource_type = kwargs.get('parent_resource_type', None)
        self.parameters = kwargs.get('parameters', None)
        self.provisioning_state = None
        self.template = kwargs.get('template', None)


class ManagementConfigurationPropertiesList(Model):
    """the list of ManagementConfiguration response.

    :param value: List of Management Configuration properties within the
     subscription.
    :type value:
     list[~azure.mgmt.operationsmanagement.models.ManagementConfiguration]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(ManagementConfigurationPropertiesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class Operation(Model):
    """Supported operation of OperationsManagement resource provider.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.operationsmanagement.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft OperationsManagement.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class Solution(Model):
    """The container for solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param plan: Plan for solution object supported by the
     OperationsManagement resource provider.
    :type plan: ~azure.mgmt.operationsmanagement.models.SolutionPlan
    :param properties: Properties for solution object supported by the
     OperationsManagement resource provider.
    :type properties:
     ~azure.mgmt.operationsmanagement.models.SolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'SolutionPlan'},
        'properties': {'key': 'properties', 'type': 'SolutionProperties'},
    }

    def __init__(self, **kwargs):
        super(Solution, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.plan = kwargs.get('plan', None)
        self.properties = kwargs.get('properties', None)


class SolutionPatch(Model):
    """The properties of a Solution that can be patched.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(SolutionPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class SolutionPlan(Model):
    """Plan for solution object supported by the OperationsManagement resource
    provider.

    :param name: name of the solution to be created. For Microsoft published
     solution it should be in the format of solutionType(workspaceName).
     SolutionType part is case sensitive. For third party solution, it can be
     anything.
    :type name: str
    :param publisher: Publisher name. For gallery solution, it is Microsoft.
    :type publisher: str
    :param promotion_code: promotionCode, Not really used now, can you left as
     empty
    :type promotion_code: str
    :param product: name of the solution to enabled/add. For Microsoft
     published gallery solution it should be in the format of
     OMSGallery/<solutionType>. This is case sensitive
    :type product: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SolutionPlan, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.promotion_code = kwargs.get('promotion_code', None)
        self.product = kwargs.get('product', None)


class SolutionProperties(Model):
    """Solution properties supported by the OperationsManagement resource
    provider.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param workspace_resource_id: Required. The azure resourceId for the
     workspace where the solution will be deployed/enabled.
    :type workspace_resource_id: str
    :ivar provisioning_state: The provisioning state for the solution.
    :vartype provisioning_state: str
    :param contained_resources: The azure resources that will be contained
     within the solutions. They will be locked and gets deleted automatically
     when the solution is deleted.
    :type contained_resources: list[str]
    :param referenced_resources: The resources that will be referenced from
     this solution. Deleting any of those solution out of band will break the
     solution.
    :type referenced_resources: list[str]
    """

    _validation = {
        'workspace_resource_id': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'contained_resources': {'key': 'containedResources', 'type': '[str]'},
        'referenced_resources': {'key': 'referencedResources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SolutionProperties, self).__init__(**kwargs)
        self.workspace_resource_id = kwargs.get('workspace_resource_id', None)
        self.provisioning_state = None
        self.contained_resources = kwargs.get('contained_resources', None)
        self.referenced_resources = kwargs.get('referenced_resources', None)


class SolutionPropertiesList(Model):
    """the list of solution response.

    :param value: List of solution properties within the subscription.
    :type value: list[~azure.mgmt.operationsmanagement.models.Solution]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Solution]'},
    }

    def __init__(self, **kwargs):
        super(SolutionPropertiesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
