# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData(Model):
    """Incoming video stream out of synch event data.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar first_timestamp: Gets the first timestamp received for one of the
     quality levels.
    :vartype first_timestamp: str
    :ivar first_duration: Gets the duration of the data chunk with first
     timestamp.
    :vartype first_duration: str
    :ivar second_timestamp: Gets the timestamp received for some other quality
     levels.
    :vartype second_timestamp: str
    :ivar second_duration: Gets the duration of the data chunk with second
     timestamp.
    :vartype second_duration: str
    :ivar timescale: Gets the timescale in which both the timestamps and
     durations are represented.
    :vartype timescale: str
    """

    _validation = {
        'first_timestamp': {'readonly': True},
        'first_duration': {'readonly': True},
        'second_timestamp': {'readonly': True},
        'second_duration': {'readonly': True},
        'timescale': {'readonly': True},
    }

    _attribute_map = {
        'first_timestamp': {'key': 'firstTimestamp', 'type': 'str'},
        'first_duration': {'key': 'firstDuration', 'type': 'str'},
        'second_timestamp': {'key': 'secondTimestamp', 'type': 'str'},
        'second_duration': {'key': 'secondDuration', 'type': 'str'},
        'timescale': {'key': 'timescale', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData, self).__init__(**kwargs)
        self.first_timestamp = None
        self.first_duration = None
        self.second_timestamp = None
        self.second_duration = None
        self.timescale = None
