#include "pgrp_dat.h"
#define  NumPgrp   37

int nop_pgrp[NumPgrp]={
 /* triclinic monoclinic  orthorombic     tetragonal */
       1,2,     2,2,4,      4,4,8,     4,4,8,8,8,8,8,16,
 /*   trigonal                 hexagonal */
    3,6,6,6,6,6,12,12,    6,6,12,12,12,12,12,24,
 /*   cubic */
   12,24,24,24,48
};

char name_pgrp[NumPgrp][32]={
   "1      1      C1",
   "-1    -1      Ci",
     
   "2      2      C2",
   "m      m      Cs",
   "2/m    2/m    C2h",
     
   "222    222    D2",
   "mm2    mm2    C2v",
   "mmm    2/m 2/m 2/m   D2h",
     
   "4      4      C4",
   "-4    -4      S4",
   "4/m    4/m    C4h",
   "422    422    D4",
   "4mm    4mm    C4v",
   "-42m   -42m   D2d",
   "-4m2   -4m2   D2d",
   "4/mmm   4/m 2/m 2/m    D4h",
     
   "3      3      C3",
   "-3    -3      C3i",
   "312    312    D3",
   "321    321    D3",
   "3m1    3m1    C3v",
   "31m    31m    C3v",
   "-31m  -3 1 2/m    D3d",
   "-3m1  -3 2/m 1    D3d",
     
   "6      6      C6",
   "-6    -6      C3h",
   "6/m    6/m    C6h",
   "622    622    D6",
   "6mm    6mm    C6v",
   "-6m2  -6m2    D3h",
   "-62m  -62m    D3h",
   "6/mmm  6/m 2/m 2/m     D6h",
     
   "23     23     T",
   "m-3    2/m-3  Th",
   "432    432    O",
   "-43m  -43m    Td",
   "m-3m   4/m -3 2/m   Oh"
};
  
int ind_pgrp[NumPgrp][48]={
    /** C1 **/
     { ONE },
    /** CI **/
     { ONE,    INV },
     
    /** C2 **/
     { ONE,    C2001 },
    /** CS **/
     { ONE,    Mxy0 },
    /** C2h **/
     { ONE,    C2001,    INV,      Mxy0 },

    /** D2 **/
     { ONE,    C2001,    C2010,    C2100 },
    /** C2v **/
     { ONE,    C2001,    Mx0z,     M0yz },
    /** D2h **/
     { ONE,    C2001,    C2010,    C2100,
       INV,    Mxy0,     Mx0z,     M0yz },
     
    /** C4 **/
     { ONE,    C2001,    C4p001,   C4m001 },
    /** S4 **/
     { ONE,    C2001,    S4p001,   S4m001 },
    /** C4h **/
     { ONE,    C2001,    C4p001,   C4m001,
       INV,    Mxy0,     S4p001,   S4m001 },
    /** D4 **/
     { ONE,    C2001,    C4p001,   C4m001,
       C2010,  C2100,    C2110,    C21_10 },
    /** C4v **/
     { ONE,    C2001,    C4p001,   C4m001,
       Mx0z,   M0yz,     Mx_xz,    Mxxz  },
    /** D2d **/
     { ONE,    C2001,    S4p001,   S4m001,
       C2010,  C2100,    Mx_xz,    Mxxz  },
    /** D2d2 **/
     { ONE,    C2001,    S4p001,   S4m001,
       Mx0z,   M0yz,     C2110,    C21_10 },
    /** D4h **/
     { ONE,    C2001,    C4p001,   C4m001,
       C2010,  C2100,    C2110,    C21_10,
       INV,    Mxy0,     S4p001,   S4m001 ,
       Mx0z,   M0yz,     Mx_xz,    Mxxz  },

     /** C3 **/
     { ONEh,    C3p001h,   C3m001h },
     /** C3i **/
     { ONEh,    C3p001h,   C3m001h,
       INVh,    S3p001h,   S3m001h },
     /** D3 **/
     { ONEh,    C3p001h,   C3m001h,
       C21_10h, C2120h,    C2210h  },
     /** D32 **/
     { ONEh,    C3p001h,   C3m001h,
       C2110h,  C2100h,    C2010h  },
     /** C3v **/
     { ONEh,    C3p001h,   C3m001h,
       Mx_xzh,  Mx2xzh,    M2xxzh  },
     /** C3v2 **/
     { ONEh,    C3p001h,   C3m001h,
       Mxxzh,   Mx0zh,     M0yzh  },
     /** D3d **/
     { ONEh,    C3p001h,   C3m001h,
       C21_10h, C2120h,    C2210h ,
       INVh,    S3p001h,   S3m001h,
       Mxxzh,   Mx0zh,     M0yzh  },
     /** D3d2 **/
     { ONEh,    C3p001h,   C3m001h,
       C2110h,  C2100h,    C2010h ,
       INVh,    S3p001h,   S3m001h,
       Mx_xzh,  Mx2xzh,    M2xxzh  },
   
     /** C6 **/
     { ONEh,    C3p001h,   C3m001h,
       C2001h,  C6m001h,   C6p001h },
     /** C3h **/
     { ONEh,    C3p001h,   C3m001h,
       Mxy0h,   S6m001h,   S6p001h },
     /** C6h **/
     { ONEh,    C3p001h,   C3m001h,
       C2001h,  C6m001h,   C6p001h,
       INVh,    S3p001h,   S3m001h,
       Mxy0h,   S6m001h,   S6p001h },
     /** D6 **/
     { ONEh,    C3p001h,   C3m001h,
       C2001h,  C6m001h,   C6p001h,
       C2110h,  C2100h,    C2010h,
       C21_10h, C2120h,    C2210h },
     /** C6v **/
     { ONEh,    C3p001h,   C3m001h,
       C2001h,  C6m001h,   C6p001h,
       Mx_xzh,  Mx2xzh,    M2xxzh,
       Mxxzh,   Mx0zh,     M0yzh  },
    /** D3h **/
     { ONEh,    C3p001h,   C3m001h,
       Mxy0h,   S6m001h,   S6p001h,
       Mx_xzh,  Mx2xzh,    M2xxzh,
       C21_10h, C2120h,    C2210h },
    /** D3h2 space group (N 189) **/
     { ONEh,    C3p001h,   C3m001h,
       Mxy0h,   S6m001h,   S6p001h,
       C2110h,  C2100h,    C2010h,
       Mxxzh,   Mx0zh,     M0yzh },
     /** D6h **/
     { ONEh,    C3p001h,   C3m001h,
       C2001h,  C6m001h,   C6p001h,
       C2110h,  C2100h,    C2010h,
       C21_10h, C2120h,    C2210h,
       INVh,    S3p001h,   S3m001h,
       Mxy0h,   S6m001h,   S6p001h,
       Mx_xzh,  Mx2xzh,    M2xxzh,
       Mxxzh,   Mx0zh,     M0yzh  },
          
    /** T **/
     { ONE,    C2001,    C2010,    C2100,
       C3p111, C3p_11_1, C3p1_1_1, C3p_1_11,
       C3m111, C3m1_1_1, C3m_1_11, C3m_11_1  },
    /** Th **/
     { ONE,    C2001,    C2010,    C2100,
       C3p111, C3p_11_1, C3p1_1_1, C3p_1_11,
       C3m111, C3m1_1_1, C3m_1_11, C3m_11_1,
       INV,    Mxy0,     Mx0z,     M0yz,
       S3p111, S3p_11_1, S3p1_1_1, S3p_1_11,
       S3m111, S3m1_1_1, S3m_1_11, S3m_11_1 },
    /** O **/
     { ONE,    C2001,    C2010,    C2100,
       C3p111, C3p_11_1, C3p1_1_1, C3p_1_11,
       C3m111, C3m1_1_1, C3m_1_11, C3m_11_1,
       C2110,  C21_10,   C4m001,   C4p001,
       C4m100, C2011,    C201_1,   C4p100,
       C4p010, C2101,    C4m010,   C2_101   },
    /** Td **/
     { ONE,    C2001,    C2010,    C2100,
       C3p111, C3p_11_1, C3p1_1_1, C3p_1_11,
       C3m111, C3m1_1_1, C3m_1_11, C3m_11_1,
       Mxxz,   Mx_xz,    S4p001,   S4m001,
       Mxyy,   S4p100,   S4m100,   Mxy_y,
       Mxyx,   S4m010,   M_xyx,    S4p010 },
    /** Oh **/
     { ONE,    C2001,    C2010,    C2100,
       C3p111, C3p_11_1, C3p1_1_1, C3p_1_11,
       C3m111, C3m1_1_1, C3m_1_11, C3m_11_1,
       C2110,  C21_10,   C4m001,   C4p001,
       C4m100, C2011,    C201_1,   C4p100,
       C4p010, C2101,    C4m010,   C2_101,
       INV,    Mxy0,     Mx0z,     M0yz,
       S3p111, S3p_11_1, S3p1_1_1, S3p_1_11,
       S3m111, S3m1_1_1, S3m_1_11, S3m_11_1,
       Mx_xz,  Mxxz,     S4m001,   S4p001,
       S4m100, Mxy_y,    Mxyy,     S4p100,
       S4p010, M_xyx,    S4m010,   Mxyx
     }
};
          
     
/*** POINT GROUPS FROM INTERNATIONAL TABLES FOR CRYSTALLOGRAPHY 1992 ***/


       /********** TRICLINIC point groups *************/
       /********** C1, Ci *************/

/**** C1 triclinic group  *************/
double C1_pgrp[1][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};

/**** Ci triclinic group  *************/
double Ci_pgrp[2][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    2; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0
};

       /********** MONOCLINIC point groups *************/
       /********** C2, Cs, C2h *************************/

/**** C2 monoclinic group  *************/
double C2_pgrp[2][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0
};

/**** Cs monoclinic group  *************/
double Cs_pgrp[2][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    2; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0
};

/**** C2h monoclinic group  *************/
double C2h_pgrp[4][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    3; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0
};
     
       /********** ORTHOROMBIC point groups *************/
       /********** D2, C2v, D2h *************************/

/**** D2 orthorombic group  *************/
double D2_pgrp[4][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
  
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0
};

/**** C2v orthorombic group  *************/
double C2v_pgrp[4][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    3; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    4; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};

/**** D2h orthorombic group  *************/
double D2h_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
  
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  0.0,  0.0, /*    5; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    6; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    7; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    8; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};

       /********** TETRAGONAL point groups *************/
       /********** C4, S4, C4h, D4, C4v, D2d, D2d2, D4h ******/

/**** C4 tetragonal group  *************/
double C4_pgrp[4][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    3; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    4; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};

/**** S4 tetragonal group  *************/
double S4_pgrp[4][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    3; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    4; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};

/**** C4h tetragonal group  *************/
double C4h_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    3; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    4; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    5; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    6; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*    7; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    8; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};

/**** D4 tetragonal group  *************/
double D4_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    3; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    4; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
  
               -1.0,  0.0,  0.0, /*    5; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    6; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,

                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*    8; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};

/**** C4v tetragonal group  *************/
double C4v_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    3; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    4; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    5; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    6; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*    7; m   [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    8; m   [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};
     
/**** D2d tetragonal group  *************/
double D2d_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    3; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    4; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  0.0,  0.0, /*    5; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    6; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    7; m   [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    8; m   [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};

/**** D2d2 tetragonal group  *************/
double D2d2_pgrp[8][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    3; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    4; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    5; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    6; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*    8; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};
       
/**** D4h tetragonal group  *************/
double D4h_pgrp[16][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    3; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*    4; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
  
               -1.0,  0.0,  0.0, /*    5; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*    6; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,

                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*    8; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*    9; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   10; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   11; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   12; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   13; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   14; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*   15; m   [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   16; m   [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};

       /********** TRIGONAL point groups in hexagonal setting *************/
       /**********   C3, C3i, D3, D32, C3v, C3v2, D3d, D3d2   *************/

/******   C3 trigonal group ******/
double C3_pgrp[3*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};
/******   C3i trigonal group ******/
double C3i_pgrp[6*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   4; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   4; 3_+[ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0, -1.0,  0.0, /*   6; 3_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
     
};
/******   D3 trigonal group ******/
double D3_pgrp[6*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*   4; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  1.0,  0.0, /*   5; 2  [ 1 2 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   6; 2  [ 2 1 0]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0
};
/******   D32 trigonal group ( N150 ) ******/
double D32_pgrp[6*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*   4; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0, -1.0,  0.0, /*   5; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*   6; 2  [ 0 1 0]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0
};
/******   C3v trigonal group ******/
double C3v_pgrp[6*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*   4; m  [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   5; m  [ x2x z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*   6; m  [2x x z]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0
};
/******   C3v2 (N157) trigonal group ******/
double C3v2_pgrp[6*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   4; m  [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*   5; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   6; m  [ 0 y z]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};
/******   D3d trigonal group ******/
double D3d_pgrp[12*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*   4; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  1.0,  0.0, /*   5; 2  [ 1 2 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   6; 2  [ 2 1 0]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*   7; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   8; 3_+[ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0, -1.0,  0.0, /*   9; 3_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   10; m  [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*   11; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   12; m  [ 0 y z]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};
/******   D3d2 (164) trigonal group ******/
double D3d2_pgrp[12*3*3] = {
                1.0,  0.0,  0.0, /*   1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
                0.0, -1.0,  0.0, /*   2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0,  1.0,  0.0, /*   4; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0, -1.0,  0.0, /*   5; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*   6; 2  [ 0 1 0]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*   7; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   8; 3_+[ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0, -1.0,  0.0, /*   9; 3_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*   10; m [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   11; m [x 2x z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*   12; m [2x x z]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0
};

       /********** HEXAGONAL point groups *************/
       /**********  C6, C3h, C6h, D6, C6v, D3h, D3h2, D6h  *************/

/******   C6 hexagonal group ******/
double C6_pgrp[6][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    4; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    5; 6- [ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*    6; 6+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0
};

/******   C3h hexagonal group ******/
double C3h_pgrp[6][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    4; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    5; 6_-[ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*    6; 6_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};
     
/******   C6h hexagonal group ******/
double C6h_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    4; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    5; 6- [ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*    6; 6+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    7; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   8; 3_+[ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0, -1.0,  0.0, /*   9; 3_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*   10; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   11; 6_-[ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*   12; 6_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0
};
     
/******   D6 hexagonal group ******/
double D6_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    4; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    5; 6- [ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*    6; 6+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0, -1.0,  0.0, /*    8; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*    9; 2  [ 0 1 0]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   10; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  1.0,  0.0, /*   11; 2  [ 1 2 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   12; 2  [ 2 1 0]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0
};
     
/******   C6v hexagonal group ******/
double C6v_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    4; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    5; 6- [ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*    6; 6+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*    7; m  [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    8; m  [ x2x z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    9; m  [2x x z]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   10; m  [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*   11; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   12; m  [ 0 y z]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0
     
};
     
/******   D3h hexagonal group ******/
double D3h_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    4; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    5; 6_-[ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*    6; 6_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    7; m  [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    8; m  [ x2x z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    9; m  [2x x z]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0, -1.0,  0.0, /*   10; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*   11; 2  [ 1 2 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   12; 2  [ 2 1 0]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0
};

/******   D3h2 hexagonal group ******/
double D3h2_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*    4; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*    5; 6_-[ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*    6; 6_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0, -1.0,  0.0, /*    8; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*    9; 2  [ 0 1 0]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   10; m  [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*   11; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   12; m  [ 0 y z]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0
     
};

/******   D6h hexagonal group ******/
double D6h_pgrp[24][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*    2; 3+ [ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*    3; 3- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

               -1.0,  0.0,  0.0, /*    4; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    5; 6- [ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*    6; 6+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*    7; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0, -1.0,  0.0, /*    8; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*    9; 2  [ 0 1 0]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   10; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  1.0,  0.0, /*   11; 2  [ 1 2 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   12; 2  [ 2 1 0]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  0.0,  0.0, /*   13; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0,  1.0,  0.0, /*   14; 3_+[ 0 0 1]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0, -1.0,  0.0, /*   15; 3_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                1.0,  0.0,  0.0, /*   16; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   17; 6_-[ 0 0 1]  */
                1.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
               -1.0,  1.0,  0.0, /*   18; 6_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   19; m  [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  1.0,  0.0, /*   20; m  [ x2x z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*   21; m  [2x x z]  */
                1.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   22; m  [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                1.0, -1.0,  0.0, /*   23; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   24; m  [ 0 y z]  */
               -1.0,  1.0,  0.0,
                0.0,  0.0,  1.0
};

       /********** CUBIC point groups *************/
       /**********  T, Th, O, Td, Oh  *************/

/******   T cubic group ******/
double T_pgrp[12][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
   
                0.0,  0.0,  1.0, /*    5; 3+ [ 1 1 1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*    6; 3+ [-1 1-1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0, -1.0, /*    7; 3+ [ 1-1-1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0, -1.0, /*    8; 3+ [-1-1 1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  1.0,  0.0, /*    9; 3- [ 1 1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,

                0.0, -1.0,  0.0, /*   10; 3- [ 1-1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   11; 3- [-1-1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   12; 3- [-1 1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0
};

/******   Th cubic group ******/
double Th_pgrp[24][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
   
                0.0,  0.0,  1.0, /*    5; 3+ [ 1 1 1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*    6; 3+ [-1 1-1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0, -1.0, /*    7; 3+ [ 1-1-1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0, -1.0, /*    8; 3+ [-1-1 1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  1.0,  0.0, /*    9; 3- [ 1 1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,

                0.0, -1.0,  0.0, /*   10; 3- [ 1-1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   11; 3- [-1-1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   12; 3- [-1 1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,

               -1.0,  0.0,  0.0, /*   13; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   14; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   15; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   16; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  0.0, -1.0, /*   17; 3_+ [ 1 1 1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,

                0.0,  0.0, -1.0, /*   18; 3_+ [-1 1-1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,
     
                0.0,  0.0,  1.0, /*   19; 3_+ [ 1-1-1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,

                0.0,  0.0,  1.0, /*   20; 3_+ [-1-1 1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,
     
                0.0, -1.0,  0.0, /*   21; 3_- [ 1 1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,

                0.0,  1.0,  0.0, /*   22; 3_- [ 1-1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   23; 3_- [-1-1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   24; 3_- [-1 1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0
};
     
/******   O cubic group ******/
double O_pgrp[24][3][3]= {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
   
                0.0,  0.0,  1.0, /*    5; 3+ [ 1 1 1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*    6; 3+ [-1 1-1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0, -1.0, /*    7; 3+ [ 1-1-1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0, -1.0, /*    8; 3+ [-1-1 1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  1.0,  0.0, /*    9; 3- [ 1 1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,

                0.0, -1.0,  0.0, /*   10; 3- [ 1-1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   11; 3- [-1-1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   12; 3- [-1 1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,

                0.0,  1.0,  0.0, /*   13; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*   14; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0,  1.0,  0.0, /*   15; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
  
                0.0, -1.0,  0.0, /*   16; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*   17; 4- [ 1 0 0]  */
                0.0,  0.0,  1.0,
                0.0, -1.0,  0.0,

               -1.0,  0.0,  0.0, /*   18; 2  [ 0 1 1]  */
                0.0,  0.0,  1.0,
                0.0,  1.0,  0.0,

               -1.0,  0.0,  0.0, /*   19; 2  [ 0 1-1]  */
                0.0,  0.0, -1.0,
                0.0, -1.0,  0.0,

                1.0,  0.0,  0.0, /*   20; 4+ [ 1 0 0]  */
                0.0,  0.0, -1.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*   21; 4+ [ 0 1 0]  */
                0.0,  1.0,  0.0,
               -1.0,  0.0,  0.0,

                0.0,  0.0,  1.0, /*   22; 2  [ 1 0 1]  */
                0.0, -1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   23; 4- [ 0 1 0]  */
                0.0,  1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   24; 2  [-1 0 1]  */
                0.0, -1.0,  0.0,
               -1.0,  0.0,  0.0

};

/******   Td cubic group ******/
double Td_pgrp[24][3][3] = {
                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
   
                0.0,  0.0,  1.0, /*    5; 3+ [ 1 1 1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*    6; 3+ [-1 1-1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0, -1.0, /*    7; 3+ [ 1-1-1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0, -1.0, /*    8; 3+ [-1-1 1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  1.0,  0.0, /*    9; 3- [ 1 1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,

                0.0, -1.0,  0.0, /*   10; 3- [ 1-1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   11; 3- [-1-1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   12; 3- [-1 1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,

                0.0,  1.0,  0.0, /*   13; m   [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                0.0, -1.0,  0.0, /*   14; m   [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   15; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
     
                0.0, -1.0,  0.0, /*   16; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
  
                1.0,  0.0,  0.0, /*   17; m [ x y y]  */
                0.0,  0.0,  1.0,
                0.0,  1.0,  0.0,
     
               -1.0,  0.0,  0.0, /*   18; 4_+[ 1 0 0]  */
                0.0,  0.0,  1.0,
                0.0, -1.0,  0.0,
     
               -1.0,  0.0,  0.0, /*   19; 4_-[ 1 0 0]  */
                0.0,  0.0, -1.0,
                0.0,  1.0,  0.0,
     
                1.0,  0.0,  0.0, /*   20; m  [ x y-y]  */
                0.0,  0.0, -1.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0,  1.0, /*   21; m  [ x y x]  */
                0.0,  1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0,  1.0, /*   22; 4_-[ 0 1 0]  */
                0.0, -1.0,  0.0,
               -1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   23; m  [-x y x]  */
                0.0,  1.0,  0.0,
               -1.0,  0.0,  0.0,

                0.0,  0.0, -1.0, /*   24; 4_+[ 0 1 0]  */
                0.0, -1.0,  0.0,
                1.0,  0.0,  0.0
};
     
     /******   Oh cubic group ******/
double Oh_pgrp[48][3][3]= {

                1.0,  0.0,  0.0, /*    1; 1  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
   
               -1.0,  0.0,  0.0, /*    2; 2  [ 0 0 1]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*    3; 2  [ 0 1 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*    4; 2  [ 1 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
   
                0.0,  0.0,  1.0, /*    5; 3+ [ 1 1 1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*    6; 3+ [-1 1-1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  0.0, -1.0, /*    7; 3+ [ 1-1-1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,

                0.0,  0.0, -1.0, /*    8; 3+ [-1-1 1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,
     
                0.0,  1.0,  0.0, /*    9; 3- [ 1 1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,

                0.0, -1.0,  0.0, /*   10; 3- [ 1-1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   11; 3- [-1-1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   12; 3- [-1 1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,

                0.0,  1.0,  0.0, /*   13; 2  [ 1 1 0]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0, -1.0,  0.0, /*   14; 2  [ 1-1 0]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

                0.0,  1.0,  0.0, /*   15; 4- [ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
  
                0.0, -1.0,  0.0, /*   16; 4+ [ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,

                1.0,  0.0,  0.0, /*   17; 4- [ 1 0 0]  */
                0.0,  0.0,  1.0,
                0.0, -1.0,  0.0,

               -1.0,  0.0,  0.0, /*   18; 2  [ 0 1 1]  */
                0.0,  0.0,  1.0,
                0.0,  1.0,  0.0,

               -1.0,  0.0,  0.0, /*   19; 2  [ 0 1-1]  */
                0.0,  0.0, -1.0,
                0.0, -1.0,  0.0,

                1.0,  0.0,  0.0, /*   20; 4+ [ 1 0 0]  */
                0.0,  0.0, -1.0,
                0.0,  1.0,  0.0,

                0.0,  0.0,  1.0, /*   21; 4+ [ 0 1 0]  */
                0.0,  1.0,  0.0,
               -1.0,  0.0,  0.0,

                0.0,  0.0,  1.0, /*   22; 2  [ 1 0 1]  */
                0.0, -1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   23; 4- [ 0 1 0]  */
                0.0,  1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   24; 2  [-1 0 1]  */
                0.0, -1.0,  0.0,
               -1.0,  0.0,  0.0,
     
               -1.0,  0.0,  0.0, /*   25; 1_ [ 0 0 0]  */
                0.0, -1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   26; m  [ x y 0]  */
                0.0,  1.0,  0.0,
                0.0,  0.0, -1.0,
     
                1.0,  0.0,  0.0, /*   27; m  [ x 0 z]  */
                0.0, -1.0,  0.0,
                0.0,  0.0,  1.0,
     
               -1.0,  0.0,  0.0, /*   28; m  [ 0 y z]  */
                0.0,  1.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  0.0, -1.0, /*   29; 3_+ [ 1 1 1]  */
               -1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,

                0.0,  0.0, -1.0, /*   30; 3_+ [-1 1-1]  */
                1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,
     
                0.0,  0.0,  1.0, /*   31; 3_+ [ 1-1-1]  */
                1.0,  0.0,  0.0,
                0.0, -1.0,  0.0,

                0.0,  0.0,  1.0, /*   32; 3_+ [-1-1 1]  */
               -1.0,  0.0,  0.0,
                0.0,  1.0,  0.0,
     
                0.0, -1.0,  0.0, /*   33; 3_- [ 1 1 1]  */
                0.0,  0.0, -1.0,
               -1.0,  0.0,  0.0,

                0.0,  1.0,  0.0, /*   34; 3_- [ 1-1-1]  */
                0.0,  0.0, -1.0,
                1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   35; 3_- [-1-1 1]  */
                0.0,  0.0,  1.0,
                1.0,  0.0,  0.0,
     
                0.0,  1.0,  0.0, /*   36; 3_- [-1 1-1]  */
                0.0,  0.0,  1.0,
               -1.0,  0.0,  0.0,
     
                0.0, -1.0,  0.0, /*   37; m   [ x-x z]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
     
                0.0,  1.0,  0.0, /*   38; m   [ x x z]  */
                1.0,  0.0,  0.0,
                0.0,  0.0,  1.0,
  
                0.0, -1.0,  0.0, /*   39; 4_-[ 0 0 1]  */
                1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,
  
                0.0,  1.0,  0.0, /*   40; 4_+[ 0 0 1]  */
               -1.0,  0.0,  0.0,
                0.0,  0.0, -1.0,

               -1.0,  0.0,  0.0, /*   41; 4_-[ 1 0 0]  */
                0.0,  0.0, -1.0,
                0.0,  1.0,  0.0,
     
                1.0,  0.0,  0.0, /*   42; m  [ x y-y]  */
                0.0,  0.0, -1.0,
                0.0, -1.0,  0.0,
     
                1.0,  0.0,  0.0, /*   43; m [ x y y]  */
                0.0,  0.0,  1.0,
                0.0,  1.0,  0.0,
     
               -1.0,  0.0,  0.0, /*   44; 4_+[ 1 0 0]  */
                0.0,  0.0,  1.0,
                0.0, -1.0,  0.0,

                0.0,  0.0, -1.0, /*   45; 4_+[ 0 1 0]  */
                0.0, -1.0,  0.0,
                1.0,  0.0,  0.0,
     
                0.0,  0.0, -1.0, /*   46; m  [-x y x]  */
                0.0,  1.0,  0.0,
               -1.0,  0.0,  0.0,
     
                0.0,  0.0,  1.0, /*   47; 4_-[ 0 1 0]  */
                0.0, -1.0,  0.0,
               -1.0,  0.0,  0.0,
     
                0.0,  0.0,  1.0, /*   48; m  [ x y x]  */
                0.0,  1.0,  0.0,
                1.0,  0.0,  0.0
};

