/*
 *   Copyright (C) 2007 Ivan Cukic <ivan.cukic+kde@gmail.com>
 *   Copyright (C) 2008-2010 Daniel Nicoletti <dantti12@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library/Lesser General Public License
 *   version 2, or (at your option) any later version, as published by the
 *   Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library/Lesser General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef PRINTER_DELEGATE_H
#define PRINTER_DELEGATE_H

#include <QApplication>
#include <QtGui/QStyledItemDelegate>

class QPainter;

/**
 * Delegate for displaying the printers
 */
class PrinterDelegate: public QStyledItemDelegate
{
    Q_OBJECT

public:
    explicit PrinterDelegate(QObject *parent = 0);

    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

private:
    int m_favIconSize;
    int m_emblemIconSize;
    int m_universalPadding;
    int m_fadeLength;
    int m_mainIconSize;
    int calcItemHeight(const QStyleOptionViewItem &option) const;
};

#endif
