
/* Web Polygraph       http://www.web-polygraph.org/
 * Copyright 2003-2011 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__CSM_RANGEBODYITER_H
#define POLYGRAPH__CSM_RANGEBODYITER_H

#include "csm/BodyIter.h"

// BodyIter for range requests.
// Both single and multi range are supported.
// Body content is generated by theProducer BodyIter.
class RangeBodyIter: public BodyIter {
	public:
		RangeBodyIter(const RangeList &ranges, BodyIter *const aProducer);
		virtual RangeBodyIter *clone() const;

		virtual void start(WrBuf *aBuf);
		virtual void stop();

		virtual bool pour();

		virtual Size fullEntitySize() const;

	protected:
		virtual bool pourBody();
		virtual void putHeaders(ostream &os) const;
		bool pourRange(Size &first, const Size &last);
		void putRangeHeaders();
		void putTerminator();
		bool multiRange() const;

		const RangeList &theRanges;
		BodyIter *theProducer;
		WrBuf theProducerBuf;
		Size theProducerOffset;
		Size theCurrRangeOffset;
		bool putPartHeader;
		RangeList::const_iterator theCurrRange;
};

#endif
