// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                          avtparaDISFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_paraDIS_FILE_FORMAT_H
#define AVT_paraDIS_FILE_FORMAT_H

#include "paraDIS_lib/paradis_c_interface.h"
#include "parallelParaDIS.h"
#include "Dumpfile.h"
#include <avtSTSDFileFormat.h>
#include "avtparaDISOptions.h"
#include <vtkUnstructuredGrid.h>
#include <vtkFloatArray.h>
#include "RC_cpp_lib/Point.h"
#include <vector>
// ****************************************************************************
//  Class: avtparaDISFileFormat
//
//  Purpose:
//      Reads in paraDIS files as a plugin to VisIt.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Tue Jan 30 14:56:34 PST 2007
//
// ****************************************************************************

#define PARADIS_NO_FORMAT 0  // uninitialized
#define PARADIS_DUMPFILE_FORMAT 1  // Old serial data format
#define PARADIS_PARALLEL_FORMAT 2  // new parallel data format


class avtparaDISFileFormat : public avtSTSDFileFormat
{
  public:
                       avtparaDISFileFormat(const char *filename,
                                            DBOptionsAttributes *rdatts);
    virtual           ~avtparaDISFileFormat() {;};


 
    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    // virtual void      *GetAuxiliaryData(const char *var, const char *type,
    //                                  void *args, DestructorFunction &);
    //

    //
    // These are used to declare what the current time and cycle are for the
    // file.  These should only be defined if the file format knows what the
    // time and/or cycle is.
    //
    // virtual int       GetCycle(void);
    // virtual double    GetTime(void);
    //
    
    virtual const char    *GetType(void)   { return "paraDIS"; };
    virtual void           FreeUpResources(void); 
    
    void Clear(void); 
    
    // These would tell the parent class to call PopulateDatabaseMetadata() for each timestep.  I decided against it. 
    //  virtual bool HasInvariantMetaData(void) const { return false; };
    //  virtual bool HasInvariantSIL(void)      const { return false; };

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);
    bool PopulateMetaDataSerialFormat(avtDatabaseMetaData *md); 
    bool PopulateMetaDataParallelFormat(avtDatabaseMetaData *md); 

    virtual vtkDataSet    *GetMesh(const char *meshname);
    vtkDataSet    *GetMeshSerialFormat(const char *meshname);
    vtkDataSet    *GetMeshParallelFormat(const char *meshname);

    virtual vtkDataArray  *GetVar(const char *);
    virtual vtkDataArray  *GetVectorVar(const char *);
    virtual void          *GetAuxiliaryData(const char *var, const char *type, 
                                            void *args, DestructorFunction &);

  protected:
    // DATA MEMBERS
    std::string mFilename; 
    int mFormat; 
    int mVerbosity; 
    

    /*!
      paraDIS data PARALLEL
    */
    ParallelData mParallelData; 
    Dumpfile mDumpfile; 

};


#endif
