/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.vrml97;

import java.io.IOException;
import java.io.Reader;
import org.web3d.parser.vrml97.ParseException;
import org.web3d.parser.vrml97.VRML97RelaxedParser;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.parser.BaseReader;
import org.web3d.vrml.parser.VRMLParserUtils;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.VRMLParseException;

public class VRML97Reader
extends BaseReader {
    private VRML97RelaxedParser relaxedParser;

    public void parse(InputSource inputSource) throws IOException, VRMLException {
        String string = (String)this.properties.get("conformance");
        if (string.equals("weak")) {
            this.parseWeakly(inputSource);
        } else if (string.equals("strict")) {
            this.parseStrictly(inputSource);
        }
    }

    private void parseWeakly(InputSource inputSource) throws IOException, VRMLException {
        String[] stringArray;
        Reader reader = inputSource.getCharacterStream();
        if (!this.ignoreHeader) {
            stringArray = VRMLParserUtils.parseFileHeader(reader);
            if (stringArray.length != 4) {
                throw new VRMLParseException(1, 1, "Header missing #VRML statement");
            }
            if (!stringArray[0].equals("#VRML")) {
                throw new VRMLParseException(1, 1, "Invalid header. Not a vrml file");
            }
            if (stringArray[1] == null || !stringArray[1].equals("V2.0")) {
                throw new VRMLParseException(1, 1, "Unsupported version " + stringArray[1]);
            }
            if (stringArray[2] == null || !stringArray[2].equals("utf8")) {
                throw new VRMLParseException(1, 1, "Unsupported encoding " + stringArray[2]);
            }
        } else {
            stringArray = new String[4];
            stringArray[0] = "#VRML";
            stringArray[1] = "V2.0";
            stringArray[2] = "utf8";
        }
        if (this.relaxedParser == null) {
            this.relaxedParser = new VRML97RelaxedParser(reader);
            this.relaxedParser.initialize();
        } else {
            this.relaxedParser.ReInit(reader);
        }
        this.relaxedParser.setContentHandler(this.contentHandler);
        this.relaxedParser.setRouteHandler(this.routeHandler);
        this.relaxedParser.setScriptHandler(this.scriptHandler);
        this.relaxedParser.setProtoHandler(this.protoHandler);
        this.relaxedParser.setErrorReporter(this.errorHandler);
        String string = inputSource.getBaseURL();
        String string2 = inputSource.getURL();
        if (string2 == null) {
            string2 = "Unknown URL source. Base URL is " + string;
        }
        this.relaxedParser.setDocumentUrl(string2);
        Locator locator = this.relaxedParser.getDocumentLocator();
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
            this.contentHandler.startDocument(string2, string, stringArray[2], stringArray[0], stringArray[1], stringArray[3]);
        }
        try {
            this.relaxedParser.Scene();
            if (this.contentHandler != null) {
                this.contentHandler.endDocument();
            }
        }
        catch (ParseException parseException) {
            throw new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), parseException.getMessage());
        }
    }

    private void parseStrictly(InputSource inputSource) throws IOException, SAVException {
        throw new SAVNotSupportedException("Strict parsing not implemented yet");
    }
}

