/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input.dis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import mil.navy.nps.dis.EntityStatePdu;
import mil.navy.nps.dis.ProtocolDataUnit;
import mil.navy.nps.math.Quaternion;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.PropertyTools;
import org.web3d.vrml.nodes.NetworkRoleListener;
import org.web3d.vrml.nodes.VRMLDISManagerNodeType;
import org.web3d.vrml.nodes.VRMLDISNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNetworkInterfaceNodeType;
import org.web3d.vrml.renderer.common.input.dis.DISConnectionHandler;
import org.web3d.vrml.renderer.common.input.dis.DISConnectionId;
import org.web3d.vrml.renderer.common.input.dis.DISId;
import org.web3d.vrml.renderer.common.input.dis.LinkedList;
import org.web3d.vrml.renderer.common.input.dis.LiveListEntry;
import org.web3d.vrml.renderer.common.input.dis.NodeMapEntry;
import org.web3d.vrml.renderer.common.input.dis.OrderNQuat4dConverger;
import org.web3d.vrml.renderer.common.input.dis.OrderNVector3dConverger;
import org.web3d.vrml.renderer.common.input.dis.RungeKuttaSolver;
import org.web3d.vrml.renderer.common.input.dis.WriterListEntry;
import org.web3d.vrml.renderer.common.input.dis.WriterMapEntry;
import org.xj3d.core.eventmodel.NetworkProtocolHandler;

public class DISProtocolHandler
implements NetworkProtocolHandler,
NetworkRoleListener {
    private static final String PROTOCOL = "DIS";
    private static final int INACTIVE_CHECK_TIME = 1000;
    private static final int INACTIVE_TIME = 5000;
    private static final int HEARTBEAT_CHECK_TIME = 4500;
    private static final int DEFAULT_ORDER = 2;
    private static final int DEFAULT_CONVERGENCE_INTERVAL = 200;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private HashMap connections = new HashMap();
    private Map nodeMap = Collections.synchronizedMap(new HashMap());
    private Map writerMap = Collections.synchronizedMap(new HashMap());
    private LinkedList liveList = new LinkedList();
    private LinkedList writerList = new LinkedList();
    private long lastCheck;
    private long lastHeartCheck;
    private List managerList = Collections.synchronizedList(new ArrayList());
    private Set notifiedSet = Collections.synchronizedSet(new HashSet());
    private DISId disId = new DISId(0, 0, 0);
    float[] tempPositionArray = new float[3];
    float[] tempPositionArray2 = new float[3];
    float[] goalOrientation = new float[3];
    private Quaternion quaternion = null;
    private float[] rotation = new float[4];
    private float[] currOrientation;
    private float[] positionArray;
    private boolean smooth = true;
    protected static final boolean DEFAULT_DEADRECKON_POSITION = true;
    protected static final String DEADRECKON_POSITION_PROP = "org.web3d.vrml.renderer.common.dis.input.deadreckonPosition";
    protected static final boolean deadreckonPosition = PropertyTools.fetchSystemProperty("org.web3d.vrml.renderer.common.dis.input.deadreckonPosition", true);
    protected static final boolean DEFAULT_DEADRECKON_ROTATION = true;
    protected static final String DEADRECKON_ROTATION_PROP = "org.web3d.vrml.renderer.common.dis.input.deadreckonRotation";
    protected static final boolean deadreckonRotation = PropertyTools.fetchSystemProperty("org.web3d.vrml.renderer.common.dis.input.deadreckonRotation", true);
    Matrix3d rotationMatrix;
    Matrix3d psiMat;
    Matrix3d thetaMat;
    Matrix3d phiMat;
    Quat4d rotationQuat;
    Vector3d translationVec;
    Vector3d[] translationDerivatives;
    Vector3d[] rotationDerivatives;
    RungeKuttaSolver solver;
    AxisAngle4d axisTemp;

    public DISProtocolHandler() {
        this.quaternion = new Quaternion();
        this.positionArray = new float[3];
        this.currOrientation = new float[3];
        this.rotationMatrix = new Matrix3d();
        this.psiMat = new Matrix3d();
        this.thetaMat = new Matrix3d();
        this.phiMat = new Matrix3d();
        this.rotationQuat = new Quat4d();
        this.translationVec = new Vector3d();
        this.translationDerivatives = new Vector3d[]{new Vector3d(), new Vector3d()};
        this.rotationDerivatives = new Vector3d[]{new Vector3d()};
        this.axisTemp = new AxisAngle4d();
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void processNetworkTraffic() {
        Object object;
        Object object2;
        VRMLDISNodeType vRMLDISNodeType;
        long l = System.currentTimeMillis();
        boolean bl = l - this.lastCheck >= 1000L;
        LiveListEntry liveListEntry = (LiveListEntry)this.liveList.head;
        LiveListEntry liveListEntry2 = (LiveListEntry)this.liveList.head;
        int n = 0;
        while (liveListEntry != null) {
            vRMLDISNodeType = liveListEntry.node;
            if (liveListEntry.newPackets) {
                if (liveListEntry.currFire != null) {
                    vRMLDISNodeType.packetArrived(liveListEntry.currFire);
                    liveListEntry.currFire = null;
                } else if (liveListEntry.currDetonate != null) {
                    vRMLDISNodeType.packetArrived(liveListEntry.currDetonate);
                    liveListEntry.closeEnough = true;
                    liveListEntry.currDetonate = null;
                } else if (liveListEntry.currEspdu != null) {
                    vRMLDISNodeType.packetArrived((ProtocolDataUnit)liveListEntry.currEspdu);
                    EntityStatePdu entityStatePdu = liveListEntry.currEspdu;
                    this.rotationMatrix.setIdentity();
                    this.eulersToMatrix(entityStatePdu.getEntityOrientationPhi(), entityStatePdu.getEntityOrientationTheta(), entityStatePdu.getEntityOrientationPsi(), this.rotationMatrix);
                    this.rotationQuat.set(this.rotationMatrix);
                    object2 = new Vector3d(entityStatePdu.getEntityLocationX(), -entityStatePdu.getEntityLocationZ(), entityStatePdu.getEntityLocationY());
                    this.translationDerivatives[0].set(entityStatePdu.getEntityLinearVelocityX(), -entityStatePdu.getEntityLinearVelocityZ(), entityStatePdu.getEntityLinearVelocityY());
                    this.rotationDerivatives[0].set(entityStatePdu.getEntityAngularVelocityX(), -entityStatePdu.getEntityAngularVelocityZ(), entityStatePdu.getEntityAngularVelocityY());
                    this.translationDerivatives[1].set(entityStatePdu.getEntityLinearAccelerationX(), -entityStatePdu.getEntityLinearAccelerationZ(), entityStatePdu.getEntityLinearAccelerationY());
                    liveListEntry.translationConverger.convergeTo((Vector3d)object2, this.translationDerivatives, l, l);
                    liveListEntry.rotationConverger.convergeTo(this.rotationQuat, this.rotationDerivatives, l, l);
                }
                liveListEntry.newPackets = false;
                ++n;
            }
            if (bl && l - liveListEntry.lastTime >= 5000L) {
                liveListEntry.node.setIsActive(false);
                this.liveList.remove(liveListEntry, liveListEntry2);
                int n2 = vRMLDISNodeType.getSiteID();
                int n3 = vRMLDISNodeType.getAppID();
                int n4 = vRMLDISNodeType.getEntityID();
                this.disId.setValue(n2, n3, n4);
                object = (NodeMapEntry)this.nodeMap.get(this.disId);
                if (object == null) {
                    System.out.println("DIS Entry null on timeout");
                } else {
                    ((NodeMapEntry)object).listEntry = null;
                    int n5 = this.managerList.size();
                    for (int i = 0; i < n5; ++i) {
                        VRMLDISManagerNodeType vRMLDISManagerNodeType = (VRMLDISManagerNodeType)this.managerList.get(i);
                        vRMLDISManagerNodeType.entityRemoved(vRMLDISNodeType);
                        this.notifiedSet.remove(this.disId);
                    }
                }
            }
            if ((deadreckonPosition || deadreckonRotation) && !liveListEntry.closeEnough) {
                float f = (float)(l - liveListEntry.lastTime) * 0.001f;
                if ((double)Math.abs(liveListEntry.currEspdu.getEntityLinearVelocityX()) <= 1.0E-4 && (double)Math.abs(liveListEntry.currEspdu.getEntityLinearVelocityY()) <= 1.0E-4 && (double)Math.abs(liveListEntry.currEspdu.getEntityLinearVelocityZ()) <= 1.0E-4 && (double)Math.abs(liveListEntry.currEspdu.getEntityLinearAccelerationX()) <= 1.0E-4 && (double)Math.abs(liveListEntry.currEspdu.getEntityLinearAccelerationY()) <= 1.0E-4 && (double)Math.abs(liveListEntry.currEspdu.getEntityLinearAccelerationZ()) <= 1.0E-4) {
                    liveListEntry.closeEnough = true;
                }
                if (deadreckonPosition) {
                    liveListEntry.translationConverger.getValue(l, this.translationVec);
                    this.tempPositionArray[0] = (float)this.translationVec.x;
                    this.tempPositionArray[1] = (float)this.translationVec.y;
                    this.tempPositionArray[2] = (float)this.translationVec.z;
                    int n6 = vRMLDISNodeType.getFieldIndex("translation");
                    vRMLDISNodeType.setValue(n6, this.tempPositionArray, 3);
                }
                if (deadreckonRotation) {
                    liveListEntry.rotationConverger.getValue(l, this.rotationQuat);
                    this.rotationQuat.normalize();
                    this.axisTemp.set(this.rotationQuat);
                    this.rotation[0] = (float)this.axisTemp.x;
                    this.rotation[1] = (float)this.axisTemp.y;
                    this.rotation[2] = (float)this.axisTemp.z;
                    this.rotation[3] = (float)this.axisTemp.angle;
                    int n7 = vRMLDISNodeType.getFieldIndex("rotation");
                    vRMLDISNodeType.setValue(n7, this.rotation, 4);
                }
                liveListEntry.prevDt = f;
            }
            liveListEntry2 = liveListEntry;
            liveListEntry = (LiveListEntry)liveListEntry.next;
        }
        if (bl) {
            this.lastCheck = l;
        }
        object2 = (WriterListEntry)this.writerList.head;
        WriterListEntry writerListEntry = (WriterListEntry)this.writerList.head;
        while (object2 != null) {
            ProtocolDataUnit protocolDataUnit;
            vRMLDISNodeType = ((WriterListEntry)object2).node;
            if (vRMLDISNodeType.valuesToWrite()) {
                ((WriterListEntry)object2).lastTime = l;
                protocolDataUnit = vRMLDISNodeType.getState();
                this.disId.setValue(vRMLDISNodeType.getSiteID(), vRMLDISNodeType.getAppID(), vRMLDISNodeType.getEntityID());
                object = (WriterMapEntry)this.writerMap.get(this.disId);
                ((WriterMapEntry)object).writer.write(protocolDataUnit);
            } else if (l - ((WriterListEntry)object2).lastTime >= 4500L) {
                ((WriterListEntry)object2).lastTime = l;
                protocolDataUnit = vRMLDISNodeType.getState();
                this.disId.setValue(vRMLDISNodeType.getSiteID(), vRMLDISNodeType.getAppID(), vRMLDISNodeType.getEntityID());
                object = (WriterMapEntry)this.writerMap.get(this.disId);
                ((WriterMapEntry)object).writer.write(protocolDataUnit);
            }
            writerListEntry = object2;
            object2 = (WriterListEntry)((WriterListEntry)object2).next;
        }
    }

    public void addNode(VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType) {
        VRMLDISNodeType vRMLDISNodeType = (VRMLDISNodeType)vRMLNetworkInterfaceNodeType;
        vRMLDISNodeType.addNetworkRoleListener(this);
        switch (vRMLDISNodeType.getRole()) {
            case 3: {
                String string = vRMLDISNodeType.getAddress();
                int n = vRMLDISNodeType.getPort();
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISConnectionHandler dISConnectionHandler = (DISConnectionHandler)this.connections.get(dISConnectionId);
                if (dISConnectionHandler == null) {
                    dISConnectionHandler = new DISConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n);
                    this.connections.put(dISConnectionId, dISConnectionHandler);
                }
                int n2 = vRMLDISNodeType.getSiteID();
                int n3 = vRMLDISNodeType.getAppID();
                int n4 = vRMLDISNodeType.getEntityID();
                this.managerList.add(vRMLDISNodeType);
                break;
            }
            case 0: {
                String string = vRMLDISNodeType.getAddress();
                int n = vRMLDISNodeType.getPort();
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISConnectionHandler dISConnectionHandler = (DISConnectionHandler)this.connections.get(dISConnectionId);
                if (dISConnectionHandler == null) {
                    dISConnectionHandler = new DISConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n);
                    this.connections.put(dISConnectionId, dISConnectionHandler);
                }
                int n5 = vRMLDISNodeType.getSiteID();
                int n6 = vRMLDISNodeType.getAppID();
                int n7 = vRMLDISNodeType.getEntityID();
                int n8 = vRMLNetworkInterfaceNodeType.getFieldIndex("marking");
                VRMLFieldData vRMLFieldData = vRMLNetworkInterfaceNodeType.getFieldValue(n8);
                System.out.println("New DIS node: siteID: " + n5 + " appID: " + n6 + " " + " entityID: " + n7 + " marking: " + vRMLFieldData.stringValue);
                DISId dISId = new DISId(n5, n6, n7);
                this.nodeMap.put(dISId, new NodeMapEntry((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, null));
                WriterListEntry writerListEntry = new WriterListEntry(vRMLDISNodeType);
                WriterMapEntry writerMapEntry = new WriterMapEntry((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, writerListEntry, dISConnectionHandler.getWriter());
                this.writerMap.put(dISId, writerMapEntry);
                break;
            }
            case 1: {
                String string = vRMLDISNodeType.getAddress();
                int n = vRMLDISNodeType.getPort();
                DISConnectionId dISConnectionId = new DISConnectionId(string, n);
                DISConnectionHandler dISConnectionHandler = (DISConnectionHandler)this.connections.get(dISConnectionId);
                if (dISConnectionHandler == null) {
                    dISConnectionHandler = new DISConnectionHandler(this.nodeMap, this.liveList, this.managerList, this.notifiedSet, string, n);
                    this.connections.put(dISConnectionId, dISConnectionHandler);
                }
                int n9 = vRMLDISNodeType.getSiteID();
                int n10 = vRMLDISNodeType.getAppID();
                int n11 = vRMLDISNodeType.getEntityID();
                DISId dISId = new DISId(n9, n10, n11);
                WriterListEntry writerListEntry = new WriterListEntry(vRMLDISNodeType);
                WriterMapEntry writerMapEntry = new WriterMapEntry((VRMLDISNodeType)vRMLNetworkInterfaceNodeType, writerListEntry, dISConnectionHandler.getWriter());
                this.writerMap.put(dISId, writerMapEntry);
                this.writerList.add(writerListEntry);
                break;
            }
            case 2: {
                System.out.println("Logic to change Inactive to Writer not implemented");
            }
        }
    }

    public void removeNode(VRMLNetworkInterfaceNodeType vRMLNetworkInterfaceNodeType) {
        System.out.println("DISProtocolHandler: removeNode not implemented");
    }

    public void clear() {
        if (this.connections.size() > 0) {
            System.out.println("DISProtocolHandler: clear not implemented");
        }
    }

    public void shutdown() {
        if (this.connections.size() > 0) {
            System.out.println("DISProtocolHandler: shutdown not implemented");
        }
    }

    public void roleChanged(int n, Object object) {
        VRMLDISNodeType vRMLDISNodeType = (VRMLDISNodeType)object;
        long l = System.currentTimeMillis();
        switch (n) {
            case 2: {
                break;
            }
            case 0: {
                EntityStatePdu entityStatePdu;
                WriterListEntry writerListEntry = (WriterListEntry)this.writerList.head;
                WriterListEntry writerListEntry2 = (WriterListEntry)this.writerList.head;
                while (writerListEntry != null) {
                    if (writerListEntry.node == vRMLDISNodeType) {
                        this.writerList.remove(writerListEntry, writerListEntry2);
                        break;
                    }
                    writerListEntry2 = writerListEntry;
                    writerListEntry = (WriterListEntry)writerListEntry.next;
                }
                NodeMapEntry nodeMapEntry = new NodeMapEntry(vRMLDISNodeType, null);
                this.nodeMap.put(this.disId.clone(), nodeMapEntry);
                LiveListEntry liveListEntry = new LiveListEntry(vRMLDISNodeType, l);
                nodeMapEntry.listEntry = liveListEntry;
                liveListEntry.lastEspdu = entityStatePdu = (EntityStatePdu)vRMLDISNodeType.getState();
                liveListEntry.currEspdu = entityStatePdu;
                liveListEntry.rotationConverger = new OrderNQuat4dConverger(2, 200, null);
                liveListEntry.translationConverger = new OrderNVector3dConverger(2, 200, null);
                liveListEntry.espduTimestamp = entityStatePdu.getTimestamp().longValue();
                liveListEntry.closeEnough = false;
                liveListEntry.avgTime = 0.01f;
                liveListEntry.newPackets = true;
                this.liveList.add(liveListEntry);
                break;
            }
            case 1: {
                LiveListEntry liveListEntry = (LiveListEntry)this.liveList.head;
                LiveListEntry liveListEntry2 = (LiveListEntry)this.liveList.head;
                while (liveListEntry != null) {
                    if (liveListEntry.node == vRMLDISNodeType) {
                        this.liveList.remove(liveListEntry, liveListEntry2);
                        break;
                    }
                    liveListEntry2 = liveListEntry;
                    liveListEntry = (LiveListEntry)liveListEntry.next;
                }
                WriterListEntry writerListEntry = new WriterListEntry(vRMLDISNodeType);
                this.writerList.add(writerListEntry);
            }
        }
    }

    private void DRPosition(EntityStatePdu entityStatePdu, float f, float[] fArray) {
        float f2 = f * f;
        fArray[0] = (float)(entityStatePdu.getEntityLocationX() + (double)(f * entityStatePdu.getEntityLinearVelocityX()) + (double)(f2 * entityStatePdu.getEntityLinearAccelerationX()));
        fArray[1] = (float)(-entityStatePdu.getEntityLocationZ() - (double)(f * entityStatePdu.getEntityLinearVelocityZ()) - (double)(f2 * entityStatePdu.getEntityLinearAccelerationZ()));
        fArray[2] = (float)(entityStatePdu.getEntityLocationY() + (double)(f * entityStatePdu.getEntityLinearVelocityY()) + (double)(f2 * entityStatePdu.getEntityLinearAccelerationY()));
    }

    private void DROrientation(EntityStatePdu entityStatePdu, float f, float[] fArray) {
        float f2 = entityStatePdu.getEntityOrientationPhi() + f * entityStatePdu.getEntityAngularVelocityX();
        float f3 = entityStatePdu.getEntityOrientationTheta() + f * entityStatePdu.getEntityAngularVelocityY();
        float f4 = entityStatePdu.getEntityOrientationPsi() + f * entityStatePdu.getEntityAngularVelocityZ();
        fArray[0] = -f4;
        fArray[1] = f2;
        fArray[2] = f3;
    }

    private void smooth3Floats(float[] fArray, float[] fArray2, float[] fArray3, float f, float f2) {
        fArray3[0] = (fArray2[0] + fArray[0]) / 2.0f;
        fArray3[1] = (fArray2[1] + fArray[1]) / 2.0f;
        fArray3[2] = (fArray2[2] + fArray[2]) / 2.0f;
    }

    private float normalize2(float f) {
        float f2 = f;
        float f3 = (float)Math.PI * 2;
        while ((double)f2 > Math.PI) {
            f2 -= f3;
        }
        while ((double)f2 <= -Math.PI) {
            f2 += f3;
        }
        return f2;
    }

    private void fixEulers(float[] fArray, float[] fArray2) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = fArray2[i] + this.normalize2(this.normalize2(fArray[i]) - this.normalize2(fArray2[i]));
        }
    }

    private float SqrDeltaFloats(float[] fArray, float[] fArray2) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += (fArray[i] - fArray2[i]) * (fArray[i] - fArray2[i]);
        }
        return f;
    }

    private void eulersToMatrix(double d, double d2, double d3, Matrix3d matrix3d) {
        this.psiMat.setIdentity();
        this.psiMat.rotY(-d3);
        this.thetaMat.rotZ(d2);
        this.phiMat.rotX(d);
        matrix3d.mul(this.phiMat, this.thetaMat);
        matrix3d.mul(this.psiMat);
    }
}

