// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
)

type AttachNetworkInterfaceRequest struct {

    core.JDCloudRequest

    /* 地域ID  */
    RegionId string `json:"regionId"`

    /* 云主机ID  */
    InstanceId string `json:"instanceId"`

    /* 弹性网卡ID  */
    NetworkInterfaceId string `json:"networkInterfaceId"`

    /* 随主机自动删除，默认为False (Optional) */
    AutoDelete *bool `json:"autoDelete"`
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 * param networkInterfaceId: 弹性网卡ID (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewAttachNetworkInterfaceRequest(
    regionId string,
    instanceId string,
    networkInterfaceId string,
) *AttachNetworkInterfaceRequest {

	return &AttachNetworkInterfaceRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/instances/{instanceId}:attachNetworkInterface",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        InstanceId: instanceId,
        NetworkInterfaceId: networkInterfaceId,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param instanceId: 云主机ID (Required)
 * param networkInterfaceId: 弹性网卡ID (Required)
 * param autoDelete: 随主机自动删除，默认为False (Optional)
 */
func NewAttachNetworkInterfaceRequestWithAllParams(
    regionId string,
    instanceId string,
    networkInterfaceId string,
    autoDelete *bool,
) *AttachNetworkInterfaceRequest {

    return &AttachNetworkInterfaceRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:attachNetworkInterface",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        InstanceId: instanceId,
        NetworkInterfaceId: networkInterfaceId,
        AutoDelete: autoDelete,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewAttachNetworkInterfaceRequestWithoutParam() *AttachNetworkInterfaceRequest {

    return &AttachNetworkInterfaceRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/instances/{instanceId}:attachNetworkInterface",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: 地域ID(Required) */
func (r *AttachNetworkInterfaceRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param instanceId: 云主机ID(Required) */
func (r *AttachNetworkInterfaceRequest) SetInstanceId(instanceId string) {
    r.InstanceId = instanceId
}

/* param networkInterfaceId: 弹性网卡ID(Required) */
func (r *AttachNetworkInterfaceRequest) SetNetworkInterfaceId(networkInterfaceId string) {
    r.NetworkInterfaceId = networkInterfaceId
}

/* param autoDelete: 随主机自动删除，默认为False(Optional) */
func (r *AttachNetworkInterfaceRequest) SetAutoDelete(autoDelete bool) {
    r.AutoDelete = &autoDelete
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r AttachNetworkInterfaceRequest) GetRegionId() string {
    return r.RegionId
}

type AttachNetworkInterfaceResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result AttachNetworkInterfaceResult `json:"result"`
}

type AttachNetworkInterfaceResult struct {
}