# progress.py
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import time

# Given a message and a callback, calls the callback as
# callback(message, percent) when it itself is called, but at regular
# time intervals.
class ProgressUpdater:
    # "update_interval" is in seconds
    def __init__(self, message, callback, update_interval=0.1):
        self.message=message
        self.callback=callback
        self.update_interval=update_interval
        self.last_update=None

    def __call__(self, cur, max):
        t=time.time()
        if self.last_update==None or cur==0 or (cur==max and cur <> None) or t-self.last_update>self.update_interval:
            self.last_update=t

            if cur==None:
                percent=None
            elif max==0:
                percent=1
            else:
                percent=float(cur)/float(max)

            self.callback(self.message, percent)
