/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "ftpd.h"

void shmem_finish(int shmemnum)
{
	struct shmid_ds buffer;
	if (shmemnum != -1)
	{
		if (shmctl(shmemnum, IPC_RMID, &buffer) == -1);
/*		close(shmem_lockfd); */
	}
}

void *shmem_get(char *ipcfile, int size, int *shmemnum, int *isnew, int *lockfd)
{
	key_t ipckey = ftok(ipcfile, '/');
	void *shmemarea;

	*isnew = TRUE;
	*shmemnum = shmget(ipckey, size, 
				IPC_CREAT | IPC_EXCL | 0600);
	if (*shmemnum == -1)
	{
		*isnew = FALSE;
		*shmemnum = shmget(ipckey, size, 
					IPC_CREAT |/* IPC_EXCL |*/ 0600);
	}
	if (*shmemnum == -1)
		ERRORMSGFATAL(strerror(errno));

	shmemarea = shmat(*shmemnum, NULL, 0);
	
	/* get semaphores. Using the config file so others can join in (we use file locks for portability, simplicity
	   and usability. */
	
	*lockfd = open(ipcfile, O_RDWR);
	if (*lockfd == -1)
		ERRORMSGFATAL(strerror(errno));
	return(shmemarea);
}
