/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type size_t = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME:
    StdVideoH264ChromaFormatIdc = 0;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_420:
    StdVideoH264ChromaFormatIdc = 1;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_422:
    StdVideoH264ChromaFormatIdc = 2;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_444:
    StdVideoH264ChromaFormatIdc = 3;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID:
    StdVideoH264ChromaFormatIdc = 2147483647;
pub type StdVideoH264ChromaFormatIdc = ::std::os::raw::c_uint;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_BASELINE: StdVideoH264ProfileIdc = 66;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_MAIN: StdVideoH264ProfileIdc = 77;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH: StdVideoH264ProfileIdc = 100;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE:
    StdVideoH264ProfileIdc = 244;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_INVALID: StdVideoH264ProfileIdc =
    2147483647;
pub type StdVideoH264ProfileIdc = ::std::os::raw::c_uint;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_0: StdVideoH264Level = 0;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_1: StdVideoH264Level = 1;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_2: StdVideoH264Level = 2;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_3: StdVideoH264Level = 3;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_0: StdVideoH264Level = 4;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_1: StdVideoH264Level = 5;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_2: StdVideoH264Level = 6;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_0: StdVideoH264Level = 7;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_1: StdVideoH264Level = 8;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_2: StdVideoH264Level = 9;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_0: StdVideoH264Level = 10;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_1: StdVideoH264Level = 11;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_2: StdVideoH264Level = 12;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_0: StdVideoH264Level = 13;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_1: StdVideoH264Level = 14;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_2: StdVideoH264Level = 15;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_0: StdVideoH264Level = 16;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_1: StdVideoH264Level = 17;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_2: StdVideoH264Level = 18;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_INVALID: StdVideoH264Level = 2147483647;
pub type StdVideoH264Level = ::std::os::raw::c_uint;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_0: StdVideoH264PocType = 0;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_1: StdVideoH264PocType = 1;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_2: StdVideoH264PocType = 2;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_INVALID: StdVideoH264PocType = 2147483647;
pub type StdVideoH264PocType = ::std::os::raw::c_uint;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED:
    StdVideoH264AspectRatioIdc = 0;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE:
    StdVideoH264AspectRatioIdc = 1;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11:
    StdVideoH264AspectRatioIdc = 2;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11:
    StdVideoH264AspectRatioIdc = 3;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11:
    StdVideoH264AspectRatioIdc = 4;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33:
    StdVideoH264AspectRatioIdc = 5;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11:
    StdVideoH264AspectRatioIdc = 6;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11:
    StdVideoH264AspectRatioIdc = 7;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11:
    StdVideoH264AspectRatioIdc = 8;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33:
    StdVideoH264AspectRatioIdc = 9;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11:
    StdVideoH264AspectRatioIdc = 10;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11:
    StdVideoH264AspectRatioIdc = 11;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33:
    StdVideoH264AspectRatioIdc = 12;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99:
    StdVideoH264AspectRatioIdc = 13;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3:
    StdVideoH264AspectRatioIdc = 14;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2:
    StdVideoH264AspectRatioIdc = 15;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1:
    StdVideoH264AspectRatioIdc = 16;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR:
    StdVideoH264AspectRatioIdc = 255;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID:
    StdVideoH264AspectRatioIdc = 2147483647;
pub type StdVideoH264AspectRatioIdc = ::std::os::raw::c_uint;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT:
    StdVideoH264WeightedBipredIdc = 0;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT:
    StdVideoH264WeightedBipredIdc = 1;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT:
    StdVideoH264WeightedBipredIdc = 2;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID:
    StdVideoH264WeightedBipredIdc = 2147483647;
pub type StdVideoH264WeightedBipredIdc = ::std::os::raw::c_uint;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT : StdVideoH264ModificationOfPicNumsIdc = 0 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD : StdVideoH264ModificationOfPicNumsIdc = 1 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM : StdVideoH264ModificationOfPicNumsIdc = 2 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END:
    StdVideoH264ModificationOfPicNumsIdc = 3;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID : StdVideoH264ModificationOfPicNumsIdc = 2147483647 ;
pub type StdVideoH264ModificationOfPicNumsIdc = ::std::os::raw::c_uint;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END:
    StdVideoH264MemMgmtControlOp = 0;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM:
    StdVideoH264MemMgmtControlOp = 1;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 2;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 3;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX : StdVideoH264MemMgmtControlOp = 4 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL:
    StdVideoH264MemMgmtControlOp = 5;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM : StdVideoH264MemMgmtControlOp = 6 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID:
    StdVideoH264MemMgmtControlOp = 2147483647;
pub type StdVideoH264MemMgmtControlOp = ::std::os::raw::c_uint;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_0: StdVideoH264CabacInitIdc = 0;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_1: StdVideoH264CabacInitIdc = 1;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_2: StdVideoH264CabacInitIdc = 2;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_INVALID: StdVideoH264CabacInitIdc =
    2147483647;
pub type StdVideoH264CabacInitIdc = ::std::os::raw::c_uint;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED : StdVideoH264DisableDeblockingFilterIdc = 0 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED : StdVideoH264DisableDeblockingFilterIdc = 1 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL : StdVideoH264DisableDeblockingFilterIdc = 2 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID : StdVideoH264DisableDeblockingFilterIdc = 2147483647 ;
pub type StdVideoH264DisableDeblockingFilterIdc = ::std::os::raw::c_uint;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_P: StdVideoH264SliceType = 0;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_B: StdVideoH264SliceType = 1;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_I: StdVideoH264SliceType = 2;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_INVALID: StdVideoH264SliceType =
    2147483647;
pub type StdVideoH264SliceType = ::std::os::raw::c_uint;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_P: StdVideoH264PictureType = 0;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_B: StdVideoH264PictureType = 1;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_I: StdVideoH264PictureType = 2;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_IDR: StdVideoH264PictureType = 5;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_INVALID: StdVideoH264PictureType =
    2147483647;
pub type StdVideoH264PictureType = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoH264SpsVuiFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264SpsVuiFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264SpsVuiFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264SpsVuiFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264SpsVuiFlags))
    );
}
impl StdVideoH264SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_description_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_frame_rate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_frame_rate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        color_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        timing_info_present_flag: u32,
        fixed_frame_rate_flag: u32,
        bitstream_restriction_flag: u32,
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::std::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::std::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let color_description_present_flag: u32 =
                unsafe { ::std::mem::transmute(color_description_present_flag) };
            color_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(timing_info_present_flag) };
            timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fixed_frame_rate_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_frame_rate_flag) };
            fixed_frame_rate_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::std::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264HrdParameters {
    pub cpb_cnt_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cbr_flag: [u8; 32usize],
    pub initial_cpb_removal_delay_length_minus1: u32,
    pub cpb_removal_delay_length_minus1: u32,
    pub dpb_output_delay_length_minus1: u32,
    pub time_offset_length: u32,
}
#[test]
fn bindgen_test_layout_StdVideoH264HrdParameters() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264HrdParameters>(),
        308usize,
        concat!("Size of: ", stringify!(StdVideoH264HrdParameters))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264HrdParameters>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264HrdParameters))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).cpb_cnt_minus1 as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_cnt_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).bit_rate_scale as *const _
                as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(bit_rate_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).cpb_size_scale as *const _
                as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_size_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).bit_rate_value_minus1 as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(bit_rate_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).cpb_size_value_minus1 as *const _
                as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_size_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).cbr_flag as *const _ as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cbr_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>()))
                .initial_cpb_removal_delay_length_minus1 as *const _ as usize
        },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(initial_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).cpb_removal_delay_length_minus1
                as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).dpb_output_delay_length_minus1
                as *const _ as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(dpb_output_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264HrdParameters>())).time_offset_length as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264HrdParameters),
            "::",
            stringify!(time_offset_length)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSetVui {
    pub flags: StdVideoH264SpsVuiFlags,
    pub aspect_ratio_idc: StdVideoH264AspectRatioIdc,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub color_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coefficients: u8,
    pub num_units_in_tick: u32,
    pub time_scale: u32,
    pub pHrdParameters: *const StdVideoH264HrdParameters,
    pub max_num_reorder_frames: u8,
    pub max_dec_frame_buffering: u8,
}
#[test]
fn bindgen_test_layout_StdVideoH264SequenceParameterSetVui() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264SequenceParameterSetVui>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoH264SequenceParameterSetVui))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264SequenceParameterSetVui>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH264SequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).aspect_ratio_idc
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(aspect_ratio_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).sar_width as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(sar_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).sar_height as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(sar_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).video_format as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(video_format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).color_primaries
                as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(color_primaries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).transfer_characteristics
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(transfer_characteristics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).matrix_coefficients
                as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(matrix_coefficients)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).num_units_in_tick
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).time_scale as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(time_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).pHrdParameters
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(pHrdParameters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).max_num_reorder_frames
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(max_num_reorder_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSetVui>())).max_dec_frame_buffering
                as *const _ as usize
        },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSetVui),
            "::",
            stringify!(max_dec_frame_buffering)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoH264SpsFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264SpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264SpsFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264SpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264SpsFlags))
    );
}
impl StdVideoH264SpsFlags {
    #[inline]
    pub fn constraint_set0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set1_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set1_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set2_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set2_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set3_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set3_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set4_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set4_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set5_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set5_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_8x8_inference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_8x8_inference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_adaptive_frame_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_adaptive_frame_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_mbs_only_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_mbs_only_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_pic_order_always_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_pic_order_always_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gaps_in_frame_num_value_allowed_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gaps_in_frame_num_value_allowed_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn qpprime_y_zero_transform_bypass_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_qpprime_y_zero_transform_bypass_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_cropping_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_cropping_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn seq_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_seq_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        constraint_set0_flag: u32,
        constraint_set1_flag: u32,
        constraint_set2_flag: u32,
        constraint_set3_flag: u32,
        constraint_set4_flag: u32,
        constraint_set5_flag: u32,
        direct_8x8_inference_flag: u32,
        mb_adaptive_frame_field_flag: u32,
        frame_mbs_only_flag: u32,
        delta_pic_order_always_zero_flag: u32,
        separate_colour_plane_flag: u32,
        gaps_in_frame_num_value_allowed_flag: u32,
        qpprime_y_zero_transform_bypass_flag: u32,
        frame_cropping_flag: u32,
        seq_scaling_matrix_present_flag: u32,
        vui_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let constraint_set0_flag: u32 = unsafe { ::std::mem::transmute(constraint_set0_flag) };
            constraint_set0_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let constraint_set1_flag: u32 = unsafe { ::std::mem::transmute(constraint_set1_flag) };
            constraint_set1_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constraint_set2_flag: u32 = unsafe { ::std::mem::transmute(constraint_set2_flag) };
            constraint_set2_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let constraint_set3_flag: u32 = unsafe { ::std::mem::transmute(constraint_set3_flag) };
            constraint_set3_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constraint_set4_flag: u32 = unsafe { ::std::mem::transmute(constraint_set4_flag) };
            constraint_set4_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let constraint_set5_flag: u32 = unsafe { ::std::mem::transmute(constraint_set5_flag) };
            constraint_set5_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let direct_8x8_inference_flag: u32 =
                unsafe { ::std::mem::transmute(direct_8x8_inference_flag) };
            direct_8x8_inference_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let mb_adaptive_frame_field_flag: u32 =
                unsafe { ::std::mem::transmute(mb_adaptive_frame_field_flag) };
            mb_adaptive_frame_field_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let frame_mbs_only_flag: u32 = unsafe { ::std::mem::transmute(frame_mbs_only_flag) };
            frame_mbs_only_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let delta_pic_order_always_zero_flag: u32 =
                unsafe { ::std::mem::transmute(delta_pic_order_always_zero_flag) };
            delta_pic_order_always_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let gaps_in_frame_num_value_allowed_flag: u32 =
                unsafe { ::std::mem::transmute(gaps_in_frame_num_value_allowed_flag) };
            gaps_in_frame_num_value_allowed_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let qpprime_y_zero_transform_bypass_flag: u32 =
                unsafe { ::std::mem::transmute(qpprime_y_zero_transform_bypass_flag) };
            qpprime_y_zero_transform_bypass_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let frame_cropping_flag: u32 = unsafe { ::std::mem::transmute(frame_cropping_flag) };
            frame_cropping_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let seq_scaling_matrix_present_flag: u32 =
                unsafe { ::std::mem::transmute(seq_scaling_matrix_present_flag) };
            seq_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct StdVideoH264ScalingLists {
    pub scaling_list_present_mask: u8,
    pub use_default_scaling_matrix_mask: u8,
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoH264ScalingLists() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264ScalingLists>(),
        226usize,
        concat!("Size of: ", stringify!(StdVideoH264ScalingLists))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264ScalingLists>(),
        1usize,
        concat!("Alignment of ", stringify!(StdVideoH264ScalingLists))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264ScalingLists>())).scaling_list_present_mask
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(scaling_list_present_mask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264ScalingLists>())).use_default_scaling_matrix_mask
                as *const _ as usize
        },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(use_default_scaling_matrix_mask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264ScalingLists>())).ScalingList4x4 as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264ScalingLists>())).ScalingList8x8 as *const _ as usize
        },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264ScalingLists),
            "::",
            stringify!(ScalingList8x8)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSet {
    pub flags: StdVideoH264SpsFlags,
    pub profile_idc: StdVideoH264ProfileIdc,
    pub level_idc: StdVideoH264Level,
    pub seq_parameter_set_id: u8,
    pub chroma_format_idc: StdVideoH264ChromaFormatIdc,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_frame_num_minus4: u8,
    pub pic_order_cnt_type: StdVideoH264PocType,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub offset_for_non_ref_pic: i32,
    pub offset_for_top_to_bottom_field: i32,
    pub num_ref_frames_in_pic_order_cnt_cycle: u8,
    pub max_num_ref_frames: u8,
    pub pic_width_in_mbs_minus1: u32,
    pub pic_height_in_map_units_minus1: u32,
    pub frame_crop_left_offset: u32,
    pub frame_crop_right_offset: u32,
    pub frame_crop_top_offset: u32,
    pub frame_crop_bottom_offset: u32,
    pub pOffsetForRefFrame: *const i32,
    pub pScalingLists: *const StdVideoH264ScalingLists,
    pub pSequenceParameterSetVui: *const StdVideoH264SequenceParameterSetVui,
}
#[test]
fn bindgen_test_layout_StdVideoH264SequenceParameterSet() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264SequenceParameterSet>(),
        96usize,
        concat!("Size of: ", stringify!(StdVideoH264SequenceParameterSet))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264SequenceParameterSet>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH264SequenceParameterSet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).profile_idc as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(profile_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).level_idc as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(level_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).seq_parameter_set_id
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).chroma_format_idc
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(chroma_format_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).bit_depth_luma_minus8
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).bit_depth_chroma_minus8
                as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).log2_max_frame_num_minus4
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(log2_max_frame_num_minus4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).pic_order_cnt_type
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_order_cnt_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>()))
                .log2_max_pic_order_cnt_lsb_minus4 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(log2_max_pic_order_cnt_lsb_minus4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).offset_for_non_ref_pic
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(offset_for_non_ref_pic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>()))
                .offset_for_top_to_bottom_field as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(offset_for_top_to_bottom_field)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>()))
                .num_ref_frames_in_pic_order_cnt_cycle as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(num_ref_frames_in_pic_order_cnt_cycle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).max_num_ref_frames
                as *const _ as usize
        },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(max_num_ref_frames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).pic_width_in_mbs_minus1
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_width_in_mbs_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>()))
                .pic_height_in_map_units_minus1 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pic_height_in_map_units_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).frame_crop_left_offset
                as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_left_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).frame_crop_right_offset
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_right_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).frame_crop_top_offset
                as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_top_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).frame_crop_bottom_offset
                as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(frame_crop_bottom_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).pOffsetForRefFrame
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pOffsetForRefFrame)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).pScalingLists as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264SequenceParameterSet>())).pSequenceParameterSetVui
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264SequenceParameterSet),
            "::",
            stringify!(pSequenceParameterSetVui)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoH264PpsFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264PpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH264PpsFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264PpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH264PpsFlags))
    );
}
impl StdVideoH264PpsFlags {
    #[inline]
    pub fn transform_8x8_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_8x8_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn redundant_pic_cnt_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_redundant_pic_cnt_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_idc_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_idc_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_order_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_order_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        transform_8x8_mode_flag: u32,
        redundant_pic_cnt_present_flag: u32,
        constrained_intra_pred_flag: u32,
        deblocking_filter_control_present_flag: u32,
        weighted_bipred_idc_flag: u32,
        weighted_pred_flag: u32,
        pic_order_present_flag: u32,
        entropy_coding_mode_flag: u32,
        pic_scaling_matrix_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let transform_8x8_mode_flag: u32 =
                unsafe { ::std::mem::transmute(transform_8x8_mode_flag) };
            transform_8x8_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let redundant_pic_cnt_present_flag: u32 =
                unsafe { ::std::mem::transmute(redundant_pic_cnt_present_flag) };
            redundant_pic_cnt_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let weighted_bipred_idc_flag: u32 =
                unsafe { ::std::mem::transmute(weighted_bipred_idc_flag) };
            weighted_bipred_idc_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pic_order_present_flag: u32 =
                unsafe { ::std::mem::transmute(pic_order_present_flag) };
            pic_order_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let entropy_coding_mode_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_mode_flag) };
            entropy_coding_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let pic_scaling_matrix_present_flag: u32 =
                unsafe { ::std::mem::transmute(pic_scaling_matrix_present_flag) };
            pic_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PictureParameterSet {
    pub flags: StdVideoH264PpsFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub weighted_bipred_idc: StdVideoH264WeightedBipredIdc,
    pub pic_init_qp_minus26: i8,
    pub pic_init_qs_minus26: i8,
    pub chroma_qp_index_offset: i8,
    pub second_chroma_qp_index_offset: i8,
    pub pScalingLists: *const StdVideoH264ScalingLists,
}
#[test]
fn bindgen_test_layout_StdVideoH264PictureParameterSet() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH264PictureParameterSet>(),
        24usize,
        concat!("Size of: ", stringify!(StdVideoH264PictureParameterSet))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH264PictureParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH264PictureParameterSet))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).seq_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).pic_parameter_set_id
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>()))
                .num_ref_idx_l0_default_active_minus1 as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>()))
                .num_ref_idx_l1_default_active_minus1 as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).weighted_bipred_idc
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(weighted_bipred_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).pic_init_qp_minus26
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).pic_init_qs_minus26
                as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pic_init_qs_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).chroma_qp_index_offset
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>()))
                .second_chroma_qp_index_offset as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(second_chroma_qp_index_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH264PictureParameterSet>())).pScalingLists as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH264PictureParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264PictureInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264PictureInfoFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH264PictureInfoFlags)
        )
    );
}
impl StdVideoDecodeH264PictureInfoFlags {
    #[inline]
    pub fn field_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn complementary_field_pair(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_complementary_field_pair(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        field_pic_flag: u32,
        is_intra: u32,
        IdrPicFlag: u32,
        bottom_field_flag: u32,
        is_reference: u32,
        complementary_field_pair: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let field_pic_flag: u32 = unsafe { ::std::mem::transmute(field_pic_flag) };
            field_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_intra: u32 = unsafe { ::std::mem::transmute(is_intra) };
            is_intra as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::std::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::std::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_reference: u32 = unsafe { ::std::mem::transmute(is_reference) };
            is_reference as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let complementary_field_pair: u32 =
                unsafe { ::std::mem::transmute(complementary_field_pair) };
            complementary_field_pair as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfo {
    pub flags: StdVideoDecodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub reserved: u16,
    pub frame_num: u16,
    pub idr_pic_id: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264PictureInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264PictureInfo>(),
        20usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264PictureInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264PictureInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).seq_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).pic_parameter_set_id
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).reserved as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).frame_num as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(frame_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).idr_pic_id as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(idr_pic_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264PictureInfo>())).PicOrderCnt as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264PictureInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264ReferenceInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoDecodeH264ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH264ReferenceInfoFlags)
        )
    );
}
impl StdVideoDecodeH264ReferenceInfoFlags {
    #[inline]
    pub fn top_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_non_existing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_non_existing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        top_field_flag: u32,
        bottom_field_flag: u32,
        used_for_long_term_reference: u32,
        is_non_existing: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let top_field_flag: u32 = unsafe { ::std::mem::transmute(top_field_flag) };
            top_field_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::std::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_non_existing: u32 = unsafe { ::std::mem::transmute(is_non_existing) };
            is_non_existing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfo {
    pub flags: StdVideoDecodeH264ReferenceInfoFlags,
    pub FrameNum: u16,
    pub reserved: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264ReferenceInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264ReferenceInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264ReferenceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264ReferenceInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264ReferenceInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264ReferenceInfo>())).FrameNum as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(FrameNum)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264ReferenceInfo>())).reserved as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264ReferenceInfo>())).PicOrderCnt as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264ReferenceInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264MvcElementFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264MvcElementFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264MvcElementFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264MvcElementFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264MvcElementFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH264MvcElementFlags)
        )
    );
}
impl StdVideoDecodeH264MvcElementFlags {
    #[inline]
    pub fn non_idr(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_non_idr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn anchor_pic(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_anchor_pic(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inter_view(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inter_view(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        non_idr: u32,
        anchor_pic: u32,
        inter_view: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let non_idr: u32 = unsafe { ::std::mem::transmute(non_idr) };
            non_idr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let anchor_pic: u32 = unsafe { ::std::mem::transmute(anchor_pic) };
            anchor_pic as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let inter_view: u32 = unsafe { ::std::mem::transmute(inter_view) };
            inter_view as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264MvcElement {
    pub flags: StdVideoDecodeH264MvcElementFlags,
    pub viewOrderIndex: u16,
    pub viewId: u16,
    pub temporalId: u16,
    pub priorityId: u16,
    pub numOfAnchorRefsInL0: u16,
    pub viewIdOfAnchorRefsInL0: [u16; 15usize],
    pub numOfAnchorRefsInL1: u16,
    pub viewIdOfAnchorRefsInL1: [u16; 15usize],
    pub numOfNonAnchorRefsInL0: u16,
    pub viewIdOfNonAnchorRefsInL0: [u16; 15usize],
    pub numOfNonAnchorRefsInL1: u16,
    pub viewIdOfNonAnchorRefsInL1: [u16; 15usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264MvcElement() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264MvcElement>(),
        140usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264MvcElement))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264MvcElement>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264MvcElement))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewOrderIndex as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewOrderIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewId as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).temporalId as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(temporalId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).priorityId as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(priorityId)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).numOfAnchorRefsInL0 as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(numOfAnchorRefsInL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewIdOfAnchorRefsInL0
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewIdOfAnchorRefsInL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).numOfAnchorRefsInL1 as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(numOfAnchorRefsInL1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewIdOfAnchorRefsInL1
                as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewIdOfAnchorRefsInL1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).numOfNonAnchorRefsInL0
                as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(numOfNonAnchorRefsInL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewIdOfNonAnchorRefsInL0
                as *const _ as usize
        },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewIdOfNonAnchorRefsInL0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).numOfNonAnchorRefsInL1
                as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(numOfNonAnchorRefsInL1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264MvcElement>())).viewIdOfNonAnchorRefsInL1
                as *const _ as usize
        },
        110usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264MvcElement),
            "::",
            stringify!(viewIdOfNonAnchorRefsInL1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264Mvc {
    pub viewId0: u32,
    pub mvcElementCount: u32,
    pub pMvcElements: *const StdVideoDecodeH264MvcElement,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH264Mvc() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH264Mvc>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH264Mvc))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH264Mvc>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH264Mvc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<StdVideoDecodeH264Mvc>())).viewId0 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264Mvc),
            "::",
            stringify!(viewId0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264Mvc>())).mvcElementCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264Mvc),
            "::",
            stringify!(mvcElementCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH264Mvc>())).pMvcElements as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH264Mvc),
            "::",
            stringify!(pMvcElements)
        )
    );
}
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN: StdVideoH265ProfileIdc = 1;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_10: StdVideoH265ProfileIdc = 2;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE:
    StdVideoH265ProfileIdc = 3;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS:
    StdVideoH265ProfileIdc = 4;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS: StdVideoH265ProfileIdc =
    9;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_INVALID: StdVideoH265ProfileIdc =
    2147483647;
pub type StdVideoH265ProfileIdc = ::std::os::raw::c_uint;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_1_0: StdVideoH265Level = 0;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_2_0: StdVideoH265Level = 1;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_2_1: StdVideoH265Level = 2;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_3_0: StdVideoH265Level = 3;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_3_1: StdVideoH265Level = 4;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_4_0: StdVideoH265Level = 5;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_4_1: StdVideoH265Level = 6;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_0: StdVideoH265Level = 7;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_1: StdVideoH265Level = 8;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_2: StdVideoH265Level = 9;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_0: StdVideoH265Level = 10;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_1: StdVideoH265Level = 11;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_2: StdVideoH265Level = 12;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_INVALID: StdVideoH265Level = 2147483647;
pub type StdVideoH265Level = ::std::os::raw::c_uint;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_B: StdVideoH265SliceType = 0;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_P: StdVideoH265SliceType = 1;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_I: StdVideoH265SliceType = 2;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_INVALID: StdVideoH265SliceType =
    2147483647;
pub type StdVideoH265SliceType = ::std::os::raw::c_uint;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_P: StdVideoH265PictureType = 0;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_B: StdVideoH265PictureType = 1;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_I: StdVideoH265PictureType = 2;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_IDR: StdVideoH265PictureType = 3;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_INVALID: StdVideoH265PictureType =
    2147483647;
pub type StdVideoH265PictureType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265DecPicBufMgr {
    pub max_latency_increase_plus1: [u32; 7usize],
    pub max_dec_pic_buffering_minus1: [u8; 7usize],
    pub max_num_reorder_pics: [u8; 7usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265DecPicBufMgr() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265DecPicBufMgr>(),
        44usize,
        concat!("Size of: ", stringify!(StdVideoH265DecPicBufMgr))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265DecPicBufMgr>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265DecPicBufMgr))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265DecPicBufMgr>())).max_latency_increase_plus1
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_latency_increase_plus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265DecPicBufMgr>())).max_dec_pic_buffering_minus1
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_dec_pic_buffering_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265DecPicBufMgr>())).max_num_reorder_pics as *const _
                as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265DecPicBufMgr),
            "::",
            stringify!(max_num_reorder_pics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SubLayerHrdParameters {
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cpb_size_du_value_minus1: [u32; 32usize],
    pub bit_rate_du_value_minus1: [u32; 32usize],
    pub cbr_flag: u32,
}
#[test]
fn bindgen_test_layout_StdVideoH265SubLayerHrdParameters() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265SubLayerHrdParameters>(),
        516usize,
        concat!("Size of: ", stringify!(StdVideoH265SubLayerHrdParameters))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265SubLayerHrdParameters>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SubLayerHrdParameters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SubLayerHrdParameters>())).bit_rate_value_minus1
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(bit_rate_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SubLayerHrdParameters>())).cpb_size_value_minus1
                as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cpb_size_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SubLayerHrdParameters>())).cpb_size_du_value_minus1
                as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cpb_size_du_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SubLayerHrdParameters>())).bit_rate_du_value_minus1
                as *const _ as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(bit_rate_du_value_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SubLayerHrdParameters>())).cbr_flag as *const _
                as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SubLayerHrdParameters),
            "::",
            stringify!(cbr_flag)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265HrdFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265HrdFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265HrdFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265HrdFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265HrdFlags))
    );
}
impl StdVideoH265HrdFlags {
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_hrd_params_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_hrd_params_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_cpb_params_in_pic_timing_sei_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_cpb_params_in_pic_timing_sei_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_general_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_general_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_within_cvs_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_within_cvs_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn low_delay_hrd_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_low_delay_hrd_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
        sub_pic_hrd_params_present_flag: u32,
        sub_pic_cpb_params_in_pic_timing_sei_flag: u32,
        fixed_pic_rate_general_flag: u32,
        fixed_pic_rate_within_cvs_flag: u32,
        low_delay_hrd_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sub_pic_hrd_params_present_flag: u32 =
                unsafe { ::std::mem::transmute(sub_pic_hrd_params_present_flag) };
            sub_pic_hrd_params_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sub_pic_cpb_params_in_pic_timing_sei_flag: u32 =
                unsafe { ::std::mem::transmute(sub_pic_cpb_params_in_pic_timing_sei_flag) };
            sub_pic_cpb_params_in_pic_timing_sei_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 8u8, {
            let fixed_pic_rate_general_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_pic_rate_general_flag) };
            fixed_pic_rate_general_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 8u8, {
            let fixed_pic_rate_within_cvs_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_pic_rate_within_cvs_flag) };
            fixed_pic_rate_within_cvs_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 8u8, {
            let low_delay_hrd_flag: u32 = unsafe { ::std::mem::transmute(low_delay_hrd_flag) };
            low_delay_hrd_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdParameters {
    pub flags: StdVideoH265HrdFlags,
    pub tick_divisor_minus2: u8,
    pub du_cpb_removal_delay_increment_length_minus1: u8,
    pub dpb_output_delay_du_length_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub cpb_size_du_scale: u8,
    pub initial_cpb_removal_delay_length_minus1: u8,
    pub au_cpb_removal_delay_length_minus1: u8,
    pub dpb_output_delay_length_minus1: u8,
    pub cpb_cnt_minus1: [u8; 7usize],
    pub elemental_duration_in_tc_minus1: [u16; 7usize],
    pub pSubLayerHrdParametersNal: [*const StdVideoH265SubLayerHrdParameters; 7usize],
    pub pSubLayerHrdParametersVcl: [*const StdVideoH265SubLayerHrdParameters; 7usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265HrdParameters() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265HrdParameters>(),
        152usize,
        concat!("Size of: ", stringify!(StdVideoH265HrdParameters))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265HrdParameters>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265HrdParameters))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).tick_divisor_minus2 as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(tick_divisor_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>()))
                .du_cpb_removal_delay_increment_length_minus1 as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(du_cpb_removal_delay_increment_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).dpb_output_delay_du_length_minus1
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(dpb_output_delay_du_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).bit_rate_scale as *const _
                as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(bit_rate_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).cpb_size_scale as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_size_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).cpb_size_du_scale as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_size_du_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>()))
                .initial_cpb_removal_delay_length_minus1 as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(initial_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).au_cpb_removal_delay_length_minus1
                as *const _ as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(au_cpb_removal_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).dpb_output_delay_length_minus1
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(dpb_output_delay_length_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).cpb_cnt_minus1 as *const _
                as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(cpb_cnt_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).elemental_duration_in_tc_minus1
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(elemental_duration_in_tc_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).pSubLayerHrdParametersNal
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(pSubLayerHrdParametersNal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265HrdParameters>())).pSubLayerHrdParametersVcl
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265HrdParameters),
            "::",
            stringify!(pSubLayerHrdParametersVcl)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265VpsFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265VpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265VpsFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265VpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265VpsFlags))
    );
}
impl StdVideoH265VpsFlags {
    #[inline]
    pub fn vps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_sub_layer_ordering_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_sub_layer_ordering_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vps_temporal_id_nesting_flag: u32,
        vps_sub_layer_ordering_info_present_flag: u32,
        vps_timing_info_present_flag: u32,
        vps_poc_proportional_to_timing_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let vps_temporal_id_nesting_flag: u32 =
                unsafe { ::std::mem::transmute(vps_temporal_id_nesting_flag) };
            vps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vps_sub_layer_ordering_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vps_sub_layer_ordering_info_present_flag) };
            vps_sub_layer_ordering_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let vps_timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vps_timing_info_present_flag) };
            vps_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let vps_poc_proportional_to_timing_flag: u32 =
                unsafe { ::std::mem::transmute(vps_poc_proportional_to_timing_flag) };
            vps_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VideoParameterSet {
    pub flags: StdVideoH265VpsFlags,
    pub vps_video_parameter_set_id: u8,
    pub vps_max_sub_layers_minus1: u8,
    pub vps_num_units_in_tick: u32,
    pub vps_time_scale: u32,
    pub vps_num_ticks_poc_diff_one_minus1: u32,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
}
#[test]
fn bindgen_test_layout_StdVideoH265VideoParameterSet() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265VideoParameterSet>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoH265VideoParameterSet))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265VideoParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265VideoParameterSet))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).vps_video_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).vps_max_sub_layers_minus1
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_max_sub_layers_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).vps_num_units_in_tick
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).vps_time_scale as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_time_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>()))
                .vps_num_ticks_poc_diff_one_minus1 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(vps_num_ticks_poc_diff_one_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).pDecPicBufMgr as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(pDecPicBufMgr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265VideoParameterSet>())).pHrdParameters as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265VideoParameterSet),
            "::",
            stringify!(pHrdParameters)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct StdVideoH265ScalingLists {
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 6usize],
    pub ScalingList16x16: [[u8; 64usize]; 6usize],
    pub ScalingList32x32: [[u8; 64usize]; 2usize],
    pub ScalingListDCCoef16x16: [u8; 6usize],
    pub ScalingListDCCoef32x32: [u8; 2usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265ScalingLists() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265ScalingLists>(),
        1000usize,
        concat!("Size of: ", stringify!(StdVideoH265ScalingLists))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265ScalingLists>(),
        1usize,
        concat!("Alignment of ", stringify!(StdVideoH265ScalingLists))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingList4x4 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList4x4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingList8x8 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList8x8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingList16x16 as *const _
                as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingList32x32 as *const _
                as usize
        },
        864usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingList32x32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingListDCCoef16x16 as *const _
                as usize
        },
        992usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingListDCCoef16x16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265ScalingLists>())).ScalingListDCCoef32x32 as *const _
                as usize
        },
        998usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265ScalingLists),
            "::",
            stringify!(ScalingListDCCoef32x32)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
#[test]
fn bindgen_test_layout_StdVideoH265SpsVuiFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265SpsVuiFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265SpsVuiFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265SpsVuiFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265SpsVuiFlags))
    );
}
impl StdVideoH265SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn colour_description_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_colour_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn neutral_chroma_indication_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_neutral_chroma_indication_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_seq_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_seq_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_field_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_field_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn default_display_window_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_default_display_window_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_fixed_structure_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_fixed_structure_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn motion_vectors_over_pic_boundaries_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_motion_vectors_over_pic_boundaries_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn restricted_ref_pic_lists_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_restricted_ref_pic_lists_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        colour_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        neutral_chroma_indication_flag: u32,
        field_seq_flag: u32,
        frame_field_info_present_flag: u32,
        default_display_window_flag: u32,
        vui_timing_info_present_flag: u32,
        vui_poc_proportional_to_timing_flag: u32,
        vui_hrd_parameters_present_flag: u32,
        bitstream_restriction_flag: u32,
        tiles_fixed_structure_flag: u32,
        motion_vectors_over_pic_boundaries_flag: u32,
        restricted_ref_pic_lists_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::std::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::std::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let colour_description_present_flag: u32 =
                unsafe { ::std::mem::transmute(colour_description_present_flag) };
            colour_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let neutral_chroma_indication_flag: u32 =
                unsafe { ::std::mem::transmute(neutral_chroma_indication_flag) };
            neutral_chroma_indication_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let field_seq_flag: u32 = unsafe { ::std::mem::transmute(field_seq_flag) };
            field_seq_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let frame_field_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(frame_field_info_present_flag) };
            frame_field_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let default_display_window_flag: u32 =
                unsafe { ::std::mem::transmute(default_display_window_flag) };
            default_display_window_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vui_timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_timing_info_present_flag) };
            vui_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let vui_poc_proportional_to_timing_flag: u32 =
                unsafe { ::std::mem::transmute(vui_poc_proportional_to_timing_flag) };
            vui_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let vui_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_hrd_parameters_present_flag) };
            vui_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::std::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let tiles_fixed_structure_flag: u32 =
                unsafe { ::std::mem::transmute(tiles_fixed_structure_flag) };
            tiles_fixed_structure_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let motion_vectors_over_pic_boundaries_flag: u32 =
                unsafe { ::std::mem::transmute(motion_vectors_over_pic_boundaries_flag) };
            motion_vectors_over_pic_boundaries_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let restricted_ref_pic_lists_flag: u32 =
                unsafe { ::std::mem::transmute(restricted_ref_pic_lists_flag) };
            restricted_ref_pic_lists_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSetVui {
    pub flags: StdVideoH265SpsVuiFlags,
    pub aspect_ratio_idc: u8,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub colour_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coeffs: u8,
    pub chroma_sample_loc_type_top_field: u8,
    pub chroma_sample_loc_type_bottom_field: u8,
    pub def_disp_win_left_offset: u16,
    pub def_disp_win_right_offset: u16,
    pub def_disp_win_top_offset: u16,
    pub def_disp_win_bottom_offset: u16,
    pub vui_num_units_in_tick: u32,
    pub vui_time_scale: u32,
    pub vui_num_ticks_poc_diff_one_minus1: u32,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
    pub min_spatial_segmentation_idc: u16,
    pub max_bytes_per_pic_denom: u8,
    pub max_bits_per_min_cu_denom: u8,
    pub log2_max_mv_length_horizontal: u8,
    pub log2_max_mv_length_vertical: u8,
}
#[test]
fn bindgen_test_layout_StdVideoH265SequenceParameterSetVui() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265SequenceParameterSetVui>(),
        56usize,
        concat!("Size of: ", stringify!(StdVideoH265SequenceParameterSetVui))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265SequenceParameterSetVui>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).aspect_ratio_idc
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(aspect_ratio_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).sar_width as *const _
                as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(sar_width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).sar_height as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(sar_height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).video_format as *const _
                as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(video_format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).colour_primaries
                as *const _ as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(colour_primaries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).transfer_characteristics
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(transfer_characteristics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).matrix_coeffs
                as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(matrix_coeffs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .chroma_sample_loc_type_top_field as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_top_field)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .chroma_sample_loc_type_bottom_field as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(chroma_sample_loc_type_bottom_field)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).def_disp_win_left_offset
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_left_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .def_disp_win_right_offset as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_right_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).def_disp_win_top_offset
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_top_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .def_disp_win_bottom_offset as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(def_disp_win_bottom_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).vui_num_units_in_tick
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_num_units_in_tick)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).vui_time_scale
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_time_scale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .vui_num_ticks_poc_diff_one_minus1 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(vui_num_ticks_poc_diff_one_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).pHrdParameters
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(pHrdParameters)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .min_spatial_segmentation_idc as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(min_spatial_segmentation_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>())).max_bytes_per_pic_denom
                as *const _ as usize
        },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(max_bytes_per_pic_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .max_bits_per_min_cu_denom as *const _ as usize
        },
        51usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(max_bits_per_min_cu_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .log2_max_mv_length_horizontal as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(log2_max_mv_length_horizontal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSetVui>()))
                .log2_max_mv_length_vertical as *const _ as usize
        },
        53usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSetVui),
            "::",
            stringify!(log2_max_mv_length_vertical)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct StdVideoH265PredictorPaletteEntries {
    pub PredictorPaletteEntries: [[u16; 128usize]; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoH265PredictorPaletteEntries() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265PredictorPaletteEntries>(),
        768usize,
        concat!("Size of: ", stringify!(StdVideoH265PredictorPaletteEntries))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265PredictorPaletteEntries>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265PredictorPaletteEntries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PredictorPaletteEntries>())).PredictorPaletteEntries
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PredictorPaletteEntries),
            "::",
            stringify!(PredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265SpsFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265SpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265SpsFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265SpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265SpsFlags))
    );
}
impl StdVideoH265SpsFlags {
    #[inline]
    pub fn sps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn amp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_amp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_adaptive_offset_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample_adaptive_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_loop_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_loop_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_ref_pics_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_ref_pics_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_range_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_rotation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_rotation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_context_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_context_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_precision_processing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_precision_processing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_smoothing_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_smoothing_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn high_precision_offsets_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_precision_offsets_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn persistent_rice_adaptation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_persistent_rice_adaptation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_bypass_alignment_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_bypass_alignment_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scc_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scc_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn palette_mode_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_palette_mode_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_palette_predictor_initializer_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_palette_predictor_initializer_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_boundary_filtering_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_boundary_filtering_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sps_temporal_id_nesting_flag: u32,
        separate_colour_plane_flag: u32,
        scaling_list_enabled_flag: u32,
        sps_scaling_list_data_present_flag: u32,
        amp_enabled_flag: u32,
        sample_adaptive_offset_enabled_flag: u32,
        pcm_enabled_flag: u32,
        pcm_loop_filter_disabled_flag: u32,
        long_term_ref_pics_present_flag: u32,
        sps_temporal_mvp_enabled_flag: u32,
        strong_intra_smoothing_enabled_flag: u32,
        vui_parameters_present_flag: u32,
        sps_extension_present_flag: u32,
        sps_range_extension_flag: u32,
        transform_skip_rotation_enabled_flag: u32,
        transform_skip_context_enabled_flag: u32,
        implicit_rdpcm_enabled_flag: u32,
        explicit_rdpcm_enabled_flag: u32,
        extended_precision_processing_flag: u32,
        intra_smoothing_disabled_flag: u32,
        high_precision_offsets_enabled_flag: u32,
        persistent_rice_adaptation_enabled_flag: u32,
        cabac_bypass_alignment_enabled_flag: u32,
        sps_scc_extension_flag: u32,
        sps_curr_pic_ref_enabled_flag: u32,
        palette_mode_enabled_flag: u32,
        sps_palette_predictor_initializer_present_flag: u32,
        intra_boundary_filtering_disabled_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let sps_temporal_id_nesting_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_id_nesting_flag) };
            sps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let scaling_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(scaling_list_enabled_flag) };
            scaling_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sps_scaling_list_data_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_scaling_list_data_present_flag) };
            sps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let amp_enabled_flag: u32 = unsafe { ::std::mem::transmute(amp_enabled_flag) };
            amp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let sample_adaptive_offset_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sample_adaptive_offset_enabled_flag) };
            sample_adaptive_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pcm_enabled_flag: u32 = unsafe { ::std::mem::transmute(pcm_enabled_flag) };
            pcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pcm_loop_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pcm_loop_filter_disabled_flag) };
            pcm_loop_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let long_term_ref_pics_present_flag: u32 =
                unsafe { ::std::mem::transmute(long_term_ref_pics_present_flag) };
            long_term_ref_pics_present_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let sps_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_mvp_enabled_flag) };
            sps_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let strong_intra_smoothing_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(strong_intra_smoothing_enabled_flag) };
            strong_intra_smoothing_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let sps_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_extension_present_flag) };
            sps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let sps_range_extension_flag: u32 =
                unsafe { ::std::mem::transmute(sps_range_extension_flag) };
            sps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let transform_skip_rotation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_rotation_enabled_flag) };
            transform_skip_rotation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let transform_skip_context_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_context_enabled_flag) };
            transform_skip_context_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let implicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(implicit_rdpcm_enabled_flag) };
            implicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let explicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(explicit_rdpcm_enabled_flag) };
            explicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let extended_precision_processing_flag: u32 =
                unsafe { ::std::mem::transmute(extended_precision_processing_flag) };
            extended_precision_processing_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let intra_smoothing_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_smoothing_disabled_flag) };
            intra_smoothing_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let high_precision_offsets_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(high_precision_offsets_enabled_flag) };
            high_precision_offsets_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let persistent_rice_adaptation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(persistent_rice_adaptation_enabled_flag) };
            persistent_rice_adaptation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let cabac_bypass_alignment_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_bypass_alignment_enabled_flag) };
            cabac_bypass_alignment_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let sps_scc_extension_flag: u32 =
                unsafe { ::std::mem::transmute(sps_scc_extension_flag) };
            sps_scc_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let sps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_curr_pic_ref_enabled_flag) };
            sps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let palette_mode_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(palette_mode_enabled_flag) };
            palette_mode_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let sps_palette_predictor_initializer_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_palette_predictor_initializer_present_flag) };
            sps_palette_predictor_initializer_present_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let intra_boundary_filtering_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_boundary_filtering_disabled_flag) };
            intra_boundary_filtering_disabled_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSet {
    pub flags: StdVideoH265SpsFlags,
    pub profile_idc: StdVideoH265ProfileIdc,
    pub level_idc: StdVideoH265Level,
    pub pic_width_in_luma_samples: u32,
    pub pic_height_in_luma_samples: u32,
    pub sps_video_parameter_set_id: u8,
    pub sps_max_sub_layers_minus1: u8,
    pub sps_seq_parameter_set_id: u8,
    pub chroma_format_idc: u8,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub sps_max_dec_pic_buffering_minus1: [u8; 8usize],
    pub log2_min_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_luma_coding_block_size: u8,
    pub log2_min_luma_transform_block_size_minus2: u8,
    pub log2_diff_max_min_luma_transform_block_size: u8,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub num_long_term_ref_pics_sps: u8,
    pub pcm_sample_bit_depth_luma_minus1: u8,
    pub pcm_sample_bit_depth_chroma_minus1: u8,
    pub log2_min_pcm_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_pcm_luma_coding_block_size: u8,
    pub conf_win_left_offset: u32,
    pub conf_win_right_offset: u32,
    pub conf_win_top_offset: u32,
    pub conf_win_bottom_offset: u32,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub pSequenceParameterSetVui: *const StdVideoH265SequenceParameterSetVui,
    pub palette_max_size: u8,
    pub delta_palette_max_predictor_size: u8,
    pub motion_vector_resolution_control_idc: u8,
    pub sps_num_palette_predictor_initializer_minus1: u8,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[test]
fn bindgen_test_layout_StdVideoH265SequenceParameterSet() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265SequenceParameterSet>(),
        104usize,
        concat!("Size of: ", stringify!(StdVideoH265SequenceParameterSet))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265SequenceParameterSet>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoH265SequenceParameterSet)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).profile_idc as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(profile_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).level_idc as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(level_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pic_width_in_luma_samples
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pic_width_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pic_height_in_luma_samples
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pic_height_in_luma_samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).sps_video_parameter_set_id
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).sps_max_sub_layers_minus1
                as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_max_sub_layers_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).sps_seq_parameter_set_id
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).chroma_format_idc
                as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(chroma_format_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).bit_depth_luma_minus8
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(bit_depth_luma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).bit_depth_chroma_minus8
                as *const _ as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(bit_depth_chroma_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_max_pic_order_cnt_lsb_minus4 as *const _ as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_max_pic_order_cnt_lsb_minus4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .sps_max_dec_pic_buffering_minus1 as *const _ as usize
        },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_max_dec_pic_buffering_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_min_luma_coding_block_size_minus3 as *const _ as usize
        },
        35usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_diff_max_min_luma_coding_block_size as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_min_luma_transform_block_size_minus2 as *const _ as usize
        },
        37usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_luma_transform_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_diff_max_min_luma_transform_block_size as *const _ as usize
        },
        38usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_luma_transform_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .max_transform_hierarchy_depth_inter as *const _ as usize
        },
        39usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(max_transform_hierarchy_depth_inter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .max_transform_hierarchy_depth_intra as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(max_transform_hierarchy_depth_intra)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).num_short_term_ref_pic_sets
                as *const _ as usize
        },
        41usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(num_short_term_ref_pic_sets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).num_long_term_ref_pics_sps
                as *const _ as usize
        },
        42usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(num_long_term_ref_pics_sps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .pcm_sample_bit_depth_luma_minus1 as *const _ as usize
        },
        43usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pcm_sample_bit_depth_luma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .pcm_sample_bit_depth_chroma_minus1 as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pcm_sample_bit_depth_chroma_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_min_pcm_luma_coding_block_size_minus3 as *const _ as usize
        },
        45usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_min_pcm_luma_coding_block_size_minus3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .log2_diff_max_min_pcm_luma_coding_block_size as *const _ as usize
        },
        46usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(log2_diff_max_min_pcm_luma_coding_block_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).conf_win_left_offset
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_left_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).conf_win_right_offset
                as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_right_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).conf_win_top_offset
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_top_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).conf_win_bottom_offset
                as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(conf_win_bottom_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pDecPicBufMgr as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pDecPicBufMgr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pScalingLists as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pSequenceParameterSetVui
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pSequenceParameterSetVui)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).palette_max_size
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(palette_max_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .delta_palette_max_predictor_size as *const _ as usize
        },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(delta_palette_max_predictor_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .motion_vector_resolution_control_idc as *const _ as usize
        },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(motion_vector_resolution_control_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>()))
                .sps_num_palette_predictor_initializer_minus1 as *const _ as usize
        },
        91usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(sps_num_palette_predictor_initializer_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265SequenceParameterSet>())).pPredictorPaletteEntries
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265SequenceParameterSet),
            "::",
            stringify!(pPredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_StdVideoH265PpsFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265PpsFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoH265PpsFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265PpsFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoH265PpsFlags))
    );
}
impl StdVideoH265PpsFlags {
    #[inline]
    pub fn dependent_slice_segments_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segments_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn output_flag_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_output_flag_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_chroma_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_chroma_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_sync_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_sync_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uniform_spacing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uniform_spacing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_across_tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_across_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_override_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_override_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lists_modification_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lists_modification_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_segment_header_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_segment_header_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_component_prediction_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_component_prediction_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_qp_offset_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_qp_offset_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn residual_adaptive_colour_transform_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_residual_adaptive_colour_transform_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_act_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_act_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_palette_predictor_initializer_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_palette_predictor_initializer_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn monochrome_palette_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_monochrome_palette_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_range_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        dependent_slice_segments_enabled_flag: u32,
        output_flag_present_flag: u32,
        sign_data_hiding_enabled_flag: u32,
        cabac_init_present_flag: u32,
        constrained_intra_pred_flag: u32,
        transform_skip_enabled_flag: u32,
        cu_qp_delta_enabled_flag: u32,
        pps_slice_chroma_qp_offsets_present_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_flag: u32,
        transquant_bypass_enabled_flag: u32,
        tiles_enabled_flag: u32,
        entropy_coding_sync_enabled_flag: u32,
        uniform_spacing_flag: u32,
        loop_filter_across_tiles_enabled_flag: u32,
        pps_loop_filter_across_slices_enabled_flag: u32,
        deblocking_filter_control_present_flag: u32,
        deblocking_filter_override_enabled_flag: u32,
        pps_deblocking_filter_disabled_flag: u32,
        pps_scaling_list_data_present_flag: u32,
        lists_modification_present_flag: u32,
        slice_segment_header_extension_present_flag: u32,
        pps_extension_present_flag: u32,
        cross_component_prediction_enabled_flag: u32,
        chroma_qp_offset_list_enabled_flag: u32,
        pps_curr_pic_ref_enabled_flag: u32,
        residual_adaptive_colour_transform_enabled_flag: u32,
        pps_slice_act_qp_offsets_present_flag: u32,
        pps_palette_predictor_initializer_present_flag: u32,
        monochrome_palette_flag: u32,
        pps_range_extension_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let dependent_slice_segments_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segments_enabled_flag) };
            dependent_slice_segments_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let output_flag_present_flag: u32 =
                unsafe { ::std::mem::transmute(output_flag_present_flag) };
            output_flag_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sign_data_hiding_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sign_data_hiding_enabled_flag) };
            sign_data_hiding_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cabac_init_present_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_init_present_flag) };
            cabac_init_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let transform_skip_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_enabled_flag) };
            transform_skip_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cu_qp_delta_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cu_qp_delta_enabled_flag) };
            cu_qp_delta_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pps_slice_chroma_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_chroma_qp_offsets_present_flag) };
            pps_slice_chroma_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let weighted_bipred_flag: u32 = unsafe { ::std::mem::transmute(weighted_bipred_flag) };
            weighted_bipred_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let transquant_bypass_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transquant_bypass_enabled_flag) };
            transquant_bypass_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let tiles_enabled_flag: u32 = unsafe { ::std::mem::transmute(tiles_enabled_flag) };
            tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let entropy_coding_sync_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_sync_enabled_flag) };
            entropy_coding_sync_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uniform_spacing_flag: u32 = unsafe { ::std::mem::transmute(uniform_spacing_flag) };
            uniform_spacing_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let loop_filter_across_tiles_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(loop_filter_across_tiles_enabled_flag) };
            loop_filter_across_tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pps_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_loop_filter_across_slices_enabled_flag) };
            pps_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let deblocking_filter_override_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_override_enabled_flag) };
            deblocking_filter_override_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let pps_deblocking_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_deblocking_filter_disabled_flag) };
            pps_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let pps_scaling_list_data_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_scaling_list_data_present_flag) };
            pps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lists_modification_present_flag: u32 =
                unsafe { ::std::mem::transmute(lists_modification_present_flag) };
            lists_modification_present_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let slice_segment_header_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(slice_segment_header_extension_present_flag) };
            slice_segment_header_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let pps_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_extension_present_flag) };
            pps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let cross_component_prediction_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cross_component_prediction_enabled_flag) };
            cross_component_prediction_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let chroma_qp_offset_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_qp_offset_list_enabled_flag) };
            chroma_qp_offset_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let pps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_curr_pic_ref_enabled_flag) };
            pps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let residual_adaptive_colour_transform_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(residual_adaptive_colour_transform_enabled_flag) };
            residual_adaptive_colour_transform_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let pps_slice_act_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_act_qp_offsets_present_flag) };
            pps_slice_act_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let pps_palette_predictor_initializer_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_palette_predictor_initializer_present_flag) };
            pps_palette_predictor_initializer_present_flag as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let monochrome_palette_flag: u32 =
                unsafe { ::std::mem::transmute(monochrome_palette_flag) };
            monochrome_palette_flag as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let pps_range_extension_flag: u32 =
                unsafe { ::std::mem::transmute(pps_range_extension_flag) };
            pps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PictureParameterSet {
    pub flags: StdVideoH265PpsFlags,
    pub pps_pic_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub num_extra_slice_header_bits: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub init_qp_minus26: i8,
    pub diff_cu_qp_delta_depth: u8,
    pub pps_cb_qp_offset: i8,
    pub pps_cr_qp_offset: i8,
    pub num_tile_columns_minus1: u8,
    pub num_tile_rows_minus1: u8,
    pub column_width_minus1: [u16; 19usize],
    pub row_height_minus1: [u16; 21usize],
    pub pps_beta_offset_div2: i8,
    pub pps_tc_offset_div2: i8,
    pub log2_parallel_merge_level_minus2: u8,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub log2_max_transform_skip_block_size_minus2: u8,
    pub diff_cu_chroma_qp_offset_depth: u8,
    pub chroma_qp_offset_list_len_minus1: u8,
    pub cb_qp_offset_list: [i8; 6usize],
    pub cr_qp_offset_list: [i8; 6usize],
    pub log2_sao_offset_scale_luma: u8,
    pub log2_sao_offset_scale_chroma: u8,
    pub pps_act_y_qp_offset_plus5: i8,
    pub pps_act_cb_qp_offset_plus5: i8,
    pub pps_act_cr_qp_offset_plus5: i8,
    pub pps_num_palette_predictor_initializer: u8,
    pub luma_bit_depth_entry_minus8: u8,
    pub chroma_bit_depth_entry_minus8: u8,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[test]
fn bindgen_test_layout_StdVideoH265PictureParameterSet() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoH265PictureParameterSet>(),
        144usize,
        concat!("Size of: ", stringify!(StdVideoH265PictureParameterSet))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoH265PictureParameterSet>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoH265PictureParameterSet))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_pic_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_seq_parameter_set_id
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).num_extra_slice_header_bits
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_extra_slice_header_bits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .num_ref_idx_l0_default_active_minus1 as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l0_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .num_ref_idx_l1_default_active_minus1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_ref_idx_l1_default_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).init_qp_minus26 as *const _
                as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(init_qp_minus26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).diff_cu_qp_delta_depth
                as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(diff_cu_qp_delta_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_cb_qp_offset as *const _
                as usize
        },
        11usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_cr_qp_offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).num_tile_columns_minus1
                as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_tile_columns_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).num_tile_rows_minus1
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(num_tile_rows_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).column_width_minus1
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(column_width_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).row_height_minus1
                as *const _ as usize
        },
        54usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(row_height_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_beta_offset_div2
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_tc_offset_div2
                as *const _ as usize
        },
        97usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .log2_parallel_merge_level_minus2 as *const _ as usize
        },
        98usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_parallel_merge_level_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pScalingLists as *const _
                as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pScalingLists)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .log2_max_transform_skip_block_size_minus2 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_max_transform_skip_block_size_minus2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .diff_cu_chroma_qp_offset_depth as *const _ as usize
        },
        113usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(diff_cu_chroma_qp_offset_depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .chroma_qp_offset_list_len_minus1 as *const _ as usize
        },
        114usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(chroma_qp_offset_list_len_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).cb_qp_offset_list
                as *const _ as usize
        },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(cb_qp_offset_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).cr_qp_offset_list
                as *const _ as usize
        },
        121usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(cr_qp_offset_list)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).log2_sao_offset_scale_luma
                as *const _ as usize
        },
        127usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_sao_offset_scale_luma)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).log2_sao_offset_scale_chroma
                as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(log2_sao_offset_scale_chroma)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_act_y_qp_offset_plus5
                as *const _ as usize
        },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_y_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_act_cb_qp_offset_plus5
                as *const _ as usize
        },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_cb_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pps_act_cr_qp_offset_plus5
                as *const _ as usize
        },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_act_cr_qp_offset_plus5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .pps_num_palette_predictor_initializer as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pps_num_palette_predictor_initializer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).luma_bit_depth_entry_minus8
                as *const _ as usize
        },
        133usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(luma_bit_depth_entry_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>()))
                .chroma_bit_depth_entry_minus8 as *const _ as usize
        },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(chroma_bit_depth_entry_minus8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoH265PictureParameterSet>())).pPredictorPaletteEntries
                as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoH265PictureParameterSet),
            "::",
            stringify!(pPredictorPaletteEntries)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265PictureInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH265PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265PictureInfoFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH265PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH265PictureInfoFlags)
        )
    );
}
impl StdVideoDecodeH265PictureInfoFlags {
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsReference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IsReference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        IrapPicFlag: u32,
        IdrPicFlag: u32,
        IsReference: u32,
        short_term_ref_pic_set_sps_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::std::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::std::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IsReference: u32 = unsafe { ::std::mem::transmute(IsReference) };
            IsReference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::std::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfo {
    pub flags: StdVideoDecodeH265PictureInfoFlags,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub PicOrderCntVal: i32,
    pub NumBitsForSTRefPicSetInSlice: u16,
    pub NumDeltaPocsOfRefRpsIdx: u8,
    pub RefPicSetStCurrBefore: [u8; 8usize],
    pub RefPicSetStCurrAfter: [u8; 8usize],
    pub RefPicSetLtCurr: [u8; 8usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265PictureInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH265PictureInfo>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265PictureInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH265PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH265PictureInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).sps_video_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).pps_seq_parameter_set_id
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).pps_pic_parameter_set_id
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).num_short_term_ref_pic_sets
                as *const _ as usize
        },
        7usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(num_short_term_ref_pic_sets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).PicOrderCntVal as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).NumBitsForSTRefPicSetInSlice
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(NumBitsForSTRefPicSetInSlice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).NumDeltaPocsOfRefRpsIdx
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(NumDeltaPocsOfRefRpsIdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).RefPicSetStCurrBefore
                as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetStCurrBefore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).RefPicSetStCurrAfter
                as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetStCurrAfter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265PictureInfo>())).RefPicSetLtCurr as *const _
                as usize
        },
        31usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265PictureInfo),
            "::",
            stringify!(RefPicSetLtCurr)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265ReferenceInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoDecodeH265ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoDecodeH265ReferenceInfoFlags)
        )
    );
}
impl StdVideoDecodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_non_existing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_non_existing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
        is_non_existing: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::std::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_non_existing: u32 = unsafe { ::std::mem::transmute(is_non_existing) };
            is_non_existing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfo {
    pub flags: StdVideoDecodeH265ReferenceInfoFlags,
    pub PicOrderCntVal: i32,
}
#[test]
fn bindgen_test_layout_StdVideoDecodeH265ReferenceInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoDecodeH265ReferenceInfo>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoDecodeH265ReferenceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoDecodeH265ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoDecodeH265ReferenceInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265ReferenceInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoDecodeH265ReferenceInfo>())).PicOrderCntVal as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoDecodeH265ReferenceInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTableFlags {
    pub luma_weight_l0_flag: u32,
    pub chroma_weight_l0_flag: u32,
    pub luma_weight_l1_flag: u32,
    pub chroma_weight_l1_flag: u32,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264WeightTableFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264WeightTableFlags>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264WeightTableFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264WeightTableFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264WeightTableFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTableFlags>())).luma_weight_l0_flag
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(luma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTableFlags>())).chroma_weight_l0_flag
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(chroma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTableFlags>())).luma_weight_l1_flag
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(luma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTableFlags>())).chroma_weight_l1_flag
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTableFlags),
            "::",
            stringify!(chroma_weight_l1_flag)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTable {
    pub flags: StdVideoEncodeH264WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub chroma_log2_weight_denom: u8,
    pub luma_weight_l0: [i8; 32usize],
    pub luma_offset_l0: [i8; 32usize],
    pub chroma_weight_l0: [[i8; 2usize]; 32usize],
    pub chroma_offset_l0: [[i8; 2usize]; 32usize],
    pub luma_weight_l1: [i8; 32usize],
    pub luma_offset_l1: [i8; 32usize],
    pub chroma_weight_l1: [[i8; 2usize]; 32usize],
    pub chroma_offset_l1: [[i8; 2usize]; 32usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264WeightTable() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264WeightTable>(),
        404usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264WeightTable))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264WeightTable>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264WeightTable))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).luma_log2_weight_denom
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).chroma_log2_weight_denom
                as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).luma_weight_l0 as *const _
                as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).luma_offset_l0 as *const _
                as usize
        },
        50usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).chroma_weight_l0 as *const _
                as usize
        },
        82usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).chroma_offset_l0 as *const _
                as usize
        },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).luma_weight_l1 as *const _
                as usize
        },
        210usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).luma_offset_l1 as *const _
                as usize
        },
        242usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).chroma_weight_l1 as *const _
                as usize
        },
        274usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264WeightTable>())).chroma_offset_l1 as *const _
                as usize
        },
        338usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264WeightTable),
            "::",
            stringify!(chroma_offset_l1)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeaderFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264SliceHeaderFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264SliceHeaderFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264SliceHeaderFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264SliceHeaderFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264SliceHeaderFlags)
        )
    );
}
impl StdVideoEncodeH264SliceHeaderFlags {
    #[inline]
    pub fn direct_spatial_mv_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_spatial_mv_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn adaptive_ref_pic_marking_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_adaptive_ref_pic_marking_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_prior_references_available_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_prior_references_available_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        direct_spatial_mv_pred_flag: u32,
        num_ref_idx_active_override_flag: u32,
        no_output_of_prior_pics_flag: u32,
        adaptive_ref_pic_marking_mode_flag: u32,
        no_prior_references_available_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let direct_spatial_mv_pred_flag: u32 =
                unsafe { ::std::mem::transmute(direct_spatial_mv_pred_flag) };
            direct_spatial_mv_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::std::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::std::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let adaptive_ref_pic_marking_mode_flag: u32 =
                unsafe { ::std::mem::transmute(adaptive_ref_pic_marking_mode_flag) };
            adaptive_ref_pic_marking_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let no_prior_references_available_flag: u32 =
                unsafe { ::std::mem::transmute(no_prior_references_available_flag) };
            no_prior_references_available_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264PictureInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264PictureInfoFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264PictureInfoFlags)
        )
    );
}
impl StdVideoEncodeH264PictureInfoFlags {
    #[inline]
    pub fn idr_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_idr_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        idr_flag: u32,
        is_reference_flag: u32,
        used_for_long_term_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let idr_flag: u32 = unsafe { ::std::mem::transmute(idr_flag) };
            idr_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_reference_flag: u32 = unsafe { ::std::mem::transmute(is_reference_flag) };
            is_reference_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264ReferenceInfoFlags)
        )
    );
}
impl StdVideoEncodeH264ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefMgmtFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefMgmtFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264RefMgmtFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264RefMgmtFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264RefMgmtFlags>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264RefMgmtFlags))
    );
}
impl StdVideoEncodeH264RefMgmtFlags {
    #[inline]
    pub fn ref_pic_list_modification_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_l1_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_l1_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_l0_flag: u32,
        ref_pic_list_modification_l1_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_l0_flag: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_l0_flag) };
            ref_pic_list_modification_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_l1_flag: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_l1_flag) };
            ref_pic_list_modification_l1_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefListModEntry {
    pub modification_of_pic_nums_idc: StdVideoH264ModificationOfPicNumsIdc,
    pub abs_diff_pic_num_minus1: u16,
    pub long_term_pic_num: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefListModEntry() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264RefListModEntry>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264RefListModEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264RefListModEntry>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264RefListModEntry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefListModEntry>()))
                .modification_of_pic_nums_idc as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(modification_of_pic_nums_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefListModEntry>())).abs_diff_pic_num_minus1
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(abs_diff_pic_num_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefListModEntry>())).long_term_pic_num
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefListModEntry),
            "::",
            stringify!(long_term_pic_num)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefPicMarkingEntry {
    pub operation: StdVideoH264MemMgmtControlOp,
    pub difference_of_pic_nums_minus1: u16,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
    pub max_long_term_frame_idx_plus1: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefPicMarkingEntry() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264RefPicMarkingEntry>(),
        12usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264RefPicMarkingEntry>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefPicMarkingEntry>())).operation as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(operation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefPicMarkingEntry>()))
                .difference_of_pic_nums_minus1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(difference_of_pic_nums_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefPicMarkingEntry>())).long_term_pic_num
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(long_term_pic_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefPicMarkingEntry>())).long_term_frame_idx
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(long_term_frame_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefPicMarkingEntry>()))
                .max_long_term_frame_idx_plus1 as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefPicMarkingEntry),
            "::",
            stringify!(max_long_term_frame_idx_plus1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefMemMgmtCtrlOperations {
    pub flags: StdVideoEncodeH264RefMgmtFlags,
    pub refList0ModOpCount: u8,
    pub pRefList0ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub refList1ModOpCount: u8,
    pub pRefList1ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub refPicMarkingOpCount: u8,
    pub pRefPicMarkingOperations: *const StdVideoEncodeH264RefPicMarkingEntry,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264RefMemMgmtCtrlOperations() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264RefMemMgmtCtrlOperations>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264RefMemMgmtCtrlOperations>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .refList0ModOpCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(refList0ModOpCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .pRefList0ModOperations as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(pRefList0ModOperations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .refList1ModOpCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(refList1ModOpCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .pRefList1ModOperations as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(pRefList1ModOperations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .refPicMarkingOpCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(refPicMarkingOpCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264RefMemMgmtCtrlOperations>()))
                .pRefPicMarkingOperations as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264RefMemMgmtCtrlOperations),
            "::",
            stringify!(pRefPicMarkingOperations)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfo {
    pub flags: StdVideoEncodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub pictureType: StdVideoH264PictureType,
    pub frame_num: u32,
    pub PicOrderCnt: i32,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264PictureInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264PictureInfo>(),
        20usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264PictureInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264PictureInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).seq_parameter_set_id
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).pic_parameter_set_id
                as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).pictureType as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(pictureType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).frame_num as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(frame_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264PictureInfo>())).PicOrderCnt as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264PictureInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfo {
    pub flags: StdVideoEncodeH264ReferenceInfoFlags,
    pub FrameNum: u32,
    pub PicOrderCnt: i32,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264ReferenceInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264ReferenceInfo>(),
        16usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264ReferenceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264ReferenceInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264ReferenceInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264ReferenceInfo>())).FrameNum as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(FrameNum)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264ReferenceInfo>())).PicOrderCnt as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(PicOrderCnt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264ReferenceInfo>())).long_term_pic_num
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(long_term_pic_num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264ReferenceInfo>())).long_term_frame_idx
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264ReferenceInfo),
            "::",
            stringify!(long_term_frame_idx)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeader {
    pub flags: StdVideoEncodeH264SliceHeaderFlags,
    pub first_mb_in_slice: u32,
    pub slice_type: StdVideoH264SliceType,
    pub idr_pic_id: u16,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub cabac_init_idc: StdVideoH264CabacInitIdc,
    pub disable_deblocking_filter_idc: StdVideoH264DisableDeblockingFilterIdc,
    pub slice_alpha_c0_offset_div2: i8,
    pub slice_beta_offset_div2: i8,
    pub pWeightTable: *const StdVideoEncodeH264WeightTable,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH264SliceHeader() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH264SliceHeader>(),
        40usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH264SliceHeader))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH264SliceHeader>(),
        8usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH264SliceHeader))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).first_mb_in_slice as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(first_mb_in_slice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).slice_type as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).idr_pic_id as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(idr_pic_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).num_ref_idx_l0_active_minus1
                as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).num_ref_idx_l1_active_minus1
                as *const _ as usize
        },
        15usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).cabac_init_idc as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(cabac_init_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).disable_deblocking_filter_idc
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(disable_deblocking_filter_idc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).slice_alpha_c0_offset_div2
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_alpha_c0_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).slice_beta_offset_div2
                as *const _ as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH264SliceHeader>())).pWeightTable as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH264SliceHeader),
            "::",
            stringify!(pWeightTable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTableFlags {
    pub luma_weight_l0_flag: u16,
    pub chroma_weight_l0_flag: u16,
    pub luma_weight_l1_flag: u16,
    pub chroma_weight_l1_flag: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265WeightTableFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265WeightTableFlags>(),
        8usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265WeightTableFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265WeightTableFlags>(),
        2usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265WeightTableFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTableFlags>())).luma_weight_l0_flag
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(luma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTableFlags>())).chroma_weight_l0_flag
                as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(chroma_weight_l0_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTableFlags>())).luma_weight_l1_flag
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(luma_weight_l1_flag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTableFlags>())).chroma_weight_l1_flag
                as *const _ as usize
        },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTableFlags),
            "::",
            stringify!(chroma_weight_l1_flag)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTable {
    pub flags: StdVideoEncodeH265WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub delta_chroma_log2_weight_denom: i8,
    pub delta_luma_weight_l0: [i8; 15usize],
    pub luma_offset_l0: [i8; 15usize],
    pub delta_chroma_weight_l0: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l0: [[i8; 2usize]; 15usize],
    pub delta_luma_weight_l1: [i8; 15usize],
    pub luma_offset_l1: [i8; 15usize],
    pub delta_chroma_weight_l1: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l1: [[i8; 2usize]; 15usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265WeightTable() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265WeightTable>(),
        190usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265WeightTable))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265WeightTable>(),
        2usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265WeightTable))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).luma_log2_weight_denom
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_chroma_log2_weight_denom
                as *const _ as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_log2_weight_denom)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_luma_weight_l0
                as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_luma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).luma_offset_l0 as *const _
                as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_chroma_weight_l0
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_weight_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_chroma_offset_l0
                as *const _ as usize
        },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_offset_l0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_luma_weight_l1
                as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_luma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).luma_offset_l1 as *const _
                as usize
        },
        115usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(luma_offset_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_chroma_weight_l1
                as *const _ as usize
        },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_weight_l1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265WeightTable>())).delta_chroma_offset_l1
                as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265WeightTable),
            "::",
            stringify!(delta_chroma_offset_l1)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeaderFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265SliceSegmentHeaderFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265SliceSegmentHeaderFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeaderFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265SliceSegmentHeaderFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265SliceSegmentHeaderFlags)
        )
    );
}
impl StdVideoEncodeH265SliceSegmentHeaderFlags {
    #[inline]
    pub fn first_slice_segment_in_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_first_slice_segment_in_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segment_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segment_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_output_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_output_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_temporal_mvp_enable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_temporal_mvp_enable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_luma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_chroma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mvd_l1_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mvd_l1_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_deblocking_filter_disable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_deblocking_filter_disable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn collocated_from_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_collocated_from_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        first_slice_segment_in_pic_flag: u32,
        no_output_of_prior_pics_flag: u32,
        dependent_slice_segment_flag: u32,
        pic_output_flag: u32,
        short_term_ref_pic_set_sps_flag: u32,
        slice_temporal_mvp_enable_flag: u32,
        slice_sao_luma_flag: u32,
        slice_sao_chroma_flag: u32,
        num_ref_idx_active_override_flag: u32,
        mvd_l1_zero_flag: u32,
        cabac_init_flag: u32,
        slice_deblocking_filter_disable_flag: u32,
        collocated_from_l0_flag: u32,
        slice_loop_filter_across_slices_enabled_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_slice_segment_in_pic_flag: u32 =
                unsafe { ::std::mem::transmute(first_slice_segment_in_pic_flag) };
            first_slice_segment_in_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::std::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let dependent_slice_segment_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segment_flag) };
            dependent_slice_segment_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let pic_output_flag: u32 = unsafe { ::std::mem::transmute(pic_output_flag) };
            pic_output_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::std::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let slice_temporal_mvp_enable_flag: u32 =
                unsafe { ::std::mem::transmute(slice_temporal_mvp_enable_flag) };
            slice_temporal_mvp_enable_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let slice_sao_luma_flag: u32 = unsafe { ::std::mem::transmute(slice_sao_luma_flag) };
            slice_sao_luma_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let slice_sao_chroma_flag: u32 =
                unsafe { ::std::mem::transmute(slice_sao_chroma_flag) };
            slice_sao_chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::std::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let mvd_l1_zero_flag: u32 = unsafe { ::std::mem::transmute(mvd_l1_zero_flag) };
            mvd_l1_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let cabac_init_flag: u32 = unsafe { ::std::mem::transmute(cabac_init_flag) };
            cabac_init_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let slice_deblocking_filter_disable_flag: u32 =
                unsafe { ::std::mem::transmute(slice_deblocking_filter_disable_flag) };
            slice_deblocking_filter_disable_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let collocated_from_l0_flag: u32 =
                unsafe { ::std::mem::transmute(collocated_from_l0_flag) };
            collocated_from_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let slice_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_loop_filter_across_slices_enabled_flag) };
            slice_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeader {
    pub flags: StdVideoEncodeH265SliceSegmentHeaderFlags,
    pub slice_type: StdVideoH265SliceType,
    pub num_short_term_ref_pic_sets: u8,
    pub slice_segment_address: u32,
    pub short_term_ref_pic_set_idx: u8,
    pub num_long_term_sps: u8,
    pub num_long_term_pics: u8,
    pub collocated_ref_idx: u8,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub MaxNumMergeCand: u8,
    pub slice_cb_qp_offset: i8,
    pub slice_cr_qp_offset: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_tc_offset_div2: i8,
    pub slice_act_y_qp_offset: i8,
    pub slice_act_cb_qp_offset: i8,
    pub slice_act_cr_qp_offset: i8,
    pub pWeightTable: *const StdVideoEncodeH265WeightTable,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265SliceSegmentHeader() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265SliceSegmentHeader>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265SliceSegmentHeader>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_type as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>()))
                .num_short_term_ref_pic_sets as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(num_short_term_ref_pic_sets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_segment_address
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_segment_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>()))
                .short_term_ref_pic_set_idx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(short_term_ref_pic_set_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).num_long_term_sps
                as *const _ as usize
        },
        17usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(num_long_term_sps)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).num_long_term_pics
                as *const _ as usize
        },
        18usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(num_long_term_pics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).collocated_ref_idx
                as *const _ as usize
        },
        19usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(collocated_ref_idx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>()))
                .num_ref_idx_l0_active_minus1 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(num_ref_idx_l0_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>()))
                .num_ref_idx_l1_active_minus1 as *const _ as usize
        },
        21usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(num_ref_idx_l1_active_minus1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).MaxNumMergeCand
                as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(MaxNumMergeCand)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_cb_qp_offset
                as *const _ as usize
        },
        23usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_cr_qp_offset
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_beta_offset_div2
                as *const _ as usize
        },
        25usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_beta_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_tc_offset_div2
                as *const _ as usize
        },
        26usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_tc_offset_div2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_act_y_qp_offset
                as *const _ as usize
        },
        27usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_y_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_act_cb_qp_offset
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_cb_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).slice_act_cr_qp_offset
                as *const _ as usize
        },
        29usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(slice_act_cr_qp_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265SliceSegmentHeader>())).pWeightTable
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265SliceSegmentHeader),
            "::",
            stringify!(pWeightTable)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceModificationFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceModificationFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265ReferenceModificationFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceModificationFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265ReferenceModificationFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceModificationFlags)
        )
    );
}
impl StdVideoEncodeH265ReferenceModificationFlags {
    #[inline]
    pub fn ref_pic_list_modification_flag_l0(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l0(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_flag_l1(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_flag_l0: u32,
        ref_pic_list_modification_flag_l1: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_flag_l0: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_flag_l0) };
            ref_pic_list_modification_flag_l0 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_flag_l1: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_flag_l1) };
            ref_pic_list_modification_flag_l1 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceModifications {
    pub flags: StdVideoEncodeH265ReferenceModificationFlags,
    pub referenceList0ModificationsCount: u8,
    pub pReferenceList0Modifications: *const u8,
    pub referenceList1ModificationsCount: u8,
    pub pReferenceList1Modifications: *const u8,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceModifications() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265ReferenceModifications>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceModifications)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265ReferenceModifications>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceModifications)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceModifications>())).flags as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceModifications),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceModifications>()))
                .referenceList0ModificationsCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceModifications),
            "::",
            stringify!(referenceList0ModificationsCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceModifications>()))
                .pReferenceList0Modifications as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceModifications),
            "::",
            stringify!(pReferenceList0Modifications)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceModifications>()))
                .referenceList1ModificationsCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceModifications),
            "::",
            stringify!(referenceList1ModificationsCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceModifications>()))
                .pReferenceList1Modifications as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceModifications),
            "::",
            stringify!(pReferenceList1Modifications)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265PictureInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265PictureInfoFlags>(),
        4usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265PictureInfoFlags))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265PictureInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265PictureInfoFlags)
        )
    );
}
impl StdVideoEncodeH265PictureInfoFlags {
    #[inline]
    pub fn is_reference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn discardable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_discardable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_layer_bla_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_layer_bla_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_reference_flag: u32,
        IrapPicFlag: u32,
        long_term_flag: u32,
        discardable_flag: u32,
        cross_layer_bla_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_reference_flag: u32 = unsafe { ::std::mem::transmute(is_reference_flag) };
            is_reference_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::std::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let long_term_flag: u32 = unsafe { ::std::mem::transmute(long_term_flag) };
            long_term_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let discardable_flag: u32 = unsafe { ::std::mem::transmute(discardable_flag) };
            discardable_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cross_layer_bla_flag: u32 = unsafe { ::std::mem::transmute(cross_layer_bla_flag) };
            cross_layer_bla_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfo {
    pub flags: StdVideoEncodeH265PictureInfoFlags,
    pub PictureType: StdVideoH265PictureType,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265PictureInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265PictureInfo>(),
        20usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265PictureInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265PictureInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265PictureInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).PictureType as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(PictureType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).sps_video_parameter_set_id
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(sps_video_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).pps_seq_parameter_set_id
                as *const _ as usize
        },
        9usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pps_seq_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).pps_pic_parameter_set_id
                as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(pps_pic_parameter_set_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).PicOrderCntVal as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265PictureInfo>())).TemporalId as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265PictureInfo),
            "::",
            stringify!(TemporalId)
        )
    );
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceInfoFlags() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Size of: ",
            stringify!(StdVideoEncodeH265ReferenceInfoFlags)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265ReferenceInfoFlags>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(StdVideoEncodeH265ReferenceInfoFlags)
        )
    );
}
impl StdVideoEncodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::std::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfo {
    pub flags: StdVideoEncodeH265ReferenceInfoFlags,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
}
#[test]
fn bindgen_test_layout_StdVideoEncodeH265ReferenceInfo() {
    assert_eq!(
        ::std::mem::size_of::<StdVideoEncodeH265ReferenceInfo>(),
        12usize,
        concat!("Size of: ", stringify!(StdVideoEncodeH265ReferenceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<StdVideoEncodeH265ReferenceInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(StdVideoEncodeH265ReferenceInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceInfo>())).flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceInfo>())).PicOrderCntVal as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(PicOrderCntVal)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<StdVideoEncodeH265ReferenceInfo>())).TemporalId as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(StdVideoEncodeH265ReferenceInfo),
            "::",
            stringify!(TemporalId)
        )
    );
}
