/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.ExtensionHandlerImpl;
import com.jclark.xsl.sax.MultiNamespaceResult;
import com.jclark.xsl.sax.ResultTypeHandler;
import com.jclark.xsl.sax.SingleNamespaceResult;
import com.jclark.xsl.sax.XMLProcessorImpl;
import com.jclark.xsl.sax.XSLProcessor;
import com.jclark.xsl.tr.Engine;
import com.jclark.xsl.tr.EngineImpl;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.Sheet;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLProcessorImpl
implements XSLProcessor {
    private XMLProcessorImpl sourceLoader;
    private XMLProcessorImpl sheetLoader;
    private Parser sheetParser;
    private Parser sourceParser;
    private Sheet sheet;
    private Engine engine;
    private InputSource sheetSource;
    private Result result;
    private ResultTypeHandler resultTypeHandler;
    private DocumentHandler documentHandler;
    private boolean stripNamespaces = false;

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            Node node;
            if (this.sheet == null) {
                this.phase(1);
                node = this.sheetLoader.load(this.sheetSource, this.engine.getSheetLoadContext(), this.engine.getNameTable());
                this.phase(2);
                this.sheet = this.engine.createSheet(node);
            } else {
                this.phase(1);
                this.phase(2);
            }
            if (this.resultTypeHandler != null) {
                this.resultTypeHandler.setResultType(this.sheet.getResultNamespace(), this.sheet.getIndentResult());
            }
            if (this.documentHandler == null) {
                this.documentHandler = new HandlerBase();
            }
            this.result = this.stripNamespaces ? new SingleNamespaceResult(this.documentHandler) : new MultiNamespaceResult(this.documentHandler);
            this.phase(3);
            node = this.sourceLoader.load(inputSource, this.sheet.getSourceLoadContext(), this.engine.getNameTable());
            this.phase(4);
            this.sheet.process(node, this.result);
            this.phase(5);
            return;
        }
        catch (XSLException xSLException) {
            Serializable serializable;
            String string = null;
            int n = -1;
            Node node = xSLException.getNode();
            if (node != null) {
                serializable = node.getURL();
                if (serializable != null) {
                    string = ((URL)serializable).toString();
                }
                n = node.getLineNumber();
            }
            serializable = xSLException.getException();
            String string2 = xSLException.getMessage();
            if (string != null || n != -1) {
                throw new SAXParseException(string2, null, string, n, -1, (Exception)serializable);
            }
            if (string2 == null) {
                if (serializable instanceof SAXException) {
                    throw (SAXException)serializable;
                }
                if (serializable instanceof IOException) {
                    throw (IOException)serializable;
                }
            }
            throw new SAXException(string2, (Exception)serializable);
        }
    }

    public void parse(String string) throws SAXException, IOException {
        this.parse(new InputSource(string));
    }

    public XSLProcessorImpl(Parser parser, Parser parser2) {
        this.sourceParser = parser;
        this.sheetParser = parser2;
        this.sourceLoader = new XMLProcessorImpl(parser);
        this.sheetLoader = parser == parser2 ? this.sourceLoader : new XMLProcessorImpl(parser2);
        this.engine = new EngineImpl(this.sheetLoader, new ExtensionHandlerImpl());
        this.sheet = null;
    }

    public XSLProcessorImpl(Parser parser) {
        this(parser, parser);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.sheetParser.setLocale(locale);
        this.sourceParser.setLocale(locale);
    }

    public void setResultTypeHandler(ResultTypeHandler resultTypeHandler) {
        this.resultTypeHandler = resultTypeHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.sheetParser.setEntityResolver(entityResolver);
        this.sourceParser.setEntityResolver(entityResolver);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.sheetParser.setErrorHandler(errorHandler);
        this.sourceParser.setErrorHandler(errorHandler);
    }

    void phase(int n) {
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setStripNamespaces(boolean bl) {
        this.stripNamespaces = bl;
    }

    public void setStylesheet(InputSource inputSource) {
        this.sheetSource = inputSource;
        this.sheet = null;
    }
}

