/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Indenter;
import com.jclark.xsl.sax.OutputStreamConverter;
import com.jclark.xsl.sax.ResultTypeHandler;
import com.jclark.xsl.sax.XMLOutputHandler;
import com.jclark.xsl.sax.XSLProcessor;
import java.io.OutputStream;
import org.xml.sax.DocumentHandler;

public class ResultTypeHandlerImpl
implements ResultTypeHandler {
    private XSLProcessor processor;
    private OutputStream out;
    private static final String[][] resultNamespaceMap = new String[][]{{"http://www.w3.org/TR/REC-html40", "com.jclark.xsl.sax.HTMLOutputHandler"}};

    private static String getClassForNamespace(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < resultNamespaceMap.length) {
            if (string.equals(resultNamespaceMap[n][0])) {
                return resultNamespaceMap[n][1];
            }
            ++n;
        }
        if (string.startsWith("java:")) {
            return string.substring(5);
        }
        return null;
    }

    public ResultTypeHandlerImpl(XSLProcessor xSLProcessor) {
        this.processor = xSLProcessor;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setResultType(String string, boolean bl) {
        String string2 = ResultTypeHandlerImpl.getClassForNamespace(string);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                DocumentHandler documentHandler = (DocumentHandler)clazz.newInstance();
                if (documentHandler instanceof OutputStreamConverter) {
                    ((OutputStreamConverter)((Object)documentHandler)).setOutputStream(this.out);
                }
                this.processor.setDocumentHandler(documentHandler);
                this.processor.setStripNamespaces(true);
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassCastException classCastException) {}
        }
        DocumentHandler documentHandler = new XMLOutputHandler(this.out, 1);
        if (bl) {
            documentHandler = new Indenter(documentHandler);
        }
        this.processor.setDocumentHandler(documentHandler);
        this.processor.setStripNamespaces(false);
    }
}

